/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.xml;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Objects;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.codec.xml.XmlCodec;
import org.opendaylight.yangtools.yang.data.codec.xml.XmlCodecFactory;
import org.opendaylight.yangtools.yang.data.util.AbstractModuleStringInstanceIdentifierCodec;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextTree;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.TypedDataSchemaNode;

final class XmlStringInstanceIdentifierCodec
extends AbstractModuleStringInstanceIdentifierCodec
implements XmlCodec<YangInstanceIdentifier> {
    private static final ThreadLocal<Deque<NamespaceContext>> TL_CONTEXT = new ThreadLocal();
    private final @NonNull DataSchemaContextTree dataContextTree;
    private final @NonNull XmlCodecFactory codecFactory;
    private final @NonNull SchemaContext context;

    XmlStringInstanceIdentifierCodec(SchemaContext context, XmlCodecFactory xmlCodecFactory) {
        this.context = Objects.requireNonNull(context);
        this.dataContextTree = DataSchemaContextTree.from((SchemaContext)context);
        this.codecFactory = Objects.requireNonNull(xmlCodecFactory);
    }

    protected Module moduleForPrefix(String prefix) {
        String prefixedNS = XmlStringInstanceIdentifierCodec.getNamespaceContext().getNamespaceURI(prefix);
        Iterator modules = this.context.findModules(URI.create(prefixedNS)).iterator();
        return modules.hasNext() ? (Module)modules.next() : null;
    }

    protected String prefixForNamespace(URI namespace) {
        Iterator modules = this.context.findModules(namespace).iterator();
        return modules.hasNext() ? ((Module)modules.next()).getName() : null;
    }

    protected DataSchemaContextTree getDataContextTree() {
        return this.dataContextTree;
    }

    protected Object deserializeKeyValue(DataSchemaNode schemaNode, String value) {
        Objects.requireNonNull(schemaNode, "schemaNode cannot be null");
        Preconditions.checkArgument((boolean)(schemaNode instanceof LeafSchemaNode), (Object)"schemaNode must be of type LeafSchemaNode");
        XmlCodec objectXmlCodec = (XmlCodec)this.codecFactory.codecFor((TypedDataSchemaNode)((LeafSchemaNode)schemaNode));
        return objectXmlCodec.parseValue(XmlStringInstanceIdentifierCodec.getNamespaceContext(), value);
    }

    public Class<YangInstanceIdentifier> getDataType() {
        return YangInstanceIdentifier.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public YangInstanceIdentifier parseValue(NamespaceContext ctx, String str) {
        XmlStringInstanceIdentifierCodec.pushNamespaceContext(ctx);
        try {
            YangInstanceIdentifier yangInstanceIdentifier = this.deserialize(str);
            return yangInstanceIdentifier;
        }
        finally {
            XmlStringInstanceIdentifierCodec.popNamespaceContext();
        }
    }

    @Override
    public void writeValue(XMLStreamWriter ctx, YangInstanceIdentifier value) throws XMLStreamException {
        ctx.writeCharacters(this.serialize(value));
    }

    private static NamespaceContext getNamespaceContext() {
        return TL_CONTEXT.get().getFirst();
    }

    private static void popNamespaceContext() {
        Deque<NamespaceContext> stack = TL_CONTEXT.get();
        stack.pop();
        if (stack.isEmpty()) {
            TL_CONTEXT.set(null);
        }
    }

    private static void pushNamespaceContext(NamespaceContext context) {
        Deque<NamespaceContext> stack = TL_CONTEXT.get();
        if (stack == null) {
            stack = new ArrayDeque<NamespaceContext>(1);
            TL_CONTEXT.set(stack);
        }
        stack.push(context);
    }
}

