/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.xml;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.AbstractMap;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stax.StAXSource;
import org.opendaylight.yangtools.odlext.model.api.YangModeledAnyXmlSchemaNode;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.DOMSourceXMLStreamReader;
import org.opendaylight.yangtools.yang.data.codec.xml.XmlCodec;
import org.opendaylight.yangtools.yang.data.codec.xml.XmlCodecFactory;
import org.opendaylight.yangtools.yang.data.util.AbstractNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.AnyXmlNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.CompositeNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.ContainerNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.LeafListEntryNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.LeafListNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.LeafNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.ListEntryNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.ListNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.OperationAsContainer;
import org.opendaylight.yangtools.yang.data.util.ParserStreamUtils;
import org.opendaylight.yangtools.yang.data.util.SimpleNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.YangModeledAnyXmlNodeDataWithSchema;
import org.opendaylight.yangtools.yang.model.api.AnyXmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.OperationDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypedDataSchemaNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@Beta
@NotThreadSafe
public final class XmlParserStream
implements Closeable,
Flushable {
    private static final Logger LOG = LoggerFactory.getLogger(XmlParserStream.class);
    private static final String XML_STANDARD_VERSION = "1.0";
    private static final String COM_SUN_TRANSFORMER = "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl";
    private static final TransformerFactory TRANSFORMER_FACTORY;
    private final NormalizedNodeStreamWriter writer;
    private final XmlCodecFactory codecs;
    private final DataSchemaNode parentNode;
    private final boolean strictParsing;

    private XmlParserStream(NormalizedNodeStreamWriter writer, XmlCodecFactory codecs, DataSchemaNode parentNode, boolean strictParsing) {
        this.writer = Objects.requireNonNull(writer);
        this.codecs = Objects.requireNonNull(codecs);
        this.parentNode = parentNode;
        this.strictParsing = strictParsing;
    }

    public static XmlParserStream create(NormalizedNodeStreamWriter writer, XmlCodecFactory codecs, SchemaNode parentNode) {
        return XmlParserStream.create(writer, codecs, parentNode, true);
    }

    public static XmlParserStream create(NormalizedNodeStreamWriter writer, XmlCodecFactory codecs, SchemaNode parentNode, boolean strictParsing) {
        DataSchemaNode parent;
        if (parentNode instanceof DataSchemaNode) {
            parent = (DataSchemaNode)parentNode;
        } else if (parentNode instanceof OperationDefinition) {
            parent = OperationAsContainer.of((OperationDefinition)((OperationDefinition)parentNode));
        } else {
            throw new IllegalArgumentException("Illegal parent node " + parentNode);
        }
        return new XmlParserStream(writer, codecs, parent, strictParsing);
    }

    public static XmlParserStream create(NormalizedNodeStreamWriter writer, SchemaContext schemaContext, SchemaNode parentNode) {
        return XmlParserStream.create(writer, schemaContext, parentNode, true);
    }

    public static XmlParserStream create(NormalizedNodeStreamWriter writer, SchemaContext schemaContext, SchemaNode parentNode, boolean strictParsing) {
        return XmlParserStream.create(writer, XmlCodecFactory.create(schemaContext), parentNode, strictParsing);
    }

    public XmlParserStream parse(XMLStreamReader reader) throws XMLStreamException, URISyntaxException, IOException, ParserConfigurationException, SAXException {
        if (reader.hasNext()) {
            ContainerNodeDataWithSchema nodeDataWithSchema;
            reader.nextTag();
            if (this.parentNode instanceof ContainerSchemaNode) {
                nodeDataWithSchema = new ContainerNodeDataWithSchema(this.parentNode);
            } else if (this.parentNode instanceof ListSchemaNode) {
                nodeDataWithSchema = new ListNodeDataWithSchema(this.parentNode);
            } else if (this.parentNode instanceof YangModeledAnyXmlSchemaNode) {
                nodeDataWithSchema = new YangModeledAnyXmlNodeDataWithSchema((YangModeledAnyXmlSchemaNode)this.parentNode);
            } else if (this.parentNode instanceof AnyXmlSchemaNode) {
                nodeDataWithSchema = new AnyXmlNodeDataWithSchema(this.parentNode);
            } else if (this.parentNode instanceof LeafSchemaNode) {
                nodeDataWithSchema = new LeafNodeDataWithSchema(this.parentNode);
            } else if (this.parentNode instanceof LeafListSchemaNode) {
                nodeDataWithSchema = new LeafListNodeDataWithSchema(this.parentNode);
            } else {
                throw new IllegalStateException("Unsupported schema node type " + this.parentNode.getClass() + ".");
            }
            this.read(reader, (AbstractNodeDataWithSchema)nodeDataWithSchema, reader.getLocalName());
            nodeDataWithSchema.write(this.writer);
        }
        return this;
    }

    @Beta
    public XmlParserStream traverse(DOMSource src) throws XMLStreamException, URISyntaxException, IOException, ParserConfigurationException, SAXException {
        return this.parse((XMLStreamReader)((Object)new DOMSourceXMLStreamReader(src)));
    }

    private static ImmutableMap<QName, String> getElementAttributes(XMLStreamReader in) {
        Preconditions.checkState((boolean)in.isStartElement(), (Object)"Attributes can be extracted only from START_ELEMENT.");
        LinkedHashMap<QName, String> attributes = new LinkedHashMap<QName, String>();
        for (int attrIndex = 0; attrIndex < in.getAttributeCount(); ++attrIndex) {
            String attributeNS = in.getAttributeNamespace(attrIndex);
            if (attributeNS == null) {
                attributeNS = "";
            }
            if ("http://www.w3.org/2000/xmlns/".equals(attributeNS)) continue;
            QName qName = QName.create((URI)URI.create(attributeNS), (String)in.getAttributeLocalName(attrIndex));
            attributes.put(qName, in.getAttributeValue(attrIndex));
        }
        return ImmutableMap.copyOf(attributes);
    }

    private static Document readAnyXmlValue(XMLStreamReader in) throws XMLStreamException {
        XMLStreamReader inWrapper = in.getVersion() == null ? new StreamReaderDelegate(in){

            @Override
            public String getVersion() {
                String ver = super.getVersion();
                return ver != null ? ver : XmlParserStream.XML_STANDARD_VERSION;
            }
        } : in;
        DOMResult result = new DOMResult();
        try {
            TRANSFORMER_FACTORY.newTransformer().transform(new StAXSource(inWrapper), result);
        }
        catch (TransformerException e) {
            throw new XMLStreamException("Unable to read anyxml value", e);
        }
        return (Document)result.getNode();
    }

    private void read(XMLStreamReader in, AbstractNodeDataWithSchema parent, String rootElement) throws XMLStreamException, URISyntaxException {
        if (!in.hasNext()) {
            return;
        }
        if (parent instanceof LeafNodeDataWithSchema || parent instanceof LeafListEntryNodeDataWithSchema) {
            parent.setAttributes(XmlParserStream.getElementAttributes(in));
            this.setValue(parent, in.getElementText().trim(), in.getNamespaceContext());
            if (XmlParserStream.isNextEndDocument(in)) {
                return;
            }
            if (!XmlParserStream.isAtElement(in)) {
                in.nextTag();
            }
            return;
        }
        if (parent instanceof ListEntryNodeDataWithSchema || parent instanceof ContainerNodeDataWithSchema) {
            parent.setAttributes(XmlParserStream.getElementAttributes(in));
        }
        if (parent instanceof LeafListNodeDataWithSchema || parent instanceof ListNodeDataWithSchema) {
            String xmlElementName = in.getLocalName();
            while (xmlElementName.equals(parent.getSchema().getQName().getLocalName())) {
                this.read(in, XmlParserStream.newEntryNode(parent), rootElement);
                if (in.getEventType() == 8 || in.getEventType() == 2) break;
                xmlElementName = in.getLocalName();
            }
            return;
        }
        if (parent instanceof AnyXmlNodeDataWithSchema) {
            this.setValue(parent, XmlParserStream.readAnyXmlValue(in), in.getNamespaceContext());
            if (XmlParserStream.isNextEndDocument(in)) {
                return;
            }
            if (!XmlParserStream.isAtElement(in)) {
                in.nextTag();
            }
            return;
        }
        if (parent instanceof YangModeledAnyXmlSchemaNode) {
            parent.setAttributes(XmlParserStream.getElementAttributes(in));
        }
        block0 : switch (in.nextTag()) {
            case 1: {
                HashSet<AbstractMap.SimpleImmutableEntry<String, String>> namesakes = new HashSet<AbstractMap.SimpleImmutableEntry<String, String>>();
                while (in.hasNext()) {
                    String xmlElementNamespace;
                    String xmlElementName = in.getLocalName();
                    DataSchemaNode parentSchema = parent.getSchema();
                    String parentSchemaName = parentSchema.getQName().getLocalName();
                    if (parentSchemaName.equals(xmlElementName) && in.getEventType() == 2) {
                        if (XmlParserStream.isNextEndDocument(in) || XmlParserStream.isAtElement(in)) break block0;
                        in.nextTag();
                        break block0;
                    }
                    if (in.isEndElement() && rootElement.equals(xmlElementName)) break block0;
                    if (parentSchema instanceof YangModeledAnyXmlSchemaNode) {
                        parentSchema = ((YangModeledAnyXmlSchemaNode)parentSchema).getSchemaOfAnyXmlData();
                    }
                    if (!namesakes.add(new AbstractMap.SimpleImmutableEntry<String, String>(xmlElementNamespace = in.getNamespaceURI(), xmlElementName))) {
                        throw new XMLStreamException(String.format("Duplicate namespace \"%s\" element \"%s\" in XML input", xmlElementNamespace, xmlElementName), in.getLocation());
                    }
                    Deque childDataSchemaNodes = ParserStreamUtils.findSchemaNodeByNameAndNamespace((DataSchemaNode)parentSchema, (String)xmlElementName, (URI)new URI(xmlElementNamespace));
                    if (childDataSchemaNodes.isEmpty()) {
                        if (!this.strictParsing) {
                            LOG.debug("Skipping unknown node ns=\"{}\" localName=\"{}\" at path {}", new Object[]{xmlElementNamespace, xmlElementName, parentSchema.getPath()});
                            XmlParserStream.skipUnknownNode(in);
                            continue;
                        }
                        throw new XMLStreamException(String.format("Schema for node with name %s and namespace %s does not exist at %s", xmlElementName, xmlElementNamespace, parentSchema.getPath(), in.getLocation()));
                    }
                    this.read(in, ((CompositeNodeDataWithSchema)parent).addChild(childDataSchemaNodes), rootElement);
                }
                break;
            }
            case 2: {
                if (XmlParserStream.isNextEndDocument(in) || XmlParserStream.isAtElement(in)) break;
                in.nextTag();
                break;
            }
        }
    }

    private static boolean isNextEndDocument(XMLStreamReader in) throws XMLStreamException {
        return !in.hasNext() || in.next() == 8;
    }

    private static boolean isAtElement(XMLStreamReader in) {
        return in.getEventType() == 1 || in.getEventType() == 2;
    }

    private static void skipUnknownNode(XMLStreamReader in) throws XMLStreamException {
        int levelOfNesting = 0;
        while (in.hasNext()) {
            in.next();
            if (!XmlParserStream.isAtElement(in)) {
                in.nextTag();
            }
            if (in.isStartElement()) {
                ++levelOfNesting;
            }
            if (!in.isEndElement()) continue;
            if (levelOfNesting == 0) break;
            --levelOfNesting;
        }
        in.nextTag();
    }

    private void setValue(AbstractNodeDataWithSchema parent, Object value, NamespaceContext nsContext) {
        Preconditions.checkArgument((boolean)(parent instanceof SimpleNodeDataWithSchema), (String)"Node %s is not a simple type", (Object)parent.getSchema().getQName());
        SimpleNodeDataWithSchema parentSimpleNode = (SimpleNodeDataWithSchema)parent;
        Preconditions.checkArgument((parentSimpleNode.getValue() == null ? 1 : 0) != 0, (String)"Node '%s' has already set its value to '%s'", (Object)parentSimpleNode.getSchema().getQName(), (Object)parentSimpleNode.getValue());
        parentSimpleNode.setValue(this.translateValueByType(value, parentSimpleNode.getSchema(), nsContext));
    }

    private Object translateValueByType(Object value, DataSchemaNode node, NamespaceContext namespaceCtx) {
        if (node instanceof AnyXmlSchemaNode) {
            Preconditions.checkArgument((boolean)(value instanceof Document));
            return new DOMSource(((Document)value).getDocumentElement());
        }
        Preconditions.checkArgument((boolean)(node instanceof TypedDataSchemaNode));
        Preconditions.checkArgument((boolean)(value instanceof String));
        return ((XmlCodec)this.codecs.codecFor((TypedDataSchemaNode)node)).parseValue(namespaceCtx, (String)value);
    }

    private static AbstractNodeDataWithSchema newEntryNode(AbstractNodeDataWithSchema parent) {
        Object newChild = parent instanceof ListNodeDataWithSchema ? new ListEntryNodeDataWithSchema(parent.getSchema()) : new LeafListEntryNodeDataWithSchema(parent.getSchema());
        ((CompositeNodeDataWithSchema)parent).addChild((AbstractNodeDataWithSchema)newChild);
        return newChild;
    }

    @Override
    public void close() throws IOException {
        this.writer.flush();
        this.writer.close();
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    static {
        TransformerFactory fa = TransformerFactory.newInstance();
        if (!fa.getFeature("http://javax.xml.transform.stax.StAXSource/feature")) {
            LOG.warn("Platform-default TransformerFactory {} does not support StAXSource, attempting fallback to {}", (Object)fa, (Object)COM_SUN_TRANSFORMER);
            fa = TransformerFactory.newInstance(COM_SUN_TRANSFORMER, null);
            if (!fa.getFeature("http://javax.xml.transform.stax.StAXSource/feature")) {
                throw new TransformerFactoryConfigurationError("No TransformerFactory supporting StAXResult found.");
            }
        }
        TRANSFORMER_FACTORY = fa;
    }
}

