/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.xml;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;
import java.util.Objects;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamAttributeWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.DOMSourceXMLStreamReader;
import org.opendaylight.yangtools.yang.data.codec.xml.SchemaAwareXMLStreamNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.SchemalessXMLStreamNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.StreamWriterFacade;
import org.opendaylight.yangtools.yang.data.codec.xml.ValueWriter;
import org.opendaylight.yangtools.yang.data.impl.codec.SchemaTracker;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class XMLStreamNormalizedNodeStreamWriter<T>
implements NormalizedNodeStreamAttributeWriter {
    private static final TransformerFactory TRANSFORMER_FACTORY = TransformerFactory.newInstance();
    private final @NonNull StreamWriterFacade facade;

    XMLStreamNormalizedNodeStreamWriter(XMLStreamWriter writer) {
        this.facade = new StreamWriterFacade(writer);
    }

    public static @NonNull NormalizedNodeStreamWriter create(XMLStreamWriter writer, SchemaContext context) {
        return XMLStreamNormalizedNodeStreamWriter.create(writer, context, (DataNodeContainer)context);
    }

    public static @NonNull NormalizedNodeStreamWriter create(XMLStreamWriter writer, SchemaContext context, DataNodeContainer rootNode) {
        return new SchemaAwareXMLStreamNormalizedNodeStreamWriter(writer, context, SchemaTracker.create((DataNodeContainer)rootNode));
    }

    public static @NonNull NormalizedNodeStreamWriter create(XMLStreamWriter writer, SchemaContext context, SchemaPath path) {
        return new SchemaAwareXMLStreamNormalizedNodeStreamWriter(writer, context, SchemaTracker.create((SchemaContext)context, (SchemaPath)path));
    }

    public static @NonNull NormalizedNodeStreamWriter createSchemaless(XMLStreamWriter writer) {
        return new SchemalessXMLStreamNormalizedNodeStreamWriter(writer);
    }

    @Deprecated
    public static String toString(Element xml) {
        try {
            Transformer transformer = TRANSFORMER_FACTORY.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult result = new StreamResult(new StringWriter());
            transformer.transform(new DOMSource(xml), result);
            return result.getWriter().toString();
        }
        catch (IllegalArgumentException | TransformerException e) {
            throw new IllegalStateException("Unable to serialize xml element " + xml, e);
        }
    }

    abstract void writeValue(@NonNull ValueWriter var1, QName var2, @NonNull Object var3, T var4) throws XMLStreamException;

    abstract void startList(YangInstanceIdentifier.NodeIdentifier var1);

    abstract void startListItem(YangInstanceIdentifier.PathArgument var1) throws IOException;

    final void writeElement(QName qname, Object value, @Nullable Map<QName, String> attributes, T context) throws IOException {
        this.startElement(qname);
        if (attributes != null) {
            this.writeAttributes(attributes);
        }
        if (value != null) {
            try {
                this.writeValue(this.facade, qname, value, context);
            }
            catch (XMLStreamException e) {
                throw new IOException("Failed to write value", e);
            }
        }
        this.endElement();
    }

    final void startElement(QName qname) throws IOException {
        try {
            this.facade.writeStartElement(qname);
        }
        catch (XMLStreamException e) {
            throw new IOException("Failed to start element", e);
        }
    }

    final void endElement() throws IOException {
        try {
            this.facade.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new IOException("Failed to end element", e);
        }
    }

    final void anyxmlNode(QName qname, Object value) throws IOException {
        if (value != null) {
            Preconditions.checkArgument((boolean)(value instanceof DOMSource), (String)"AnyXML value must be DOMSource, not %s", (Object)value);
            DOMSource domSource = (DOMSource)value;
            Node domNode = Objects.requireNonNull(domSource.getNode());
            Preconditions.checkArgument((boolean)domNode.getNodeName().equals(qname.getLocalName()));
            Preconditions.checkArgument((boolean)domNode.getNamespaceURI().equals(qname.getNamespace().toString()));
            try {
                this.facade.writeStreamReader(new DOMSourceXMLStreamReader(domSource));
            }
            catch (XMLStreamException e) {
                throw new IOException("Unable to transform anyXml(" + qname + ") value: " + domNode, e);
            }
        }
    }

    public final void startContainerNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint, Map<QName, String> attributes) throws IOException {
        this.startContainerNode(name, childSizeHint);
        this.writeAttributes(attributes);
    }

    public final void startYangModeledAnyXmlNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint, Map<QName, String> attributes) throws IOException {
        this.startYangModeledAnyXmlNode(name, childSizeHint);
        this.writeAttributes(attributes);
    }

    public final void startUnkeyedListItem(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint, Map<QName, String> attributes) throws IOException {
        this.startUnkeyedListItem(name, childSizeHint);
        this.writeAttributes(attributes);
    }

    public final void startUnkeyedListItem(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.startListItem((YangInstanceIdentifier.PathArgument)name);
    }

    public final void startMapEntryNode(YangInstanceIdentifier.NodeIdentifierWithPredicates identifier, int childSizeHint, Map<QName, String> attributes) throws IOException {
        this.startMapEntryNode(identifier, childSizeHint);
        this.writeAttributes(attributes);
    }

    public final void startMapEntryNode(YangInstanceIdentifier.NodeIdentifierWithPredicates identifier, int childSizeHint) throws IOException {
        this.startListItem((YangInstanceIdentifier.PathArgument)identifier);
    }

    public final void startUnkeyedList(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.startList(name);
    }

    public final void startMapNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.startList(name);
    }

    public final void startOrderedMapNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.startList(name);
    }

    public final void close() throws IOException {
        try {
            this.facade.close();
        }
        catch (XMLStreamException e) {
            throw new IOException("Failed to close writer", e);
        }
    }

    public final void flush() throws IOException {
        try {
            this.facade.flush();
        }
        catch (XMLStreamException e) {
            throw new IOException("Failed to flush writer", e);
        }
    }

    private void writeAttributes(@NonNull Map<QName, String> attributes) throws IOException {
        if (!attributes.isEmpty()) {
            try {
                this.facade.writeAttributes(attributes);
            }
            catch (XMLStreamException e) {
                throw new IOException("Unable to emit attributes " + attributes, e);
            }
        }
    }
}

