/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.xml;

import com.google.common.base.Strings;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.codec.xml.DOMSourceXMLStreamReader;
import org.opendaylight.yangtools.yang.data.codec.xml.RandomPrefix;
import org.opendaylight.yangtools.yang.data.codec.xml.ValueWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class StreamWriterFacade
extends ValueWriter {
    private static final Logger LOG = LoggerFactory.getLogger(StreamWriterFacade.class);
    private static final Set<String> BROKEN_NAMESPACES = ConcurrentHashMap.newKeySet();
    private final XMLStreamWriter writer;
    private final RandomPrefix prefixes;
    private QName openElement;

    StreamWriterFacade(XMLStreamWriter writer) {
        this.writer = Objects.requireNonNull(writer);
        this.prefixes = new RandomPrefix(writer.getNamespaceContext());
    }

    @Override
    void writeCharacters(String text) throws XMLStreamException {
        if (!Strings.isNullOrEmpty((String)text)) {
            this.flushElement();
            this.writer.writeCharacters(text);
        }
    }

    @Override
    void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        this.flushElement();
        this.writer.writeNamespace(prefix, namespaceURI);
    }

    @Override
    void writeAttribute(String localName, String value) throws XMLStreamException {
        this.flushElement();
        this.writer.writeAttribute(localName, value);
    }

    @Override
    void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        this.flushElement();
        this.writer.writeAttribute(prefix, namespaceURI, localName, value);
    }

    @Override
    NamespaceContext getNamespaceContext() {
        return this.writer.getNamespaceContext();
    }

    private void flushElement() throws XMLStreamException {
        if (this.openElement != null) {
            this.writer.writeStartElement("", this.openElement.getLocalName(), this.openElement.getNamespace().toString());
            this.openElement = null;
        }
    }

    void writeStartElement(QName qname) throws XMLStreamException {
        this.flushElement();
        String ns = qname.getNamespace().toString();
        NamespaceContext context = this.writer.getNamespaceContext();
        boolean reuseNamespace = context != null ? ns.equals(context.getNamespaceURI("")) : "".equals(this.writer.getPrefix(ns));
        if (!reuseNamespace) {
            this.writer.writeStartElement("", qname.getLocalName(), ns);
            this.writer.writeDefaultNamespace(ns);
        } else {
            this.openElement = qname;
        }
    }

    void writeEndElement() throws XMLStreamException {
        if (this.openElement != null) {
            this.writer.writeEmptyElement("", this.openElement.getLocalName(), this.openElement.getNamespace().toString());
            this.openElement = null;
        } else {
            this.writer.writeEndElement();
        }
    }

    void writeAttributes(Map<QName, String> attributes) throws XMLStreamException {
        this.flushElement();
        for (Map.Entry<QName, String> entry : attributes.entrySet()) {
            QName qname = entry.getKey();
            String namespace = qname.getNamespace().toString();
            if (!Strings.isNullOrEmpty((String)namespace)) {
                String prefix = this.getPrefix(qname.getNamespace(), namespace);
                this.writer.writeAttribute(prefix, namespace, qname.getLocalName(), entry.getValue());
                continue;
            }
            this.writer.writeAttribute(qname.getLocalName(), entry.getValue());
        }
    }

    private String getPrefix(URI uri, String str) throws XMLStreamException {
        String prefix = this.writer.getPrefix(str);
        if (prefix != null) {
            return prefix;
        }
        if (BROKEN_NAMESPACES.add(str)) {
            LOG.info("Namespace {} was not bound, please fix the caller", (Object)str, (Object)new Throwable());
        }
        return this.prefixes.encodePrefix(uri);
    }

    void close() throws XMLStreamException {
        XMLStreamException failure = null;
        try {
            this.flushElement();
        }
        catch (XMLStreamException e) {
            failure = e;
            throw e;
        }
        finally {
            try {
                this.writer.close();
            }
            catch (XMLStreamException e) {
                if (failure != null) {
                    failure.addSuppressed(e);
                }
                throw e;
            }
        }
    }

    void flush() throws XMLStreamException {
        this.flushElement();
        this.writer.flush();
    }

    void writeStreamReader(DOMSourceXMLStreamReader reader) throws XMLStreamException {
        this.flushElement();
        block14: while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    this.forwardStartElement(reader);
                    continue block14;
                }
                case 2: {
                    this.writer.writeEndElement();
                    continue block14;
                }
                case 3: {
                    this.forwardProcessingInstruction(reader);
                    continue block14;
                }
                case 4: {
                    this.writer.writeCharacters(reader.getText());
                    continue block14;
                }
                case 5: {
                    this.writer.writeComment(reader.getText());
                    continue block14;
                }
                case 6: {
                    continue block14;
                }
                case 7: 
                case 8: {
                    continue block14;
                }
                case 9: {
                    this.writer.writeEntityRef(reader.getLocalName());
                    continue block14;
                }
                case 10: {
                    this.forwardAttributes(reader);
                    continue block14;
                }
                case 11: {
                    this.writer.writeDTD(reader.getText());
                    continue block14;
                }
                case 12: {
                    this.writer.writeCData(reader.getText());
                    continue block14;
                }
                case 13: {
                    this.forwardNamespaces(reader);
                    continue block14;
                }
            }
            throw new IllegalStateException("Unhandled event " + event);
        }
    }

    private void forwardAttributes(DOMSourceXMLStreamReader reader) throws XMLStreamException {
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String localName = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            String prefix = reader.getAttributePrefix(i);
            if (prefix != null) {
                this.writer.writeAttribute(prefix, reader.getAttributeNamespace(i), localName, value);
                continue;
            }
            this.writer.writeAttribute(localName, value);
        }
    }

    private void forwardNamespaces(DOMSourceXMLStreamReader reader) throws XMLStreamException {
        for (int i = 0; i < reader.getNamespaceCount(); ++i) {
            this.writer.writeNamespace(reader.getNamespacePrefix(i), reader.getNamespaceURI(i));
        }
    }

    private void forwardProcessingInstruction(DOMSourceXMLStreamReader reader) throws XMLStreamException {
        String target = reader.getPITarget();
        String data = reader.getPIData();
        if (data != null) {
            this.writer.writeProcessingInstruction(target, data);
        } else {
            this.writer.writeProcessingInstruction(target);
        }
    }

    private void forwardStartElement(DOMSourceXMLStreamReader reader) throws XMLStreamException {
        String localName = reader.getLocalName();
        String prefix = reader.getPrefix();
        if (prefix != null) {
            this.writer.writeStartElement(prefix, localName, reader.getNamespaceURI());
        } else {
            this.writer.writeStartElement(localName);
        }
        this.forwardNamespaces(reader);
        this.forwardAttributes(reader);
    }
}

