/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.xml;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.codec.xml.ValueWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.XMLStreamNormalizedNodeStreamWriter;

final class SchemalessXMLStreamNormalizedNodeStreamWriter
extends XMLStreamNormalizedNodeStreamWriter<Object> {
    private final Deque<ContainerType> containerTypeStack = new ArrayDeque<ContainerType>();

    SchemalessXMLStreamNormalizedNodeStreamWriter(XMLStreamWriter writer) {
        super(writer);
    }

    public void leafNode(YangInstanceIdentifier.NodeIdentifier name, Object value, Map<QName, String> attributes) throws IOException {
        this.writeElement(name.getNodeType(), value, attributes, null);
    }

    public void leafNode(YangInstanceIdentifier.NodeIdentifier name, Object value) throws IOException {
        this.writeElement(name.getNodeType(), value, Collections.emptyMap(), null);
    }

    public void leafSetEntryNode(QName name, Object value, Map<QName, String> attributes) throws IOException {
        this.writeElement(name, value, attributes, null);
    }

    public void leafSetEntryNode(QName name, Object value) throws IOException {
        this.writeElement(name, value, Collections.emptyMap(), null);
    }

    public void startLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.containerTypeStack.push(ContainerType.LEAF_SET);
    }

    public void startOrderedLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.containerTypeStack.push(ContainerType.LEAF_SET);
    }

    public void startContainerNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.containerTypeStack.push(ContainerType.CONTAINER);
        this.startElement(name.getNodeType());
    }

    public void startChoiceNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.containerTypeStack.push(ContainerType.CHOICE);
    }

    public void startAugmentationNode(YangInstanceIdentifier.AugmentationIdentifier identifier) throws IOException {
        this.containerTypeStack.push(ContainerType.AUGMENTATION);
    }

    public void anyxmlNode(YangInstanceIdentifier.NodeIdentifier name, Object value) throws IOException {
        this.anyxmlNode(name.getNodeType(), value);
    }

    public void startYangModeledAnyXmlNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.containerTypeStack.push(ContainerType.ANY_XML);
        this.startElement(name.getNodeType());
    }

    @Override
    void writeValue(ValueWriter xmlWriter, QName qname, Object value, Object context) throws XMLStreamException {
        xmlWriter.writeToStringCharacters(value);
    }

    @Override
    void startList(YangInstanceIdentifier.NodeIdentifier name) {
        this.containerTypeStack.push(ContainerType.LIST);
    }

    @Override
    void startListItem(YangInstanceIdentifier.PathArgument name) throws IOException {
        this.containerTypeStack.push(ContainerType.LIST_ITEM);
        this.startElement(name.getNodeType());
    }

    public void endNode() throws IOException {
        ContainerType type = this.containerTypeStack.pop();
        switch (type) {
            case CONTAINER: 
            case LIST_ITEM: 
            case ANY_XML: {
                this.endElement();
                break;
            }
        }
    }

    private static enum ContainerType {
        CONTAINER,
        LEAF_SET,
        LIST,
        LIST_ITEM,
        ANY_XML,
        CHOICE,
        AUGMENTATION;

    }
}

