/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.xml;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.net.URI;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

class RandomPrefix {
    private static final String LOOKUP = "abcdefghiknoprstABCDEFGHIKNOPRST";
    private static final int MASK = 31;
    private static final int SHIFT = 5;
    private int counter = 0;
    private final BiMap<URI, String> prefixes = HashBiMap.create();
    private final NamespaceContext context;

    RandomPrefix(NamespaceContext context) {
        this.context = context;
    }

    Iterable<Map.Entry<URI, String>> getPrefixes() {
        return this.prefixes.entrySet();
    }

    String encodePrefix(URI namespace) {
        String prefix = (String)this.prefixes.get((Object)namespace);
        if (prefix != null) {
            return prefix;
        }
        if (this.context != null && (prefix = this.context.getPrefix(namespace.toString())) != null) {
            return prefix;
        }
        do {
            prefix = RandomPrefix.encode(this.counter);
            ++this.counter;
        } while (this.alreadyUsedPrefix(prefix));
        this.prefixes.put((Object)namespace, (Object)prefix);
        return prefix;
    }

    private boolean alreadyUsedPrefix(String prefix) {
        if (this.context == null) {
            return false;
        }
        String str = this.context.getNamespaceURI(prefix);
        return str != null && !"".equals(str);
    }

    @VisibleForTesting
    static int decode(String str) {
        int ret = 0;
        for (char c : str.toCharArray()) {
            int idx = LOOKUP.indexOf(c);
            Preconditions.checkArgument((idx != -1 ? 1 : 0) != 0, (String)"Invalid string %s", (Object)str);
            ret = (ret << 5) + idx;
        }
        return ret;
    }

    @VisibleForTesting
    static String encode(int num) {
        StringBuilder sb = new StringBuilder();
        do {
            sb.append(LOOKUP.charAt(num & 0x1F));
        } while ((num >>>= 5) != 0);
        return sb.reverse().toString();
    }
}

