/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.exificient.main.api.stream;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.opendaylight.netconf.shaded.exificient.core.EXIBodyDecoder;
import org.opendaylight.netconf.shaded.exificient.core.EXIFactory;
import org.opendaylight.netconf.shaded.exificient.core.EXIStreamDecoder;
import org.opendaylight.netconf.shaded.exificient.core.container.DocType;
import org.opendaylight.netconf.shaded.exificient.core.container.NamespaceDeclaration;
import org.opendaylight.netconf.shaded.exificient.core.container.ProcessingInstruction;
import org.opendaylight.netconf.shaded.exificient.core.context.QNameContext;
import org.opendaylight.netconf.shaded.exificient.core.exceptions.EXIException;
import org.opendaylight.netconf.shaded.exificient.core.grammars.event.EventType;
import org.opendaylight.netconf.shaded.exificient.core.values.Value;
import org.opendaylight.netconf.shaded.exificient.main.api.stream.EmptyLocation;
import org.opendaylight.netconf.shaded.exificient.main.helpers.DefaultSchemaIdResolver;

public class StAXDecoder
implements XMLStreamReader {
    protected EXIFactory noOptionsFactory;
    protected EXIStreamDecoder exiStream;
    protected EXIBodyDecoder decoder;
    protected boolean exiBodyOnly = false;
    protected QNameContext element;
    protected List<AttributeContainer> attributes;
    protected Value characters;
    protected DocType docType;
    protected char[] entityReference;
    protected char[] comment;
    protected ProcessingInstruction processingInstruction;
    protected boolean namespacePrefixes = false;
    protected EventType eventType;
    protected EventType preReadEventType;
    protected EXINamespaceContext nsContext;
    String endElementPrefix;
    List<NamespaceDeclaration> eePrefixes;

    public StAXDecoder(EXIFactory noOptionsFactory) throws EXIException {
        this.noOptionsFactory = noOptionsFactory;
        if (noOptionsFactory.getSchemaIdResolver() == null) {
            noOptionsFactory.setSchemaIdResolver(new DefaultSchemaIdResolver());
        }
        this.exiStream = noOptionsFactory.createEXIStreamDecoder();
        this.attributes = new ArrayList<AttributeContainer>();
        this.nsContext = new EXINamespaceContext();
    }

    public void setInputStream(InputStream is) throws EXIException, IOException, XMLStreamException {
        this.parseHeader(is);
    }

    protected void initForEachRun() {
        this.eventType = null;
        this.preReadEventType = null;
        this.attributes.clear();
        if (this.noOptionsFactory.getFidelityOptions().isFidelityEnabled("PRESERVE_PREFIXES")) {
            this.namespacePrefixes = true;
        }
    }

    protected void parseHeader(InputStream is) throws EXIException, IOException, XMLStreamException {
        assert (is != null);
        assert (this.exiStream != null);
        this.decoder = this.exiBodyOnly ? this.exiStream.getBodyOnlyDecoder(is) : this.exiStream.decodeHeader(is);
        this.initForEachRun();
        this.eventType = this.decoder.next();
        assert (this.eventType == EventType.START_DOCUMENT);
        this.decoder.decodeStartDocument();
    }

    @Override
    public int getEventType() {
        return StAXDecoder.getEventType(this.eventType);
    }

    protected static int getEventType(EventType eventType) {
        assert (eventType != null);
        switch (eventType) {
            case START_DOCUMENT: {
                return 7;
            }
            case ATTRIBUTE_XSI_TYPE: 
            case ATTRIBUTE_XSI_NIL: 
            case ATTRIBUTE: 
            case ATTRIBUTE_NS: 
            case ATTRIBUTE_GENERIC: 
            case ATTRIBUTE_INVALID_VALUE: 
            case ATTRIBUTE_ANY_INVALID_VALUE: 
            case ATTRIBUTE_GENERIC_UNDECLARED: {
                return 10;
            }
            case START_ELEMENT: 
            case START_ELEMENT_NS: 
            case START_ELEMENT_GENERIC: 
            case START_ELEMENT_GENERIC_UNDECLARED: {
                return 1;
            }
            case END_ELEMENT: 
            case END_ELEMENT_UNDECLARED: {
                return 2;
            }
            case CHARACTERS: 
            case CHARACTERS_GENERIC: 
            case CHARACTERS_GENERIC_UNDECLARED: {
                return 4;
            }
            case END_DOCUMENT: {
                return 8;
            }
            case DOC_TYPE: {
                return 11;
            }
            case NAMESPACE_DECLARATION: {
                return 13;
            }
            case SELF_CONTAINED: {
                return -1;
            }
            case ENTITY_REFERENCE: {
                return 9;
            }
            case COMMENT: {
                return 5;
            }
            case PROCESSING_INSTRUCTION: {
                return 3;
            }
        }
        throw new RuntimeException("Unexpected EXI Event '" + (Object)((Object)eventType) + "' ");
    }

    @Override
    public int next() throws XMLStreamException {
        try {
            if (this.eventType == EventType.END_ELEMENT || this.eventType == EventType.END_ELEMENT_UNDECLARED) {
                this.nsContext.popNamespaceDeclarations();
            }
            if (this.preReadEventType == null) {
                this.eventType = this.decodeEvent(this.decoder.next());
            } else {
                this.eventType = this.preReadEventType;
                this.preReadEventType = null;
                this.decodeEvent(this.eventType);
            }
            int ev = this.getEventType();
            if (ev == 1) {
                this.handleAttributes();
            }
            return ev;
        }
        catch (Exception e) {
            throw new XMLStreamException(e);
        }
    }

    protected EventType decodeEvent(EventType nextEventType) throws EXIException, IOException {
        this.endElementPrefix = null;
        switch (nextEventType) {
            case START_DOCUMENT: {
                this.decoder.decodeStartDocument();
                break;
            }
            case END_DOCUMENT: {
                this.decoder.decodeEndDocument();
                break;
            }
            case ATTRIBUTE_XSI_NIL: {
                this.attributes.add(new AttributeContainer(this.decoder.decodeAttributeXsiNil(), this.decoder.getAttributeValue(), this.decoder.getAttributePrefix()));
                break;
            }
            case ATTRIBUTE_XSI_TYPE: {
                this.attributes.add(new AttributeContainer(this.decoder.decodeAttributeXsiType(), this.decoder.getAttributeValue(), this.decoder.getAttributePrefix()));
                break;
            }
            case ATTRIBUTE: 
            case ATTRIBUTE_NS: 
            case ATTRIBUTE_GENERIC: 
            case ATTRIBUTE_INVALID_VALUE: 
            case ATTRIBUTE_ANY_INVALID_VALUE: 
            case ATTRIBUTE_GENERIC_UNDECLARED: {
                this.attributes.add(new AttributeContainer(this.decoder.decodeAttribute(), this.decoder.getAttributeValue(), this.decoder.getAttributePrefix()));
                break;
            }
            case NAMESPACE_DECLARATION: {
                this.decoder.decodeNamespaceDeclaration();
                break;
            }
            case SELF_CONTAINED: {
                this.decoder.decodeStartSelfContainedFragment();
                break;
            }
            case START_ELEMENT: 
            case START_ELEMENT_NS: 
            case START_ELEMENT_GENERIC: 
            case START_ELEMENT_GENERIC_UNDECLARED: {
                this.element = this.decoder.decodeStartElement();
                break;
            }
            case END_ELEMENT: 
            case END_ELEMENT_UNDECLARED: {
                this.eePrefixes = this.decoder.getDeclaredPrefixDeclarations();
                this.endElementPrefix = this.decoder.getElementPrefix();
                this.element = this.decoder.decodeEndElement();
                break;
            }
            case CHARACTERS: 
            case CHARACTERS_GENERIC: 
            case CHARACTERS_GENERIC_UNDECLARED: {
                this.characters = this.decoder.decodeCharacters();
                break;
            }
            case DOC_TYPE: {
                this.docType = this.decoder.decodeDocType();
                break;
            }
            case ENTITY_REFERENCE: {
                this.entityReference = this.decoder.decodeEntityReference();
                break;
            }
            case COMMENT: {
                this.comment = this.decoder.decodeComment();
                break;
            }
            case PROCESSING_INSTRUCTION: {
                this.processingInstruction = this.decoder.decodeProcessingInstruction();
                break;
            }
            default: {
                throw new RuntimeException("Unexpected EXI Event '" + (Object)((Object)this.eventType) + "' ");
            }
        }
        return nextEventType;
    }

    @Override
    public void close() throws XMLStreamException {
    }

    protected void handleAttributes() throws EXIException, IOException {
        int ev;
        EventType et;
        assert (this.getEventType() == 1);
        this.attributes.clear();
        do {
            et = this.decoder.next();
            ev = StAXDecoder.getEventType(et);
            if (et != EventType.SELF_CONTAINED && ev != 10 && ev != 13) continue;
            this.decodeEvent(et);
        } while (et == EventType.SELF_CONTAINED || ev == 10 || ev == 13);
        List<NamespaceDeclaration> nsDecls = this.getNamespaceDeclarations();
        this.nsContext.pushNamespaceDeclarations(nsDecls);
        this.preReadEventType = et;
    }

    @Override
    public int getAttributeCount() {
        return this.attributes.size();
    }

    @Override
    public String getAttributeLocalName(int index) {
        return this.attributes.get((int)index).qname.getLocalName();
    }

    @Override
    public QName getAttributeName(int index) {
        return this.attributes.get((int)index).qname.getQName();
    }

    @Override
    public String getAttributeNamespace(int index) {
        return this.attributes.get((int)index).qname.getNamespaceUri();
    }

    @Override
    public String getAttributePrefix(int index) {
        return this.attributes.get((int)index).prefix;
    }

    @Override
    public String getAttributeType(int index) {
        return "CDATA";
    }

    @Override
    public String getAttributeValue(int index) {
        return this.attributes.get((int)index).value.toString();
    }

    @Override
    public String getAttributeValue(String namespaceURI, String localName) {
        for (AttributeContainer ac : this.attributes) {
            if (!ac.qname.getLocalName().equals(localName)) continue;
            if (namespaceURI == null) {
                return ac.value.toString();
            }
            if (!ac.qname.getNamespaceUri().equals(namespaceURI)) continue;
            return ac.value.toString();
        }
        return null;
    }

    @Override
    public String getCharacterEncodingScheme() {
        return null;
    }

    @Override
    public String getElementText() throws XMLStreamException {
        switch (this.getEventType()) {
            case 4: 
            case 6: {
                return this.characters.toString();
            }
        }
        throw new RuntimeException("Unexpected event, id=" + this.getEventType());
    }

    @Override
    public String getEncoding() {
        return null;
    }

    @Override
    public String getLocalName() {
        return this.element.getLocalName();
    }

    @Override
    public Location getLocation() {
        return EmptyLocation.getInstance();
    }

    @Override
    public QName getName() {
        QName qn = new QName(this.element.getNamespaceUri(), this.element.getLocalName(), this.getPrefix());
        return qn;
    }

    List<NamespaceDeclaration> getNamespaceDeclarations() {
        List<NamespaceDeclaration> result = this.eventType == EventType.END_ELEMENT || this.eventType == EventType.END_ELEMENT_UNDECLARED ? this.eePrefixes : this.decoder.getDeclaredPrefixDeclarations();
        return result != null ? result : Collections.emptyList();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.nsContext;
    }

    @Override
    public int getNamespaceCount() {
        List<NamespaceDeclaration> nsDecls = this.getNamespaceDeclarations();
        return nsDecls == null ? 0 : nsDecls.size();
    }

    @Override
    public String getNamespacePrefix(int index) {
        return this.getNamespaceDeclarations().get((int)index).prefix;
    }

    @Override
    public String getNamespaceURI(int index) {
        return this.getNamespaceDeclarations().get((int)index).namespaceURI;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        List<NamespaceDeclaration> nsDecls = this.getNamespaceDeclarations();
        for (int i = 0; i < nsDecls.size(); ++i) {
            NamespaceDeclaration nsDecl = nsDecls.get(i);
            if (!nsDecl.prefix.equals(prefix)) continue;
            return nsDecl.namespaceURI;
        }
        return null;
    }

    @Override
    public String getNamespaceURI() {
        return this.element.getNamespaceUri();
    }

    @Override
    public String getPIData() {
        return this.processingInstruction.data;
    }

    @Override
    public String getPITarget() {
        return this.processingInstruction.target;
    }

    @Override
    public String getPrefix() {
        if (this.endElementPrefix != null) {
            return this.endElementPrefix;
        }
        if (this.getEventType() == 1 || this.getEventType() == 2) {
            return this.decoder.getElementPrefix();
        }
        assert (this.getEventType() == 10);
        return this.decoder.getAttributePrefix();
    }

    @Override
    public Object getProperty(String arg0) throws IllegalArgumentException {
        return null;
    }

    @Override
    public String getText() {
        switch (this.getEventType()) {
            case 4: 
            case 6: {
                return this.characters.toString();
            }
            case 5: {
                return new String(this.comment);
            }
            case 9: {
                return new String(this.entityReference);
            }
            case 11: {
                return this.getDocTypeString();
            }
        }
        throw new RuntimeException("Unexpected event, id=" + this.getEventType());
    }

    private String getDocTypeString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<!DOCTYPE ");
        sb.append(this.docType.name);
        if (this.docType.publicID.length > 0) {
            sb.append(" PUBLIC ");
            sb.append('\"');
            sb.append(this.docType.publicID);
            sb.append('\"');
        }
        if (this.docType.systemID.length > 0) {
            if (this.docType.publicID.length == 0) {
                sb.append(" SYSTEM ");
            } else {
                sb.append(' ');
            }
            sb.append('\"');
            sb.append(this.docType.systemID);
            sb.append('\"');
        }
        if (this.docType.text.length > 0) {
            sb.append(' ');
            sb.append('[');
            sb.append(this.docType.text);
            sb.append(']');
        }
        sb.append('>');
        return sb.toString();
    }

    @Override
    public char[] getTextCharacters() {
        switch (this.getEventType()) {
            case 4: 
            case 6: {
                return this.characters.toString().toCharArray();
            }
            case 5: {
                return this.comment;
            }
            case 9: {
                return this.entityReference;
            }
            case 11: {
                return this.getDocTypeString().toCharArray();
            }
        }
        throw new RuntimeException("Unexpected event, id=" + this.getEventType());
    }

    @Override
    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        if (this.getTextLength() > target.length - targetStart) {
            throw new RuntimeException("Buffer too small!");
        }
        switch (this.getEventType()) {
            case 4: 
            case 6: {
                this.characters.getCharacters(target, targetStart);
                return length;
            }
            case 5: {
                System.arraycopy(this.comment, sourceStart, target, targetStart, length);
                return length;
            }
            case 9: {
                System.arraycopy(this.entityReference, sourceStart, target, targetStart, length);
                return length;
            }
            case 11: {
                char[] dt = this.getDocTypeString().toCharArray();
                System.arraycopy(dt, sourceStart, target, targetStart, length);
                return length;
            }
        }
        throw new RuntimeException("Unexpected event, id=" + this.getEventType());
    }

    @Override
    public int getTextLength() {
        switch (this.getEventType()) {
            case 4: 
            case 6: {
                return this.characters.getCharactersLength();
            }
            case 5: {
                return this.comment.length;
            }
            case 9: {
                return this.entityReference.length;
            }
        }
        throw new RuntimeException("Unexpected event, id=" + this.getEventType());
    }

    @Override
    public int getTextStart() {
        return 0;
    }

    @Override
    public String getVersion() {
        return null;
    }

    @Override
    public boolean hasName() {
        switch (this.getEventType()) {
            case 1: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        return this.eventType != EventType.END_DOCUMENT;
    }

    @Override
    public boolean hasText() {
        switch (this.getEventType()) {
            case 4: 
            case 5: 
            case 6: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isAttributeSpecified(int arg0) {
        return false;
    }

    @Override
    public boolean isCharacters() {
        return this.getEventType() == 4;
    }

    @Override
    public boolean isEndElement() {
        return this.getEventType() == 2;
    }

    @Override
    public boolean isStandalone() {
        return true;
    }

    @Override
    public boolean isStartElement() {
        return this.getEventType() == 1;
    }

    @Override
    public boolean isWhiteSpace() {
        switch (this.getEventType()) {
            case 4: {
                return this.characters.toString().trim().length() == 0;
            }
            case 12: {
                return false;
            }
            case 5: {
                return false;
            }
            case 6: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int nextTag() throws XMLStreamException {
        int eventType = this.next();
        while (eventType == 4 && this.isWhiteSpace() || eventType == 12 && this.isWhiteSpace() || eventType == 6 || eventType == 3 || eventType == 5) {
            eventType = this.next();
        }
        if (eventType != 1 && eventType != 2) {
            throw new XMLStreamException("expected start or end tag", this.getLocation());
        }
        return eventType;
    }

    @Override
    public void require(int type, String namespaceURI, String localName) throws XMLStreamException {
        int eventType = this.getEventType();
        if (eventType == type) {
            switch (eventType) {
                case 1: {
                    if (namespaceURI != null && !this.element.getNamespaceUri().equals(namespaceURI)) {
                        throw new XMLStreamException();
                    }
                    if (localName == null || this.element.getLocalName().equals(localName)) break;
                    throw new XMLStreamException();
                }
                case 10: {
                    throw new XMLStreamException();
                }
            }
        } else {
            throw new XMLStreamException();
        }
    }

    @Override
    public boolean standaloneSet() {
        return false;
    }

    class EXINamespaceContext
    implements NamespaceContext {
        List<List<NamespaceDeclaration>> _nsDecls = new ArrayList<List<NamespaceDeclaration>>();

        protected void pushNamespaceDeclarations(List<NamespaceDeclaration> nsDecls) {
            this._nsDecls.add(nsDecls);
        }

        protected List<NamespaceDeclaration> popNamespaceDeclarations() {
            return this._nsDecls.remove(this._nsDecls.size() - 1);
        }

        @Override
        public String getNamespaceURI(String prefix) {
            for (int k = this._nsDecls.size() - 1; k >= 0; --k) {
                List<NamespaceDeclaration> nsDecls = this._nsDecls.get(k);
                if (nsDecls == null) continue;
                for (int i = 0; i < nsDecls.size(); ++i) {
                    NamespaceDeclaration nsDecl = nsDecls.get(i);
                    if (!nsDecl.prefix.equals(prefix)) continue;
                    return nsDecl.namespaceURI;
                }
            }
            return null;
        }

        @Override
        public String getPrefix(String namespaceURI) {
            for (int k = this._nsDecls.size() - 1; k >= 0; --k) {
                List<NamespaceDeclaration> nsDecls = this._nsDecls.get(k);
                if (nsDecls == null) continue;
                for (int i = 0; i < nsDecls.size(); ++i) {
                    NamespaceDeclaration nsDecl = nsDecls.get(i);
                    if (!nsDecl.namespaceURI.equals(namespaceURI)) continue;
                    return nsDecl.prefix;
                }
            }
            return null;
        }

        public Iterator getPrefixes(String namespaceURI) {
            ArrayList<String> prefixes = new ArrayList<String>();
            for (int k = this._nsDecls.size() - 1; k >= 0; --k) {
                List<NamespaceDeclaration> nsDecls = this._nsDecls.get(k);
                if (nsDecls == null) continue;
                for (int i = 0; i < nsDecls.size(); ++i) {
                    NamespaceDeclaration nsDecl = nsDecls.get(i);
                    if (!nsDecl.namespaceURI.equals(namespaceURI)) continue;
                    prefixes.add(nsDecl.prefix);
                }
            }
            return prefixes.iterator();
        }
    }

    static class AttributeContainer {
        final QNameContext qname;
        final Value value;
        final String prefix;

        public AttributeContainer(QNameContext qname, Value value, String prefix) {
            this.qname = qname;
            this.value = value;
            this.prefix = prefix;
        }
    }
}

