/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.exificient.main.api.dom;

import java.io.IOException;
import java.io.OutputStream;
import org.opendaylight.netconf.shaded.exificient.core.EXIBodyEncoder;
import org.opendaylight.netconf.shaded.exificient.core.EXIFactory;
import org.opendaylight.netconf.shaded.exificient.core.EXIStreamEncoder;
import org.opendaylight.netconf.shaded.exificient.core.attributes.AttributeFactory;
import org.opendaylight.netconf.shaded.exificient.core.attributes.AttributeList;
import org.opendaylight.netconf.shaded.exificient.core.exceptions.EXIException;
import org.opendaylight.netconf.shaded.exificient.core.values.StringValue;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public class DOMWriter {
    protected EXIFactory factory;
    protected EXIStreamEncoder exiStream;
    protected EXIBodyEncoder exiBody;
    private AttributeList exiAttributes;
    protected boolean preserveWhitespaces;
    protected boolean preserveComments;
    protected boolean preservePIs;

    public DOMWriter(EXIFactory factory) throws EXIException {
        this.factory = factory;
        this.exiStream = factory.createEXIStreamEncoder();
        AttributeFactory attFactory = AttributeFactory.newInstance();
        this.exiAttributes = attFactory.createAttributeListInstance(factory);
        this.preserveComments = factory.getFidelityOptions().isFidelityEnabled("PRESERVE_COMMENTS");
        this.preservePIs = factory.getFidelityOptions().isFidelityEnabled("PRESERVE_PIS");
    }

    public void setOutput(OutputStream os) throws EXIException, IOException {
        this.exiBody = this.exiStream.encodeHeader(os);
    }

    public void encode(Document doc) throws EXIException, IOException {
        if (this.exiBody == null) {
            throw new EXIException("Please specify output stream");
        }
        this.exiBody.encodeStartDocument();
        this.encodeChildNodes(doc.getChildNodes());
        this.exiBody.encodeEndDocument();
        this.exiBody.flush();
    }

    public void encodeFragment(DocumentFragment docFragment) throws EXIException, IOException {
        if (this.exiBody == null) {
            throw new EXIException("Please specify output stream");
        }
        this.exiBody.encodeStartDocument();
        this.encodeChildNodes(docFragment.getChildNodes());
        this.exiBody.encodeEndDocument();
        this.exiBody.flush();
    }

    public void encode(Node n) throws EXIException, IOException {
        if (n.getNodeType() == 9) {
            this.encode((Document)n);
        } else if (n.getNodeType() == 11) {
            this.encodeFragment((DocumentFragment)n);
        } else {
            this.exiBody.encodeStartDocument();
            this.encodeNode(n);
            this.exiBody.encodeEndDocument();
            this.exiBody.flush();
        }
    }

    protected void encodeNode(Node root) throws EXIException, IOException {
        String prefix;
        assert (root.getNodeType() == 1);
        String namespaceURI = root.getNamespaceURI() == null ? "" : root.getNamespaceURI();
        String localName = root.getLocalName();
        if (localName == null) {
            localName = root.getNodeName();
        }
        if ((prefix = root.getPrefix()) == null) {
            prefix = "";
        }
        this.exiBody.encodeStartElement(namespaceURI, localName, prefix);
        NamedNodeMap attributes = root.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node at = attributes.item(i);
            if ("http://www.w3.org/2000/xmlns/".equals(at.getNamespaceURI())) {
                String pfx = at.getPrefix() == null ? "" : at.getLocalName();
                this.exiAttributes.addNamespaceDeclaration(at.getNodeValue(), pfx);
                continue;
            }
            String atLocalName = at.getLocalName();
            if (atLocalName == null) {
                atLocalName = at.getNodeName();
            }
            this.exiAttributes.addAttribute(at.getNamespaceURI(), atLocalName, at.getPrefix(), at.getNodeValue());
        }
        this.exiBody.encodeAttributeList(this.exiAttributes);
        this.exiAttributes.clear();
        NodeList children = root.getChildNodes();
        this.encodeChildNodes(children);
        this.exiBody.encodeEndElement();
    }

    protected void encodeChildNodes(NodeList children) throws EXIException, IOException {
        block10: for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            switch (n.getNodeType()) {
                case 1: {
                    this.encodeNode(n);
                    continue block10;
                }
                case 2: {
                    continue block10;
                }
                case 3: {
                    this.exiBody.encodeCharacters(new StringValue(n.getNodeValue()));
                    continue block10;
                }
                case 8: {
                    if (!this.preserveComments) continue block10;
                    String c = n.getNodeValue();
                    this.exiBody.encodeComment(c.toCharArray(), 0, c.length());
                    continue block10;
                }
                case 10: {
                    DocumentType dt = (DocumentType)n;
                    String publicID = dt.getPublicId() == null ? "" : dt.getPublicId();
                    String systemID = dt.getSystemId() == null ? "" : dt.getSystemId();
                    String text = dt.getInternalSubset() == null ? "" : dt.getInternalSubset();
                    this.exiBody.encodeDocType(dt.getName(), publicID, systemID, text);
                    continue block10;
                }
                case 5: {
                    continue block10;
                }
                case 4: {
                    this.exiBody.encodeCharacters(new StringValue(n.getNodeValue()));
                    continue block10;
                }
                case 7: {
                    if (!this.preservePIs) continue block10;
                    ProcessingInstruction pi = (ProcessingInstruction)n;
                    this.exiBody.encodeProcessingInstruction(pi.getTarget(), pi.getData());
                    continue block10;
                }
                default: {
                    System.err.println("[WARNING] Unhandled DOM NodeType: " + n.getNodeType());
                }
            }
        }
    }
}

