/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.exificient.grammars.persistency;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opendaylight.netconf.shaded.exificient.core.context.GrammarContext;
import org.opendaylight.netconf.shaded.exificient.core.context.GrammarUriContext;
import org.opendaylight.netconf.shaded.exificient.core.context.QNameContext;
import org.opendaylight.netconf.shaded.exificient.core.grammars.Grammars;
import org.opendaylight.netconf.shaded.exificient.core.grammars.SchemaInformedGrammars;
import org.opendaylight.netconf.shaded.exificient.core.grammars.event.StartElement;
import org.opendaylight.netconf.shaded.exificient.core.grammars.grammar.DocEnd;
import org.opendaylight.netconf.shaded.exificient.core.grammars.grammar.Document;
import org.opendaylight.netconf.shaded.exificient.core.grammars.grammar.Fragment;
import org.opendaylight.netconf.shaded.exificient.core.grammars.grammar.Grammar;
import org.opendaylight.netconf.shaded.exificient.core.grammars.grammar.SchemaInformedDocContent;
import org.opendaylight.netconf.shaded.exificient.core.grammars.grammar.SchemaInformedElement;
import org.opendaylight.netconf.shaded.exificient.core.grammars.grammar.SchemaInformedFirstStartTag;
import org.opendaylight.netconf.shaded.exificient.core.grammars.grammar.SchemaInformedFirstStartTagGrammar;
import org.opendaylight.netconf.shaded.exificient.core.grammars.grammar.SchemaInformedFragmentContent;
import org.opendaylight.netconf.shaded.exificient.core.grammars.grammar.SchemaInformedGrammar;
import org.opendaylight.netconf.shaded.exificient.core.grammars.grammar.SchemaInformedStartTag;
import org.opendaylight.netconf.shaded.exificient.core.grammars.production.Production;
import org.opendaylight.netconf.shaded.exificient.grammars.persistency.GrammarIdDispenser;

public class GrammarsPreperation {
    protected GrammarIdDispenser grsIdDispenser = new GrammarIdDispenser();
    protected List<Grammar> sortedGrammars = new ArrayList<Grammar>();
    protected int numberOfFirstStartTagGrammars;
    protected int numberOfStartTagGrammars;
    protected int numberOfElementGrammars;

    public void clear() {
        this.grsIdDispenser.clear();
        this.sortedGrammars.clear();
        this.numberOfFirstStartTagGrammars = 0;
        this.numberOfStartTagGrammars = 0;
        this.numberOfElementGrammars = 0;
    }

    public void prepareGrammars(Grammars grammar) throws IOException {
        this.clear();
        Grammar doc = grammar.getDocumentGrammar();
        this.prepareGrammar(doc);
        Grammar frag = grammar.getFragmentGrammar();
        this.prepareGrammar(frag);
        if (grammar instanceof SchemaInformedGrammars) {
            SchemaInformedGrammar elFragGr = ((SchemaInformedGrammars)grammar).getSchemaInformedElementFragmentGrammar();
            this.prepareGrammar(elFragGr);
        }
        GrammarContext gc = grammar.getGrammarContext();
        for (int uriId = 0; uriId < gc.getNumberOfGrammarUriContexts(); ++uriId) {
            GrammarUriContext guc = gc.getGrammarUriContext(uriId);
            for (int qnId = 0; qnId < guc.getNumberOfQNames(); ++qnId) {
                QNameContext qnc = guc.getQNameContext(qnId);
                SchemaInformedFirstStartTagGrammar typeGrammar = qnc.getTypeGrammar();
                if (typeGrammar == null) continue;
                this.prepareGrammar(typeGrammar);
            }
        }
        this.sortedGrammars.clear();
        for (int k = 0; k < 8; ++k) {
            Iterator<Grammar> iterGrs = this.grsIdDispenser.getGrammarIterator();
            while (iterGrs.hasNext()) {
                Grammar r = iterGrs.next();
                switch (k) {
                    case 0: {
                        if (!(r instanceof Document)) break;
                        this.sortedGrammars.add(r);
                        break;
                    }
                    case 1: {
                        if (!(r instanceof SchemaInformedDocContent)) break;
                        this.sortedGrammars.add(r);
                        break;
                    }
                    case 2: {
                        if (!(r instanceof DocEnd)) break;
                        this.sortedGrammars.add(r);
                        break;
                    }
                    case 3: {
                        if (!(r instanceof Fragment)) break;
                        this.sortedGrammars.add(r);
                        break;
                    }
                    case 4: {
                        if (!(r instanceof SchemaInformedFragmentContent)) break;
                        this.sortedGrammars.add(r);
                        break;
                    }
                    case 5: {
                        if (!(r instanceof SchemaInformedFirstStartTag)) break;
                        ++this.numberOfFirstStartTagGrammars;
                        this.sortedGrammars.add(r);
                        break;
                    }
                    case 6: {
                        if (!(r instanceof SchemaInformedStartTag) || r instanceof SchemaInformedFirstStartTag) break;
                        ++this.numberOfStartTagGrammars;
                        this.sortedGrammars.add(r);
                        break;
                    }
                    case 7: {
                        if (!(r instanceof SchemaInformedElement)) break;
                        ++this.numberOfElementGrammars;
                        this.sortedGrammars.add(r);
                    }
                }
            }
        }
        System.out.println("Sorted Grammars: " + this.sortedGrammars);
    }

    void prepareGrammar(Grammar r) throws IOException {
        if (this.grsIdDispenser.isGrammarHandled(r)) {
            return;
        }
        this.grsIdDispenser.addHandledGrammar(r);
        int numberOfEvents = r.getNumberOfEvents();
        for (int eventCode = 0; eventCode < numberOfEvents; ++eventCode) {
            Production ei = r.getProduction(eventCode);
            switch (ei.getEvent().getEventType()) {
                case START_ELEMENT: {
                    StartElement se = (StartElement)ei.getEvent();
                    if (this.grsIdDispenser.isGrammarHandled(se.getGrammar())) break;
                    this.prepareGrammar(se.getGrammar());
                    break;
                }
            }
            if (ei.getNextGrammar() == null) continue;
            this.prepareGrammar(ei.getNextGrammar());
        }
        this.prepareGrammar(r.getElementContentGrammar());
    }

    public int getGrammarID(Grammar r) {
        int id1 = this.grsIdDispenser.getGrammarID(r);
        Grammar g1 = this.grsIdDispenser.getGrammar(id1);
        for (int i = 0; i < this.sortedGrammars.size(); ++i) {
            Grammar g = this.sortedGrammars.get(i);
            if (g1 != g) continue;
            return i;
        }
        throw new RuntimeException("No grammar id found for: " + r);
    }

    public Grammar getGrammar(int id) {
        return this.sortedGrammars.get(id);
    }

    public int getNumberOfGrammars() {
        return this.sortedGrammars.size();
    }

    public int getNumberOfFirstStartTagGrammars() {
        return this.numberOfFirstStartTagGrammars;
    }

    public int getNumberOfStartTagGrammars() {
        return this.numberOfStartTagGrammars;
    }

    public int getNumberOfElementGrammars() {
        return this.numberOfElementGrammars;
    }
}

