/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.exificient.grammars.persistency;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opendaylight.netconf.shaded.exificient.core.datatype.Datatype;
import org.opendaylight.netconf.shaded.exificient.core.datatype.DatetimeDatatype;
import org.opendaylight.netconf.shaded.exificient.core.datatype.EnumerationDatatype;
import org.opendaylight.netconf.shaded.exificient.core.datatype.ListDatatype;
import org.opendaylight.netconf.shaded.exificient.core.datatype.NBitUnsignedIntegerDatatype;
import org.opendaylight.netconf.shaded.exificient.core.datatype.RestrictedCharacterSetDatatype;
import org.opendaylight.netconf.shaded.exificient.core.datatype.charset.RestrictedCharacterSet;
import org.opendaylight.netconf.shaded.exificient.core.grammars.event.Attribute;
import org.opendaylight.netconf.shaded.exificient.core.grammars.event.AttributeNS;
import org.opendaylight.netconf.shaded.exificient.core.grammars.event.Characters;
import org.opendaylight.netconf.shaded.exificient.core.grammars.event.Event;
import org.opendaylight.netconf.shaded.exificient.core.grammars.event.StartElement;
import org.opendaylight.netconf.shaded.exificient.core.grammars.event.StartElementNS;
import org.opendaylight.netconf.shaded.exificient.core.grammars.grammar.BuiltInDocContent;
import org.opendaylight.netconf.shaded.exificient.core.grammars.grammar.BuiltInFragmentContent;
import org.opendaylight.netconf.shaded.exificient.core.grammars.grammar.DocEnd;
import org.opendaylight.netconf.shaded.exificient.core.grammars.grammar.Document;
import org.opendaylight.netconf.shaded.exificient.core.grammars.grammar.Fragment;
import org.opendaylight.netconf.shaded.exificient.core.grammars.grammar.Grammar;
import org.opendaylight.netconf.shaded.exificient.core.grammars.grammar.SchemaInformedDocContent;
import org.opendaylight.netconf.shaded.exificient.core.grammars.grammar.SchemaInformedElement;
import org.opendaylight.netconf.shaded.exificient.core.grammars.grammar.SchemaInformedFirstStartTagGrammar;
import org.opendaylight.netconf.shaded.exificient.core.grammars.grammar.SchemaInformedFragmentContent;
import org.opendaylight.netconf.shaded.exificient.core.grammars.grammar.SchemaInformedStartTagGrammar;
import org.opendaylight.netconf.shaded.exificient.core.grammars.production.Production;
import org.opendaylight.netconf.shaded.exificient.core.types.BuiltInType;
import org.opendaylight.netconf.shaded.exificient.core.values.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrammarIdDispenser {
    static final int DEFAULT_RECURSIVE_HANDLED_DEPTH_STOP = 100;
    final int RECURSIVE_HANDLED_DEPTH_STOP;
    final boolean doOptimizeGrammars;
    private List<Grammar> grammars;

    public GrammarIdDispenser() {
        this(true);
    }

    public GrammarIdDispenser(boolean optimizeGrammars) {
        this(optimizeGrammars, 100);
    }

    public GrammarIdDispenser(boolean optimizeGrammars, int depth) {
        this.doOptimizeGrammars = optimizeGrammars;
        this.RECURSIVE_HANDLED_DEPTH_STOP = depth;
        this.grammars = new ArrayList<Grammar>();
    }

    public void clear() {
        this.grammars.clear();
    }

    private Grammar getEqualGrammar(Grammar gr) {
        for (Grammar gx : this.grammars) {
            ArrayList<Grammar> handled;
            if (gr == gx) {
                return gx;
            }
            if (!GrammarIdDispenser.isSameGrammarType(gr, gx) || gr.getNumberOfEvents() != gx.getNumberOfEvents() || !this.isEqualGrammar(gr, gx, handled = new ArrayList<Grammar>())) continue;
            return gx;
        }
        return null;
    }

    private static int getGrammarTypeID(Grammar gr) {
        if (gr instanceof Document) {
            return 0;
        }
        if (gr instanceof SchemaInformedDocContent) {
            return 1;
        }
        if (gr instanceof DocEnd) {
            return 2;
        }
        if (gr instanceof Fragment) {
            return 3;
        }
        if (gr instanceof SchemaInformedFragmentContent) {
            return 4;
        }
        if (gr instanceof SchemaInformedFirstStartTagGrammar) {
            return 5;
        }
        if (gr instanceof SchemaInformedStartTagGrammar) {
            return 6;
        }
        if (gr instanceof SchemaInformedElement) {
            return 7;
        }
        if (gr instanceof BuiltInDocContent) {
            return 8;
        }
        if (gr instanceof BuiltInFragmentContent) {
            return 9;
        }
        throw new RuntimeException("Unexpected Grammar Type for: " + gr);
    }

    private static boolean isSameGrammarType(Grammar gr, Grammar gx) {
        int gxTID;
        int grTID = GrammarIdDispenser.getGrammarTypeID(gr);
        if (grTID != (gxTID = GrammarIdDispenser.getGrammarTypeID(gx))) {
            return false;
        }
        if (gr instanceof SchemaInformedFirstStartTagGrammar) {
            SchemaInformedFirstStartTagGrammar fr = (SchemaInformedFirstStartTagGrammar)gr;
            SchemaInformedFirstStartTagGrammar fx = (SchemaInformedFirstStartTagGrammar)gx;
            if (fr.isTypeCastable() != fx.isTypeCastable()) {
                return false;
            }
            if (fr.isNillable() != fx.isNillable()) {
                return false;
            }
        }
        return true;
    }

    private boolean isEqualGrammar(Grammar gr, Grammar gx, List<Grammar> handled) {
        if (gr == gx) {
            return true;
        }
        if (gr == null && gx != null && gx.getNumberOfEvents() == 0) {
            return true;
        }
        if (gx == null && gr != null && gr.getNumberOfEvents() == 0) {
            return true;
        }
        for (Grammar g : handled) {
            if (g != gx) continue;
            for (Grammar gg : handled) {
                if (gg != gr) continue;
                return true;
            }
        }
        handled.add(gx);
        handled.add(gr);
        if (handled.size() > this.RECURSIVE_HANDLED_DEPTH_STOP) {
            return false;
        }
        if (!GrammarIdDispenser.isSameGrammarType(gr, gx)) {
            return false;
        }
        if (gr.getNumberOfEvents() != gx.getNumberOfEvents()) {
            return false;
        }
        for (int i = 0; i < gr.getNumberOfEvents(); ++i) {
            Production pr = gr.getProduction(i);
            Production px = gx.getProduction(i);
            Event er = pr.getEvent();
            Event ex = px.getEvent();
            if (er.getEventType() != ex.getEventType()) {
                return false;
            }
            switch (er.getEventType()) {
                case START_DOCUMENT: 
                case END_DOCUMENT: 
                case ATTRIBUTE_GENERIC: 
                case START_ELEMENT_GENERIC: 
                case END_ELEMENT: 
                case CHARACTERS_GENERIC: {
                    break;
                }
                case ATTRIBUTE: {
                    Attribute ar = (Attribute)er;
                    Attribute ax = (Attribute)ex;
                    if (!ar.getQName().equals(ax.getQName())) {
                        return false;
                    }
                    if (GrammarIdDispenser.isEqualDatatype(ar.getDatatype(), ax.getDatatype())) break;
                    return false;
                }
                case ATTRIBUTE_NS: {
                    AttributeNS ansr = (AttributeNS)er;
                    AttributeNS ansx = (AttributeNS)ex;
                    if (ansr.getNamespaceURI().equals(ansx.getNamespaceURI())) break;
                    return false;
                }
                case START_ELEMENT: {
                    StartElement ser = (StartElement)er;
                    StartElement sex = (StartElement)ex;
                    if (!ser.getQName().equals(sex.getQName())) {
                        return false;
                    }
                    if (this.isEqualGrammar(ser.getGrammar(), sex.getGrammar(), handled)) break;
                    return false;
                }
                case START_ELEMENT_NS: {
                    StartElementNS sensr = (StartElementNS)er;
                    StartElementNS sensx = (StartElementNS)ex;
                    if (sensr.getNamespaceURI().equals(sensx.getNamespaceURI())) break;
                    return false;
                }
                case CHARACTERS: {
                    Characters chr = (Characters)er;
                    Characters chx = (Characters)ex;
                    if (GrammarIdDispenser.isEqualDatatype(chr.getDatatype(), chx.getDatatype())) break;
                    return false;
                }
                default: {
                    throw new RuntimeException("Unexpected Grammar Event Type for: " + er);
                }
            }
            Grammar nr = pr.getNextGrammar();
            Grammar nx = px.getNextGrammar();
            if (this.isEqualGrammar(nr, nx, handled)) continue;
            return false;
        }
        return true;
    }

    private static boolean isEqualDatatype(Datatype dt1, Datatype dt2) {
        BuiltInType bit2;
        BuiltInType bit1 = dt1.getBuiltInType();
        if (bit1 != (bit2 = dt2.getBuiltInType())) {
            return false;
        }
        switch (bit1) {
            case BINARY_BASE64: 
            case BINARY_HEX: 
            case BOOLEAN: 
            case BOOLEAN_FACET: 
            case DECIMAL: 
            case FLOAT: 
            case UNSIGNED_INTEGER: 
            case INTEGER: 
            case STRING: {
                break;
            }
            case NBIT_UNSIGNED_INTEGER: {
                NBitUnsignedIntegerDatatype nbit1 = (NBitUnsignedIntegerDatatype)dt1;
                NBitUnsignedIntegerDatatype nbit2 = (NBitUnsignedIntegerDatatype)dt2;
                if (nbit1.getNumberOfBits() != nbit2.getNumberOfBits()) {
                    return false;
                }
                if (!nbit1.getLowerBound().equals(nbit2.getLowerBound())) {
                    return false;
                }
                if (nbit1.getUpperBound().equals(nbit2.getUpperBound())) break;
                return false;
            }
            case DATETIME: {
                DatetimeDatatype d1 = (DatetimeDatatype)dt1;
                DatetimeDatatype d2 = (DatetimeDatatype)dt2;
                if (d1.getDatetimeType() == d2.getDatetimeType()) break;
                return false;
            }
            case RCS_STRING: {
                RestrictedCharacterSetDatatype r1 = (RestrictedCharacterSetDatatype)dt1;
                RestrictedCharacterSetDatatype r2 = (RestrictedCharacterSetDatatype)dt2;
                RestrictedCharacterSet rcs1 = r1.getRestrictedCharacterSet();
                RestrictedCharacterSet rcs2 = r2.getRestrictedCharacterSet();
                if (rcs1.size() != rcs2.size()) {
                    return false;
                }
                for (int i = 0; i < rcs1.size(); ++i) {
                    if (rcs1.getCodePoint(i) == rcs2.getCodePoint(i)) continue;
                    return false;
                }
                break;
            }
            case ENUMERATION: {
                EnumerationDatatype e1 = (EnumerationDatatype)dt1;
                EnumerationDatatype e2 = (EnumerationDatatype)dt2;
                if (e1.getEnumerationSize() != e2.getEnumerationSize()) {
                    return false;
                }
                if (e1.getEnumValueDatatype().getBuiltInType() != e2.getEnumValueDatatype().getBuiltInType()) {
                    return false;
                }
                for (int i = 0; i < e1.getEnumerationSize(); ++i) {
                    Value v2;
                    Value v1 = e1.getEnumValue(i);
                    if (v1.equals(v2 = e2.getEnumValue(i))) continue;
                    return false;
                }
                break;
            }
            case LIST: {
                ListDatatype l1 = (ListDatatype)dt1;
                ListDatatype l2 = (ListDatatype)dt2;
                if (GrammarIdDispenser.isEqualDatatype(l1.getListDatatype(), l2.getListDatatype())) break;
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public boolean isGrammarHandled(Grammar gr) {
        boolean handled = false;
        if (this.doOptimizeGrammars) {
            Grammar gx = this.getEqualGrammar(gr);
            handled = gx != null;
        } else {
            Iterator<Grammar> giter = this.getGrammarIterator();
            while (!handled && giter.hasNext()) {
                Grammar g = giter.next();
                if (g != gr) continue;
                handled = true;
            }
        }
        return handled;
    }

    public void addHandledGrammar(Grammar gr) {
        this.grammars.add(gr);
    }

    public Iterator<Grammar> getGrammarIterator() {
        return this.grammars.iterator();
    }

    private int getKnownGrammarID(Grammar r) {
        for (int i = 0; i < this.grammars.size(); ++i) {
            if (this.grammars.get(i) != r) continue;
            return i;
        }
        return -1;
    }

    public Grammar getGrammar(int gid) {
        if (this.grammars != null && this.grammars.size() > gid && gid >= 0) {
            return this.grammars.get(gid);
        }
        throw new RuntimeException("Unexpected grammarID");
    }

    public int getGrammarIDProof(Grammar g) {
        if (!this.isGrammarHandled(g)) {
            this.addHandledGrammar(g);
        }
        return this.getGrammarID(g);
    }

    public int getGrammarID(Grammar r) {
        int id;
        if (this.doOptimizeGrammars) {
            id = this.getKnownGrammarID(r);
            if (id != -1) {
                return id;
            }
            Grammar gx = this.getEqualGrammar(r);
            if (gx == null) {
                throw new RuntimeException("no valid grammar ID found for :" + r + ". MUST be handled before!!");
            }
            id = this.getGrammarID(gx);
        } else {
            if (!this.isGrammarHandled(r)) {
                this.addHandledGrammar(r);
            }
            id = this.getKnownGrammarID(r);
        }
        return id;
    }
}

