/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.exificient.grammars;

import java.io.InputStream;
import org.opendaylight.netconf.shaded.exificient.core.exceptions.EXIException;
import org.opendaylight.netconf.shaded.exificient.core.grammars.Grammars;
import org.opendaylight.netconf.shaded.exificient.core.grammars.SchemaInformedGrammars;
import org.opendaylight.netconf.shaded.exificient.core.grammars.SchemaLessGrammars;
import org.opendaylight.netconf.shaded.exificient.grammars.XSDGrammarsBuilder;
import org.opendaylight.netconf.shaded.xerces.xni.parser.XMLEntityResolver;

public class GrammarFactory {
    protected XSDGrammarsBuilder grammarBuilder = XSDGrammarsBuilder.newInstance();

    protected GrammarFactory() {
    }

    public static GrammarFactory newInstance() {
        return new GrammarFactory();
    }

    public Grammars createGrammars(String xsdLocation) throws EXIException {
        return this.createGrammars(xsdLocation, null);
    }

    public Grammars createGrammars(String xsdLocation, XMLEntityResolver entityResolver) throws EXIException {
        if (xsdLocation == null || xsdLocation.equals("")) {
            throw new EXIException("SchemaLocation not specified correctly!");
        }
        this.grammarBuilder.loadGrammars(xsdLocation, entityResolver);
        SchemaInformedGrammars g = this.grammarBuilder.toGrammars();
        g.setSchemaId(xsdLocation);
        return g;
    }

    public Grammars createGrammars(InputStream is) throws EXIException {
        return this.createGrammars(is, null);
    }

    public Grammars createGrammars(InputStream is, XMLEntityResolver entityResolver) throws EXIException {
        this.grammarBuilder.loadGrammars(is, entityResolver);
        SchemaInformedGrammars g = this.grammarBuilder.toGrammars();
        g.setSchemaId("No-Schema-ID-Set");
        return g;
    }

    public Grammars createXSDTypesOnlyGrammars() throws EXIException {
        this.grammarBuilder.loadXSDTypesOnlyGrammars();
        SchemaInformedGrammars g = this.grammarBuilder.toGrammars();
        g.setBuiltInXMLSchemaTypesOnly(true);
        return g;
    }

    public Grammars createSchemaLessGrammars() {
        return new SchemaLessGrammars();
    }
}

