/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.exificient.core.types;

import java.io.IOException;
import java.util.Map;
import javax.xml.namespace.QName;
import org.opendaylight.netconf.shaded.exificient.core.context.QNameContext;
import org.opendaylight.netconf.shaded.exificient.core.datatype.Datatype;
import org.opendaylight.netconf.shaded.exificient.core.datatype.DatetimeDatatype;
import org.opendaylight.netconf.shaded.exificient.core.datatype.EnumDatatype;
import org.opendaylight.netconf.shaded.exificient.core.datatype.EnumerationDatatype;
import org.opendaylight.netconf.shaded.exificient.core.datatype.ExtendedStringDatatype;
import org.opendaylight.netconf.shaded.exificient.core.datatype.ListDatatype;
import org.opendaylight.netconf.shaded.exificient.core.datatype.NBitUnsignedIntegerDatatype;
import org.opendaylight.netconf.shaded.exificient.core.datatype.RestrictedCharacterSetDatatype;
import org.opendaylight.netconf.shaded.exificient.core.datatype.strings.StringCoder;
import org.opendaylight.netconf.shaded.exificient.core.datatype.strings.StringDecoder;
import org.opendaylight.netconf.shaded.exificient.core.exceptions.EXIException;
import org.opendaylight.netconf.shaded.exificient.core.io.channel.DecoderChannel;
import org.opendaylight.netconf.shaded.exificient.core.types.AbstractTypeDecoder;
import org.opendaylight.netconf.shaded.exificient.core.values.BinaryBase64Value;
import org.opendaylight.netconf.shaded.exificient.core.values.BinaryHexValue;
import org.opendaylight.netconf.shaded.exificient.core.values.BooleanValue;
import org.opendaylight.netconf.shaded.exificient.core.values.IntegerValue;
import org.opendaylight.netconf.shaded.exificient.core.values.ListValue;
import org.opendaylight.netconf.shaded.exificient.core.values.StringValue;
import org.opendaylight.netconf.shaded.exificient.core.values.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypedTypeDecoder
extends AbstractTypeDecoder {
    public TypedTypeDecoder() throws EXIException {
        this(null, null, null);
    }

    public TypedTypeDecoder(QName[] dtrMapTypes, QName[] dtrMapRepresentations, Map<QName, Datatype> dtrMapRepresentationsDatatype) throws EXIException {
        super(dtrMapTypes, dtrMapRepresentations, dtrMapRepresentationsDatatype);
    }

    @Override
    public Value readValue(Datatype datatype, QNameContext qnContext, DecoderChannel valueChannel, StringDecoder stringDecoder) throws IOException {
        if (this.dtrMapInUse) {
            datatype = this.getDtrDatatype(datatype);
        }
        switch (datatype.getBuiltInType()) {
            case BINARY_BASE64: {
                return new BinaryBase64Value(valueChannel.decodeBinary());
            }
            case BINARY_HEX: {
                return new BinaryHexValue(valueChannel.decodeBinary());
            }
            case BOOLEAN: {
                return valueChannel.decodeBooleanValue();
            }
            case BOOLEAN_FACET: {
                int booleanID = valueChannel.decodeNBitUnsignedInteger(2);
                return BooleanValue.getBooleanValue(booleanID);
            }
            case DECIMAL: {
                return valueChannel.decodeDecimalValue();
            }
            case FLOAT: {
                return valueChannel.decodeFloatValue();
            }
            case NBIT_UNSIGNED_INTEGER: {
                NBitUnsignedIntegerDatatype nbitDT = (NBitUnsignedIntegerDatatype)datatype;
                IntegerValue iv = valueChannel.decodeNBitUnsignedIntegerValue(nbitDT.getNumberOfBits());
                return iv.add(nbitDT.getLowerBound());
            }
            case UNSIGNED_INTEGER: {
                return valueChannel.decodeUnsignedIntegerValue();
            }
            case INTEGER: {
                return valueChannel.decodeIntegerValue();
            }
            case DATETIME: {
                DatetimeDatatype dtDT = (DatetimeDatatype)datatype;
                return valueChannel.decodeDateTimeValue(dtDT.getDatetimeType());
            }
            case STRING: {
                return stringDecoder.readValue(qnContext, valueChannel);
            }
            case RCS_STRING: {
                RestrictedCharacterSetDatatype rcsDT = (RestrictedCharacterSetDatatype)datatype;
                return this.readRCSValue(rcsDT, qnContext, valueChannel, stringDecoder);
            }
            case EXTENDED_STRING: {
                ExtendedStringDatatype esDT = (ExtendedStringDatatype)datatype;
                return this.readExtendedString(esDT, qnContext, valueChannel, stringDecoder);
            }
            case ENUMERATION: {
                EnumerationDatatype enumDT = (EnumerationDatatype)datatype;
                int index = valueChannel.decodeNBitUnsignedInteger(enumDT.getCodingLength());
                assert (index >= 0 && index < enumDT.getEnumerationSize());
                return enumDT.getEnumValue(index);
            }
            case LIST: {
                ListDatatype lDT = (ListDatatype)datatype;
                Datatype listDatatype = lDT.getListDatatype();
                int len = valueChannel.decodeUnsignedInteger();
                Value[] values = new Value[len];
                for (int l = 0; l < len; ++l) {
                    values[l] = this.readValue(listDatatype, qnContext, valueChannel, stringDecoder);
                }
                ListValue retVal = new ListValue(values, listDatatype);
                return retVal;
            }
            case QNAME: {
                throw new IOException("QName is not an allowed as EXI datatype");
            }
        }
        return null;
    }

    protected StringValue readExtendedString(ExtendedStringDatatype esDT, QNameContext context, DecoderChannel valueChannel, StringDecoder stringDecoder) throws IOException {
        EnumDatatype grammarStrings = esDT.getGrammarStrings();
        StringValue value = null;
        int i = valueChannel.decodeUnsignedInteger();
        switch (i) {
            case 0: {
                if (stringDecoder.isLocalValuePartitions()) {
                    value = stringDecoder.readValueLocalHit(context, valueChannel);
                    break;
                }
                throw new IOException("EXI stream contains local-value hit even though profile options indicate otherwise.");
            }
            case 1: {
                value = stringDecoder.readValueGlobalHit(valueChannel);
                break;
            }
            case 2: {
                int index = valueChannel.decodeNBitUnsignedInteger(grammarStrings.getCodingLength());
                assert (index >= 0 && index < grammarStrings.getEnumerationSize());
                Value v = grammarStrings.getEnumValue(index);
                if (v instanceof StringValue) {
                    value = (StringValue)v;
                    break;
                }
                value = new StringValue(v.toString());
                break;
            }
            case 3: {
                throw new IOException("ExtendedString, no support for <shared string>");
            }
            case 4: {
                throw new IOException("ExtendedString, no support for <split string>");
            }
            case 5: {
                throw new IOException("ExtendedString, no support for <undefined>");
            }
            default: {
                int L = i - 6;
                if (L > 0) {
                    value = new StringValue(valueChannel.decodeStringOnly(L));
                    stringDecoder.addValue(context, value);
                    break;
                }
                value = StringCoder.EMPTY_STRING_VALUE;
            }
        }
        assert (value != null);
        return value;
    }
}

