/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.exificient.core.io.channel;

import java.io.IOException;
import java.io.OutputStream;
import org.opendaylight.netconf.shaded.exificient.core.io.BitOutputStream;
import org.opendaylight.netconf.shaded.exificient.core.io.channel.AbstractEncoderChannel;
import org.opendaylight.netconf.shaded.exificient.core.io.channel.EncoderChannel;

public class BitEncoderChannel
extends AbstractEncoderChannel
implements EncoderChannel {
    protected BitOutputStream ostream;

    public BitEncoderChannel(OutputStream ostream) {
        this.ostream = new BitOutputStream(ostream);
    }

    public OutputStream getOutputStream() {
        return this.ostream;
    }

    public int getLength() {
        return this.ostream.getLength();
    }

    public void flush() throws IOException {
        this.ostream.flush();
    }

    public void align() throws IOException {
        this.ostream.align();
    }

    public void encode(int b) throws IOException {
        this.ostream.writeBits(b, 8);
    }

    public void encode(byte[] b, int off, int len) throws IOException {
        for (int i = off; i < off + len; ++i) {
            this.ostream.writeBits(b[i], 8);
        }
    }

    public void encodeNBitUnsignedInteger(int b, int n) throws IOException {
        if (b < 0 || n < 0) {
            throw new IllegalArgumentException("Encode negative value as unsigned integer is invalid!");
        }
        assert (b >= 0);
        assert (n >= 0);
        this.ostream.writeBits(b, n);
    }

    public void encodeBoolean(boolean b) throws IOException {
        if (b) {
            this.ostream.writeBit1();
        } else {
            this.ostream.writeBit0();
        }
    }
}

