/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.exificient.core.io.channel;

import java.io.IOException;
import java.io.InputStream;
import org.opendaylight.netconf.shaded.exificient.core.io.BitInputStream;
import org.opendaylight.netconf.shaded.exificient.core.io.channel.AbstractDecoderChannel;
import org.opendaylight.netconf.shaded.exificient.core.io.channel.DecoderChannel;

public class BitDecoderChannel
extends AbstractDecoderChannel
implements DecoderChannel {
    protected BitInputStream istream;

    public BitDecoderChannel(InputStream is) {
        this.istream = new BitInputStream(is);
    }

    public final int decode() throws IOException {
        return this.istream.read();
    }

    public void align() throws IOException {
        this.istream.align();
    }

    public int lookAhead() throws IOException {
        return this.istream.lookAhead();
    }

    public void skip(long n) throws IOException {
        this.istream.skip(n);
    }

    public final int decodeNBitUnsignedInteger(int n) throws IOException {
        assert (n >= 0);
        return n == 0 ? 0 : this.istream.readBits(n);
    }

    public boolean decodeBoolean() throws IOException {
        return this.istream.readBit() == 1;
    }

    public byte[] decodeBinary() throws IOException {
        int length = this.decodeUnsignedInteger();
        byte[] result = new byte[length];
        this.istream.read(result, 0, length);
        return result;
    }
}

