/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.exificient.core.grammars.grammar;

import java.util.List;
import javax.xml.namespace.QName;
import org.opendaylight.netconf.shaded.exificient.core.grammars.event.Attribute;
import org.opendaylight.netconf.shaded.exificient.core.grammars.event.EndElement;
import org.opendaylight.netconf.shaded.exificient.core.grammars.event.Event;
import org.opendaylight.netconf.shaded.exificient.core.grammars.event.EventType;
import org.opendaylight.netconf.shaded.exificient.core.grammars.event.StartElement;
import org.opendaylight.netconf.shaded.exificient.core.grammars.event.StartElementGeneric;
import org.opendaylight.netconf.shaded.exificient.core.grammars.grammar.Grammar;
import org.opendaylight.netconf.shaded.exificient.core.grammars.grammar.SchemaInformedElement;
import org.opendaylight.netconf.shaded.exificient.core.grammars.grammar.SchemaInformedGrammar;
import org.opendaylight.netconf.shaded.exificient.core.grammars.production.Production;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGrammar
implements Grammar {
    protected static final SchemaInformedGrammar END_RULE = new SchemaInformedElement();
    protected static final Event START_ELEMENT_GENERIC;
    protected static final Event END_ELEMENT;
    protected String label = null;
    protected int stopLearningContainerSize = -1;

    public AbstractGrammar() {
    }

    public AbstractGrammar(String label) {
        this();
        this.label = label;
    }

    public void addTerminalProduction(Event event) {
        assert (event.isEventType(EventType.END_ELEMENT) || event.isEventType(EventType.END_DOCUMENT));
        this.addProduction(event, END_RULE);
    }

    @Override
    public void learnStartElement(StartElement se) {
    }

    @Override
    public void learnEndElement() {
    }

    @Override
    public void learnAttribute(Attribute at) {
    }

    @Override
    public void learnCharacters() {
    }

    @Override
    public void stopLearning() {
    }

    @Override
    public int learningStopped() {
        return this.stopLearningContainerSize;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        if (this.label != null && !this.label.equals("")) {
            return this.label;
        }
        return this.getClass().getName() + "[" + this.hashCode() + "]";
    }

    protected static int getEventCode(EventType eventType, List<EventType> events) {
        for (int i = 0; i < events.size(); ++i) {
            if (!events.get(i).equals((Object)eventType)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Grammar getElementContentGrammar() {
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Grammar) {
            Grammar gr = (Grammar)obj;
            int numberOfEvents = gr.getNumberOfEvents();
            if (this.getNumberOfEvents() == numberOfEvents) {
                for (int i = 0; i < numberOfEvents; ++i) {
                    Production ei = gr.getProduction(i);
                    if (ei.getEvent().equals(this.getProduction(i).getEvent())) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected static boolean checkQualifiedName(QName c, String namespaceURI, String localName) {
        return c.getLocalPart().equals(localName) && c.getNamespaceURI().equals(namespaceURI);
    }

    static {
        END_RULE.setLabel("<END>");
        START_ELEMENT_GENERIC = new StartElementGeneric();
        END_ELEMENT = new EndElement();
    }
}

