/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.exificient.core.context;

import java.util.Arrays;
import org.opendaylight.netconf.shaded.exificient.core.context.GrammarUriContext;

public class GrammarContext {
    protected final GrammarUriContext[] grammarUriContexts;
    protected final int numberofQNamesContexts;

    public GrammarContext(GrammarUriContext[] grammarUriContexts, int numberofQNamesContexts) {
        this.grammarUriContexts = grammarUriContexts;
        this.numberofQNamesContexts = numberofQNamesContexts;
    }

    public int getNumberOfGrammarUriContexts() {
        return this.grammarUriContexts.length;
    }

    public GrammarUriContext getGrammarUriContext(int id) {
        return this.grammarUriContexts[id];
    }

    public GrammarUriContext getGrammarUriContext(String namespaceUri) {
        for (int i = 0; i < this.grammarUriContexts.length; ++i) {
            GrammarUriContext uc = this.grammarUriContexts[i];
            if (!uc.namespaceUri.equals(namespaceUri)) continue;
            return uc;
        }
        return null;
    }

    public int getNumberOfGrammarQNameContexts() {
        return this.numberofQNamesContexts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GrammarContext)) {
            return false;
        }
        GrammarContext that = (GrammarContext)o;
        if (this.numberofQNamesContexts != that.numberofQNamesContexts) {
            return false;
        }
        return Arrays.equals(this.grammarUriContexts, that.grammarUriContexts);
    }
}

