/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.exificient.core.coder;

import java.io.IOException;
import java.io.OutputStream;
import org.opendaylight.netconf.shaded.exificient.core.CodingMode;
import org.opendaylight.netconf.shaded.exificient.core.EXIBodyEncoder;
import org.opendaylight.netconf.shaded.exificient.core.EXIFactory;
import org.opendaylight.netconf.shaded.exificient.core.EXIStreamEncoder;
import org.opendaylight.netconf.shaded.exificient.core.coder.EXIHeaderEncoder;
import org.opendaylight.netconf.shaded.exificient.core.exceptions.EXIException;
import org.opendaylight.netconf.shaded.exificient.core.io.channel.BitEncoderChannel;

public class EXIStreamEncoderImpl
implements EXIStreamEncoder {
    protected final EXIHeaderEncoder exiHeader;
    protected final EXIBodyEncoder exiBody;
    protected final EXIFactory exiFactory;

    public EXIStreamEncoderImpl(EXIFactory exiFactory) throws EXIException {
        this.exiFactory = exiFactory;
        this.exiHeader = new EXIHeaderEncoder();
        this.exiBody = exiFactory.createEXIBodyEncoder();
    }

    public EXIBodyEncoder encodeHeader(OutputStream os) throws EXIException, IOException {
        BitEncoderChannel headerChannel = new BitEncoderChannel(os);
        this.exiHeader.write(headerChannel, this.exiFactory);
        if (this.exiFactory.getCodingMode() == CodingMode.BIT_PACKED) {
            this.exiBody.setOutputChannel(headerChannel);
        } else {
            this.exiBody.setOutputStream(os);
        }
        return this.exiBody;
    }
}

