/*
 * Decompiled with CFR 0.152.
 */
package com.raisecom.zerotouch.util;

import com.raisecom.zerotouch.util.IpAddressMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RabbitMqProp {
    private static final Logger LOG = LoggerFactory.getLogger(RabbitMqProp.class);
    private final String rabbitMqIp;
    private final int rabbitMqPort;
    private final String username;
    private final String password;

    private RabbitMqProp(RabbitMqPropBuilder builder) {
        this.rabbitMqIp = builder.rabbitMqIp;
        this.rabbitMqPort = builder.rabbitMqPort;
        this.username = builder.username;
        this.password = builder.password;
    }

    public String getRabbitMqIp() {
        return this.rabbitMqIp;
    }

    public int getRabbitMqPort() {
        return this.rabbitMqPort;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String toString() {
        return String.format("RabbitMQ server: %s:%d", this.rabbitMqIp, this.rabbitMqPort);
    }

    public static class RabbitMqPropBuilder {
        private final String rabbitMqServer;
        private final String username;
        private final String password;
        private String rabbitMqIp;
        private int rabbitMqPort;

        public RabbitMqPropBuilder(String rabbitMqServers, String username, String password) {
            this.rabbitMqServer = rabbitMqServers;
            this.username = username;
            this.password = password;
        }

        public RabbitMqProp build() {
            if (!this.rabbitMqServer.contains("_")) {
                throw new IllegalArgumentException(String.format("Invalid rabbitMQ server %s!", this.rabbitMqServer));
            }
            String[] hostAndPort = this.rabbitMqServer.split("_");
            if (hostAndPort.length != 2) {
                throw new IllegalArgumentException(String.format("Invalid rabbitMQ server %s!", this.rabbitMqServer));
            }
            this.rabbitMqIp = hostAndPort[0];
            try {
                this.rabbitMqPort = Integer.parseInt(hostAndPort[1]);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException(String.format("Invalid rabbitMQ port %s!", hostAndPort[1]), nfe);
            }
            if (!IpAddressMatcher.isIpValid(hostAndPort[0])) {
                throw new IllegalArgumentException(String.format("Invalid rabbitMQ IP address %s!", hostAndPort[0]));
            }
            if (!IpAddressMatcher.isPortInRange(this.rabbitMqPort)) {
                throw new IllegalArgumentException(String.format("Invalid rabbitMQ port. Out of range. %d!", this.rabbitMqPort));
            }
            LOG.info("RabbitMQ server: {}", (Object)this.rabbitMqServer);
            return new RabbitMqProp(this);
        }
    }
}

