/*
 * Decompiled with CFR 0.152.
 */
package com.raisecom.zerotouch.util;

import java.util.Properties;

public final class KaProducerProp {
    private final String ack;
    private final String retries;
    private final String batchSize;
    private final String lingerMs;
    private final String bufferMemory;
    private final String keySerializer;
    private final String valueSerializer;

    private KaProducerProp(KaProducerPropBuilder builder) {
        this.ack = builder.ack;
        this.retries = builder.retries;
        this.batchSize = builder.batchSize;
        this.lingerMs = builder.lingerMs;
        this.bufferMemory = builder.bufferMemory;
        this.keySerializer = builder.keySerializer;
        this.valueSerializer = builder.valueSerializer;
    }

    public Properties toProperties(String kafkaServers) {
        Properties properties = new Properties();
        properties.setProperty("bootstrap.servers", kafkaServers);
        properties.setProperty("acks", this.ack);
        properties.setProperty("retries", this.retries);
        properties.setProperty("batch.size", this.batchSize);
        properties.setProperty("linger.ms", this.lingerMs);
        properties.setProperty("buffer.memory", this.bufferMemory);
        properties.setProperty("key.serializer", this.keySerializer);
        properties.setProperty("value.serializer", this.valueSerializer);
        return properties;
    }

    public static class KaProducerPropBuilder {
        private final String ack;
        private String retries;
        private String batchSize;
        private String lingerMs;
        private String bufferMemory;
        private String keySerializer;
        private String valueSerializer;

        public KaProducerPropBuilder(String ack) {
            this.ack = ack;
        }

        public KaProducerPropBuilder retries(String retries) {
            this.retries = retries;
            return this;
        }

        public KaProducerPropBuilder batchSize(String batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public KaProducerPropBuilder lingerMs(String lingerMs) {
            this.lingerMs = lingerMs;
            return this;
        }

        public KaProducerPropBuilder bufferMemory(String bufferMemory) {
            this.bufferMemory = bufferMemory;
            return this;
        }

        public KaProducerPropBuilder keySerializer(String keySerializer) {
            this.keySerializer = keySerializer;
            return this;
        }

        public KaProducerPropBuilder valueSerializer(String valueSerializer) {
            this.valueSerializer = valueSerializer;
            return this;
        }

        public KaProducerProp build() {
            return new KaProducerProp(this);
        }
    }
}

