/*
 * Decompiled with CFR 0.152.
 */
package com.raisecom.zerotouch.threads;

import com.raisecom.zerotouch.threads.NeRunnable;
import com.raisecom.zerotouch.threads.NeTaskThreadPoolExecutor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeTaskManager {
    private static final Logger LOG = LoggerFactory.getLogger(NeTaskManager.class);
    private static final int NE_QUEUE_SIZE = 4;
    private final NeTaskThreadPoolExecutor executor = new NeTaskThreadPoolExecutor();
    private final Object lock = new Object();
    private final Set<String> runningSet = new HashSet<String>();
    private final Map<String, LinkedBlockingQueue<NeRunnable>> waitingMap = new HashMap<String, LinkedBlockingQueue<NeRunnable>>();
    private static NeTaskManager instance = new NeTaskManager();

    private NeTaskManager() {
    }

    public static NeTaskManager getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(NeRunnable task) {
        String netconfId = task.getNetconfId();
        boolean needWait = false;
        int oldSize = 0;
        Object object = this.lock;
        synchronized (object) {
            if (this.runningSet.contains(netconfId)) {
                LinkedBlockingQueue<NeRunnable> waitingQueue = this.waitingMap.get(netconfId);
                if (null == waitingQueue) {
                    waitingQueue = new LinkedBlockingQueue(4);
                    this.waitingMap.put(netconfId, waitingQueue);
                }
                if (waitingQueue.remainingCapacity() <= 0) {
                    NeRunnable oldTask = waitingQueue.poll();
                    LOG.warn("WaitingQueue[{}] full. Discard the first {}.", (Object)4, (Object)oldTask);
                }
                oldSize = waitingQueue.size();
                waitingQueue.add(task);
                needWait = true;
            } else {
                this.runningSet.add(netconfId);
            }
        }
        if (needWait) {
            LOG.warn("Add {} in the waitingQueue[{}].", (Object)task, (Object)oldSize);
        } else {
            this.executor.execute(task);
            LOG.warn("Execute {} directly.", (Object)task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeNextTask(String netconfId) {
        NeRunnable task;
        int oldSize;
        Object object = this.lock;
        synchronized (object) {
            LinkedBlockingQueue<NeRunnable> waitingQueue = this.waitingMap.get(netconfId);
            if (null == waitingQueue) {
                this.runningSet.remove(netconfId);
                return;
            }
            oldSize = waitingQueue.size();
            task = waitingQueue.poll();
            if (oldSize == 1) {
                this.waitingMap.remove(netconfId);
            }
        }
        LOG.warn("Take {} from waitingQueue[{}] and execute it.", (Object)task, (Object)oldSize);
        this.executor.execute(task);
    }

    public void shutdown() {
        if (!this.executor.isShutdown()) {
            this.executor.shutdown();
        }
    }
}

