/*
 * Decompiled with CFR 0.152.
 */
package com.raisecom.zerotouch.threads;

import com.google.common.collect.ImmutableMap;
import com.google.gson.stream.JsonWriter;
import com.raisecom.zerotouch.constant.NeStatus;
import com.raisecom.zerotouch.constant.NotificationsMode;
import com.raisecom.zerotouch.netconf.notificationlistener.NotificationsListener;
import com.raisecom.zerotouch.threads.NeRunnable;
import com.raisecom.zerotouch.util.PropertiesReader;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadTransaction;
import org.opendaylight.mdsal.dom.api.DOMMountPoint;
import org.opendaylight.mdsal.dom.api.DOMMountPointService;
import org.opendaylight.mdsal.dom.api.DOMNotificationListener;
import org.opendaylight.mdsal.dom.api.DOMNotificationService;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.netconf.sal.connect.netconf.util.NetconfMessageTransformUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.connection.status.available.capabilities.AvailableCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.network.topology.topology.topology.types.TopologyNetconf;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NetworkTopology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeWriter;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactory;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactorySupplier;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.gson.JsonWriterFactory;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeOnlineRunnable
extends NeRunnable {
    private static final Logger LOG = LoggerFactory.getLogger(NeOnlineRunnable.class);
    private static final YangInstanceIdentifier DEFAULT_TOPOLOGY_NODE = YangInstanceIdentifier.builder().node(NetworkTopology.QNAME).node(Topology.QNAME).nodeWithKey(Topology.QNAME, QName.create((QName)Topology.QNAME, (String)"topology-id"), (Object)TopologyNetconf.QNAME.getLocalName()).node(Node.QNAME).build();
    private static final String RAISECOM_EQUIPMENT = "raisecom-equipment";
    private static final String RC_MANAGED_ELEMENT = "raisecom-equipment:managed-element";
    private static final String MANAGED_ELEMENT = "managed-element";
    private static final long READ_DATABROKER_TIMEOUT = 30L;
    private static final String QNAME_STRING_FULL = "^\\((.+)\\?revision=(.+)\\)(.+)$";
    private static final Pattern QNAME_PATTERN_FULL = Pattern.compile("^\\((.+)\\?revision=(.+)\\)(.+)$");
    private static final String QNAME_STRING_NO_REVISION = "^\\((.+)\\)(.+)$";
    private static final Pattern QNAME_PATTERN_NO_REVISION = Pattern.compile("^\\((.+)\\)(.+)$");
    private final NetconfNode netconfNode;
    private final DOMMountPointService domMountPointService;

    public NeOnlineRunnable(String netconfId, NetconfNode netconfNode, DOMMountPointService domMountPointService) {
        super(netconfId, NeStatus.CONNECTED, netconfNode.getHost().stringValue(), netconfNode.getPort().getValue());
        this.netconfNode = netconfNode;
        this.domMountPointService = domMountPointService;
    }

    @Override
    public void run() {
        YangInstanceIdentifier nodePath = DEFAULT_TOPOLOGY_NODE.node((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifierWithPredicates(Node.QNAME, QName.create((QName)Node.QNAME, (String)"node-id").intern(), (Object)this.netconfId));
        Optional opDomMountPoint = this.domMountPointService.getMountPoint(nodePath);
        if (!opDomMountPoint.isPresent()) {
            LOG.warn("DOMMountPoint is not present in path {}", (Object)nodePath);
            return;
        }
        this.handleOnlineDevice((DOMMountPoint)opDomMountPoint.get());
    }

    private void handleOnlineDevice(DOMMountPoint mountPoint) {
        JSONObject baseNode = new JSONObject();
        baseNode.put("node-id", (Object)this.netconfId);
        baseNode.put("netconf-node-topology:host", (Object)this.host);
        baseNode.put("netconf-node-topology:port", this.port);
        baseNode.put("netconf-node-topology:connection-status", (Object)this.status.getName());
        ArrayList<SchemaPath> schemaPaths = new ArrayList<SchemaPath>();
        this.scanCapabilities(baseNode, schemaPaths, mountPoint);
        JSONArray jsonArray = new JSONArray();
        jsonArray.put((Object)baseNode);
        JSONObject onlineMessage = new JSONObject();
        onlineMessage.put("netconf-hostip", (Object)PropertiesReader.getInstance().getLocalIp());
        onlineMessage.put("node", (Object)jsonArray);
        this.sendMessage("netconf_online", onlineMessage.toString());
        if (!NotificationsMode.NONE.equals((Object)PropertiesReader.getInstance().getNotificationsMode())) {
            this.registerNoteListeners(schemaPaths, mountPoint);
            this.subscribeNotes(mountPoint);
        }
    }

    private void scanCapabilities(JSONObject baseNode, List<SchemaPath> schemaPaths, DOMMountPoint mountPoint) {
        ImmutableMap<String, List<String>> noteListenerMap = PropertiesReader.getInstance().getSubscription().getNoteListenerMap();
        boolean rcEquipEnable = PropertiesReader.getInstance().isRcEquipmentEnable();
        List availableCapabilities = this.netconfNode.getAvailableCapabilities().getAvailableCapability();
        for (AvailableCapability availableCapability : availableCapabilities) {
            List noteCollection;
            String capabilityName = availableCapability.getCapability();
            QName qName = this.parseQName(capabilityName);
            if (qName == null) continue;
            if (rcEquipEnable && RAISECOM_EQUIPMENT.equals(qName.getLocalName())) {
                baseNode.put(RAISECOM_EQUIPMENT, (Object)this.readRcEquipment(mountPoint, QName.create((QName)qName, (String)MANAGED_ELEMENT)));
            }
            if ((noteCollection = (List)noteListenerMap.get((Object)qName.getNamespace().toString())) == null) continue;
            for (String noteName : noteCollection) {
                schemaPaths.add(SchemaPath.create((boolean)true, (QName[])new QName[]{QName.create((QName)qName, (String)noteName)}));
            }
        }
    }

    /*
     * Loose catch block
     */
    private JSONObject readRcEquipment(DOMMountPoint mountPoint, QName equipQName) {
        block31: {
            Optional opDomDataBroker = mountPoint.getService(DOMDataBroker.class);
            if (!opDomDataBroker.isPresent()) {
                LOG.warn("DOMDataBroker doesn't exist!");
                return new JSONObject();
            }
            Throwable throwable = null;
            try (DOMDataTreeReadTransaction readTransaction = ((DOMDataBroker)opDomDataBroker.get()).newReadOnlyTransaction();){
                JSONObject jSONObject;
                Throwable throwable2;
                NormalizedNodeWriter nodeWriter;
                block32: {
                    block33: {
                        Optional<NormalizedNode<?, ?>> optionalData = this.readFromDataBroker(readTransaction, equipQName);
                        if (!optionalData.isPresent()) {
                            optionalData = this.readFromDataBroker(readTransaction, equipQName);
                        }
                        if (!optionalData.isPresent()) break block31;
                        StringWriter writer = new StringWriter();
                        NormalizedNodeStreamWriter jsonStream = JSONNormalizedNodeStreamWriter.createExclusiveWriter((JSONCodecFactory)JSONCodecFactorySupplier.DRAFT_LHOTKA_NETMOD_YANG_JSON_02.getShared(mountPoint.getSchemaContext()), (SchemaPath)SchemaPath.ROOT, null, (JsonWriter)JsonWriterFactory.createJsonWriter((Writer)writer, (int)2));
                        nodeWriter = NormalizedNodeWriter.forStreamWriter((NormalizedNodeStreamWriter)jsonStream);
                        throwable2 = null;
                        nodeWriter.write(optionalData.get());
                        JSONObject jsonEquipment = new JSONObject(writer.getBuffer().toString());
                        jSONObject = jsonEquipment.getJSONObject(RC_MANAGED_ELEMENT);
                        if (nodeWriter == null) break block32;
                        if (throwable2 == null) break block33;
                        try {
                            nodeWriter.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        break block32;
                    }
                    nodeWriter.close();
                }
                return jSONObject;
                catch (Throwable throwable4) {
                    try {
                        try {
                            try {
                                throwable2 = throwable4;
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                if (nodeWriter != null) {
                                    if (throwable2 != null) {
                                        try {
                                            nodeWriter.close();
                                        }
                                        catch (Throwable throwable6) {
                                            throwable2.addSuppressed(throwable6);
                                        }
                                    } else {
                                        nodeWriter.close();
                                    }
                                }
                                throw throwable5;
                            }
                        }
                        catch (IOException | IllegalStateException | JSONException ex) {
                            LOG.warn("Transform raisecom-equipment to json format failed!", ex);
                        }
                    }
                    catch (Throwable throwable7) {
                        throwable = throwable7;
                        throw throwable7;
                    }
                    catch (Throwable throwable8) {
                        throw throwable8;
                    }
                }
            }
        }
        return new JSONObject();
    }

    private Optional<NormalizedNode<?, ?>> readFromDataBroker(DOMDataTreeReadTransaction readTransaction, QName qName) {
        try {
            return (Optional)readTransaction.read(LogicalDatastoreType.OPERATIONAL, YangInstanceIdentifier.of((QName)qName)).get(30L, TimeUnit.SECONDS);
        }
        catch (IllegalArgumentException | InterruptedException | ExecutionException | TimeoutException ex) {
            LOG.warn("Read {} from dataBroker failed! {}", (Object)qName, (Object)ex.getMessage());
            return Optional.empty();
        }
    }

    private void registerNoteListeners(List<SchemaPath> schemaPaths, DOMMountPoint mountPoint) {
        if (!schemaPaths.isEmpty()) {
            Optional opDomNoteServ = mountPoint.getService(DOMNotificationService.class);
            if (!opDomNoteServ.isPresent()) {
                LOG.warn("DOMNotificationService of node {} doesn't exist!", (Object)this.netconfId);
                return;
            }
            ((DOMNotificationService)opDomNoteServ.get()).registerNotificationListener((DOMNotificationListener)new NotificationsListener(this.netconfId, mountPoint), schemaPaths);
        }
        LOG.info("{} registers notification listeners: {}", (Object)this.netconfId, schemaPaths);
    }

    private void subscribeNotes(DOMMountPoint mountPoint) {
        Optional mountRpcServices = mountPoint.getService(DOMRpcService.class);
        if (!mountRpcServices.isPresent()) {
            LOG.warn("No RpcService to use.");
            return;
        }
        switch (PropertiesReader.getInstance().getNotificationsMode()) {
            case SUBSCRIBE: {
                ((DOMRpcService)mountRpcServices.get()).invokeRpc(NetconfMessageTransformUtil.toPath((QName)NetconfMessageTransformUtil.CREATE_SUBSCRIPTION_RPC_QNAME), (NormalizedNode)NetconfMessageTransformUtil.CREATE_SUBSCRIPTION_RPC_CONTENT);
                break;
            }
            case SUBSCRIBE_DEFAULT_FILTER: {
                NormalizedNode subscriptionInput = PropertiesReader.getInstance().getSubscription().getSubscriptionInput();
                ((DOMRpcService)mountRpcServices.get()).invokeRpc(NetconfMessageTransformUtil.toPath((QName)NetconfMessageTransformUtil.CREATE_SUBSCRIPTION_RPC_QNAME), subscriptionInput);
                break;
            }
        }
    }

    private QName parseQName(String input) {
        Matcher matcher = QNAME_PATTERN_FULL.matcher(input);
        if (matcher.matches()) {
            String namespace = matcher.group(1);
            String revision = matcher.group(2);
            String localName = matcher.group(3);
            return QName.create((String)namespace, (String)revision, (String)localName);
        }
        matcher = QNAME_PATTERN_NO_REVISION.matcher(input);
        if (matcher.matches()) {
            URI namespace = URI.create(matcher.group(1));
            String localName = matcher.group(2);
            return QName.create((URI)namespace, (String)localName);
        }
        return null;
    }
}

