/*
 * Decompiled with CFR 0.152.
 */
package com.raisecom.zerotouch.rabbitmq;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.raisecom.zerotouch.util.RabbitMqProp;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RabbitMQProducer {
    private static final Logger LOG = LoggerFactory.getLogger(RabbitMQProducer.class);
    private static final String NETCONF_ONLINE_QUEUE = "netconf_online";
    private static final String NOTIFICATIONS_QUEUE = "notifications";
    private static volatile RabbitMQProducer instance;
    private final Object lock = new Object();
    private final Connection connection;
    private final Channel channel;

    private RabbitMQProducer(RabbitMqProp rabbitMqProp) {
        ConnectionFactory factory = new ConnectionFactory();
        factory.setHost(rabbitMqProp.getRabbitMqIp());
        factory.setPort(rabbitMqProp.getRabbitMqPort());
        factory.setUsername(rabbitMqProp.getUsername());
        factory.setPassword(rabbitMqProp.getPassword());
        try {
            this.connection = factory.newConnection();
            this.channel = this.connection.createChannel();
            this.channel.queueDeclare(NETCONF_ONLINE_QUEUE, true, false, false, null);
            this.channel.queueDeclare(NOTIFICATIONS_QUEUE, true, false, false, null);
        }
        catch (IOException | TimeoutException ex) {
            throw new IllegalStateException("Create rabbitMQ connection failed", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RabbitMQProducer newInstance(RabbitMqProp rabbitMqProp) {
        Class<RabbitMQProducer> clazz = RabbitMQProducer.class;
        synchronized (RabbitMQProducer.class) {
            if (instance != null) {
                throw new UnsupportedOperationException();
            }
            instance = new RabbitMQProducer(rabbitMqProp);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RabbitMQProducer getInstance() {
        Class<RabbitMQProducer> clazz = RabbitMQProducer.class;
        synchronized (RabbitMQProducer.class) {
            if (instance == null) {
                throw new UnsupportedOperationException("Uninitialized!");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(String queue, String message, String msgDesc) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.channel.basicPublish("", queue, true, null, message.getBytes("utf-8"));
            }
            LOG.warn("Send rabbitMQ message {} {}", (Object)queue, (Object)msgDesc);
        }
        catch (IOException ioEx) {
            LOG.warn("Send rabbitMQ message failed! {} {} {}", new Object[]{queue, msgDesc, ioEx.getMessage()});
        }
    }

    public void close() {
        try {
            if (null != this.channel) {
                this.channel.close();
            }
            if (null != this.connection) {
                this.connection.close();
            }
        }
        catch (IOException ioEx) {
            LOG.error("Close rabbitMQ conneciton/channel failed!", (Throwable)ioEx);
        }
        catch (TimeoutException timeoutEx) {
            LOG.error("Close rabbitMQ channel timeout!", (Throwable)timeoutEx);
        }
    }
}

