/*
 * Decompiled with CFR 0.152.
 */
package com.raisecom.zerotouch.netconf.notificationlistener;

import com.google.gson.stream.JsonWriter;
import com.raisecom.zerotouch.kafka.KafkaProducer;
import com.raisecom.zerotouch.rabbitmq.RabbitMQProducer;
import com.raisecom.zerotouch.util.PropertiesReader;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.jdt.annotation.NonNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.opendaylight.mdsal.dom.api.DOMMountPoint;
import org.opendaylight.mdsal.dom.api.DOMNotification;
import org.opendaylight.mdsal.dom.api.DOMNotificationListener;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeWriter;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactory;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactorySupplier;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.gson.JsonWriterFactory;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationsListener
implements DOMNotificationListener {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationsListener.class);
    private static final String NOTIFICATIONS = "notifications";
    private static final String NODE_ID = "nodeId";
    private static final String NETCONF_ID = "netconfId";
    private static final String OPER_TYPE = "oper-type";
    private static final String MD5 = "checkcode-md5";
    private static final String ALARM_TOPIC = "Alarm";
    private static final String PPPOEIP_TOPIC = "raisecom-ip";
    private static final String UPGRADE_TOPIC = "sdnc-ems-device-upgrade";
    private static final String PING_TRACEROUTE_TOPIC = "sdnc-ems-ping-traceroute";
    private static final String CURRENT_ALARM_REP0RT = "raisecom-alarm:current-alarm-report";
    private static final String IP_NOTIFICATION = "raisecom-ip-notification:interface-ip-notification";
    private static final String UPLOAD_REPLY = "raisecom-upgrade:uploadreply";
    private static final String DOWNLOAD_REPLY = "raisecom-upgrade:downloadreply";
    private static final String INTERFACE = "interface";
    private static final String PING_DISPLAY = "raisecom-ping:ping-display";
    private static final String PING_DISPLAY_COMPLETE = "raisecom-ping:ping-display-complete";
    private static final String TRACEROUTE_DISPLAY = "raisecom-traceroute:traceroute-display";
    private static final String TRACEROUTE_DISPLAY_COMPLETE = "raisecom-traceroute:traceroute-display-complete";
    private static final String GATEWAY = "gateway";
    private static final String DEFAULT_GATEWAY = "default_gw";
    private final String nodeId;
    private final DOMMountPoint mountPoint;

    public NotificationsListener(String nodeId, DOMMountPoint mountPoint) {
        this.nodeId = nodeId;
        this.mountPoint = mountPoint;
    }

    public void onNotification(@NonNull DOMNotification notification) {
        QName qName = notification.getType().getLastComponent();
        JSONObject note = this.parseNotification(notification.getBody(), SchemaPath.create((boolean)true, (QName[])new QName[]{qName}));
        switch (qName.getLocalName()) {
            case "current-alarm-report": {
                this.handleAlarmNotification(note);
                break;
            }
            case "interface-ip-notification": {
                this.handleRcIpNotification(note, qName.getNamespace().getPath());
                break;
            }
            case "downloadreply": {
                this.handleDownloadNotification(note);
                break;
            }
            case "uploadreply": {
                this.handleUploadNotification(note);
                break;
            }
            case "ping-display": {
                this.handlePingTracerouteNote(note, qName.getLocalName(), PING_DISPLAY);
                break;
            }
            case "ping-display-complete": {
                this.handlePingTracerouteNote(note, qName.getLocalName(), PING_DISPLAY_COMPLETE);
                break;
            }
            case "traceroute-display": {
                this.handlePingTracerouteNote(note, qName.getLocalName(), TRACEROUTE_DISPLAY);
                break;
            }
            case "traceroute-display-complete": {
                this.handlePingTracerouteNote(note, qName.getLocalName(), TRACEROUTE_DISPLAY_COMPLETE);
                break;
            }
            case "platform-config-notification": 
            case "cli-runconfig": {
                note.put(NODE_ID, (Object)this.nodeId);
                this.sendMessage(qName.getLocalName(), note.toString());
                break;
            }
            default: {
                note.put(NODE_ID, (Object)this.nodeId);
                this.sendMessage(NOTIFICATIONS, note.toString());
            }
        }
    }

    protected void handleAlarmNotification(JSONObject jsonAlarm) {
        try {
            JSONArray notifications = jsonAlarm.getJSONObject(CURRENT_ALARM_REP0RT).getJSONArray(NOTIFICATIONS);
            for (int i = 0; i < notifications.length(); ++i) {
                JSONObject notification = notifications.getJSONObject(i);
                JSONObject alarm = new JSONObject();
                alarm.put(NODE_ID, (Object)this.nodeId);
                alarm.put("alarmCode", notification.get("notification-id"));
                alarm.put("alarmName", notification.get("alarm-name"));
                alarm.put("severity", notification.get("alarm-severity"));
                alarm.put("timestamp", notification.get("ne-time"));
                alarm.put("alarmStatus", notification.get("alarm-status"));
                alarm.put("ipaddr", notification.get("admin-ip"));
                alarm.put("sequenceNo", notification.get("sequence-no"));
                alarm.put("objectName", notification.get("object-name"));
                alarm.put("isClearable", notification.get("is-clearable"));
                if (notification.has("probable-cause")) {
                    alarm.put("probableCause", notification.get("probable-cause"));
                }
                if (notification.has("additional-text")) {
                    alarm.put("additionalText", notification.get("additional-text"));
                }
                this.sendMessage(ALARM_TOPIC, alarm.toString());
            }
        }
        catch (JSONException jsonEx) {
            LOG.warn("Parse alarm notification failed! {}", (Object)jsonEx.getMessage());
        }
    }

    protected void handleRcIpNotification(JSONObject notification, String uri) {
        try {
            if (uri.contains("raisecom-ip-notification")) {
                JSONArray interfaces = notification.getJSONObject(IP_NOTIFICATION).getJSONArray(INTERFACE);
                for (Object object : interfaces) {
                    JSONObject rcInterface = (JSONObject)object;
                    JSONObject rcIp = new JSONObject();
                    rcIp.put(NETCONF_ID, (Object)this.nodeId);
                    rcIp.put("name", rcInterface.get("interface-name"));
                    rcIp.put("address-type", rcInterface.get("address-type"));
                    rcIp.put("status", rcInterface.get("status"));
                    JSONArray ips = rcInterface.has("ipv4") ? rcInterface.getJSONArray("ipv4") : rcInterface.getJSONArray("ipv6");
                    JSONObject ip = ips.getJSONObject(0);
                    rcIp.put("ip", ip.get("ip"));
                    if (ip.has(GATEWAY)) {
                        rcIp.put(GATEWAY, ip.get(GATEWAY));
                    }
                    if (ip.has(DEFAULT_GATEWAY)) {
                        rcIp.put(DEFAULT_GATEWAY, ip.get(DEFAULT_GATEWAY));
                    }
                    this.sendMessage(PPPOEIP_TOPIC, rcIp.toString());
                }
            } else {
                notification.put(NETCONF_ID, (Object)this.nodeId);
                this.sendMessage(PPPOEIP_TOPIC, notification.toString());
            }
        }
        catch (JSONException jsonEx) {
            LOG.warn("Parse pppoeIp notification failed! {}", (Object)jsonEx.getMessage());
        }
    }

    protected void handleDownloadNotification(JSONObject downloadReply) {
        try {
            JSONObject download = downloadReply.getJSONObject(DOWNLOAD_REPLY);
            download.put(NETCONF_ID, (Object)this.nodeId);
            download.put("type", (Object)"download");
            this.sendMessage(UPGRADE_TOPIC, download.toString());
        }
        catch (JSONException jsonEx) {
            LOG.warn("Parse download notification failed! {}", (Object)jsonEx.getMessage());
        }
    }

    protected void handleUploadNotification(JSONObject uploadReply) {
        try {
            JSONObject upload = uploadReply.getJSONObject(UPLOAD_REPLY);
            upload.put(NETCONF_ID, (Object)this.nodeId);
            upload.put("type", (Object)"upload");
            if (upload.has(MD5)) {
                upload.put("checkCodeMd5", upload.get(MD5));
                upload.remove(MD5);
            }
            this.sendMessage(UPGRADE_TOPIC, upload.toString());
        }
        catch (JSONException jsonEx) {
            LOG.warn("Parse download notification failed! {}", (Object)jsonEx.getMessage());
        }
    }

    protected void handlePingTracerouteNote(JSONObject reply, String localName, String noteName) {
        try {
            JSONObject note = reply.getJSONObject(noteName);
            note.put(NETCONF_ID, (Object)this.nodeId);
            note.put(OPER_TYPE, (Object)localName);
            this.sendMessage(PING_TRACEROUTE_TOPIC, note.toString());
        }
        catch (JSONException jsonEx) {
            LOG.warn("Parse ping or traceroute notification failed! {}", (Object)jsonEx.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected JSONObject parseNotification(ContainerNode container, SchemaPath schemaPath) {
        StringWriter writer = new StringWriter();
        NormalizedNodeStreamWriter jsonStream = JSONNormalizedNodeStreamWriter.createExclusiveWriter((JSONCodecFactory)JSONCodecFactorySupplier.DRAFT_LHOTKA_NETMOD_YANG_JSON_02.getShared(this.mountPoint.getSchemaContext()), (SchemaPath)schemaPath, null, (JsonWriter)JsonWriterFactory.createJsonWriter((Writer)writer, (int)2));
        try (NormalizedNodeWriter nodeWriter = NormalizedNodeWriter.forStreamWriter((NormalizedNodeStreamWriter)jsonStream);){
            nodeWriter.write((NormalizedNode)container);
            String notification = writer.getBuffer().toString();
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} receives {} notification {}", new Object[]{this.nodeId, schemaPath.getLastComponent(), notification});
            }
            JSONObject jSONObject = new JSONObject(notification);
            return jSONObject;
        }
        catch (IOException | JSONException ex) {
            LOG.warn("Parse container node from notification failed! {}", (Object)ex.getMessage());
            return new JSONObject();
        }
    }

    private void sendMessage(String topic, String message) {
        switch (PropertiesReader.getInstance().getMsgMiddleware()) {
            case KAFKA: {
                KafkaProducer.getInstance().sendMessage(topic, null, message, message);
                break;
            }
            case RABBIT_MQ: {
                RabbitMQProducer.getInstance().sendMessage(topic, message, message);
                break;
            }
        }
    }
}

