/*
 * Decompiled with CFR 0.152.
 */
package com.raisecom.zerotouch.kafka;

import com.raisecom.zerotouch.util.KaProducerProp;
import com.raisecom.zerotouch.util.PropertiesReader;
import java.util.Properties;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.KafkaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KafkaProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaProducer.class);
    private static volatile KafkaProducer instance = null;
    private final org.apache.kafka.clients.producer.KafkaProducer producer;
    private final Object lock = new Object();

    private KafkaProducer(String kafkaServers) {
        KaProducerProp kaProducerProp = PropertiesReader.getInstance().getKaProducerProp();
        Properties properties = kaProducerProp.toProperties(kafkaServers);
        this.producer = new org.apache.kafka.clients.producer.KafkaProducer(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KafkaProducer newInstance(String kafkaServers) {
        Class<KafkaProducer> clazz = KafkaProducer.class;
        synchronized (KafkaProducer.class) {
            if (instance == null) {
                instance = new KafkaProducer(kafkaServers);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KafkaProducer getInstance() {
        Class<KafkaProducer> clazz = KafkaProducer.class;
        synchronized (KafkaProducer.class) {
            if (instance == null) {
                throw new UnsupportedOperationException("Uninitialized!");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void destroyKafkaProducer() {
        if (this.producer != null) {
            try {
                this.producer.close();
                LOG.info("Destroy KafkaProducer.");
            }
            catch (KafkaException kafkaEx) {
                LOG.warn("Destroy KafkaProducer failed!", (Throwable)kafkaEx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(String topic, String key, String message, String msgDesc) {
        ProducerRecord record = new ProducerRecord(topic, (Object)key, (Object)message);
        Object object = this.lock;
        synchronized (object) {
            try {
                this.producer.send(record, (recordMetadata, e) -> {
                    if (e != null) {
                        LOG.warn("Send Kafka message [{}, {}, null] failed! message={}. {}", new Object[]{topic, key, msgDesc, e.getMessage()});
                    } else {
                        LOG.warn("Send Kafka message [{}, {}, {}] successfully! message={} partition={}", new Object[]{topic, key, recordMetadata.offset(), msgDesc, recordMetadata.partition()});
                    }
                });
            }
            catch (Exception ex) {
                LOG.warn("Send Kafka message [{}, {}, null] failed! message={}. {}", new Object[]{topic, key, msgDesc, ex.getMessage()});
            }
        }
    }
}

