/*
 * Decompiled with CFR 0.152.
 */
package com.raisecom.zerotouch;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.MoreExecutors;
import com.raisecom.zerotouch.MyService;
import com.raisecom.zerotouch.constant.MsgMiddleware;
import com.raisecom.zerotouch.constant.StartUpMode;
import com.raisecom.zerotouch.kafka.KafkaProducer;
import com.raisecom.zerotouch.netconf.databrokerlistener.MountPointChangeListener;
import com.raisecom.zerotouch.rabbitmq.RabbitMQProducer;
import com.raisecom.zerotouch.restclient.NetconfRestClient;
import com.raisecom.zerotouch.threads.NeTaskManager;
import com.raisecom.zerotouch.util.Decrypt;
import com.raisecom.zerotouch.util.IpAddressMatcher;
import com.raisecom.zerotouch.util.PropertiesReader;
import com.raisecom.zerotouch.util.RabbitMqProp;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import javax.ws.rs.ProcessingException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMMountPointService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netconf.callhome.server.rev161109.NetconfCallhomeServer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netconf.callhome.server.rev161109.credentials.Credentials;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netconf.callhome.server.rev161109.credentials.CredentialsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netconf.callhome.server.rev161109.netconf.callhome.server.Global;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netconf.callhome.server.rev161109.netconf.callhome.server.GlobalBuilder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyServiceImpl
implements MyService,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(MyServiceImpl.class);
    public static final String NETCONF_HOSTIP = "netconf-hostip";
    private static final String ADMIN = "admin";
    private static final String PROCESS_NAME = "process_name";
    private static final String PORT = "port";
    private static final String RESTCONF_URL = "http://localhost:8181/restconf";
    private final DataBroker dataBroker;
    private final DOMMountPointService domMountPointService;
    private MountPointChangeListener mountPointChangeListener;

    public MyServiceImpl(DataBroker dataBroker, DOMMountPointService domMountPointService) {
        this.dataBroker = dataBroker;
        this.domMountPointService = domMountPointService;
    }

    public void init() {
        LOG.warn("Initializing online plugin...");
        try {
            StartUpMode startUpMode = PropertiesReader.getInstance().getStartUpMode();
            LOG.info("Startup mode = {}", (Object)startUpMode);
            switch (startUpMode) {
                case ORIGINAL: {
                    return;
                }
                case SINGLE: {
                    this.startAlone();
                    break;
                }
                case CLUSTER: {
                    this.startInCluster();
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Unknown startup mode %s", new Object[]{startUpMode}));
                }
            }
        }
        catch (IllegalArgumentException | IllegalStateException ex) {
            LOG.error("Initialize online plugin failed! Exiting...", (Throwable)ex);
            System.exit(-1);
        }
    }

    private void startInCluster() {
        String clusterHost = PropertiesReader.getInstance().getClusterHost();
        if (!IpAddressMatcher.isIpValid(clusterHost)) {
            throw new IllegalArgumentException(String.format("Invalid IP address of Cluster: %s", clusterHost));
        }
        String clusterPort = PropertiesReader.getInstance().getClusterPort();
        if (!IpAddressMatcher.isPortValid(clusterPort)) {
            throw new IllegalArgumentException(String.format("Invalid REST port of Cluster: %s", clusterPort));
        }
        this.getLocalIp(clusterHost, clusterPort);
        this.registerModule(clusterHost, clusterPort);
        this.initMsgMiddleWare();
        this.initCallHome();
        this.initMountPointListener();
    }

    private void startAlone() {
        this.initMsgMiddleWare();
        this.initCallHome();
        this.initMountPointListener();
    }

    private String getLocalIp(String clusterHost, String clusterPort) {
        String localIp;
        String url = String.format("http://%s:%s/cluster/localNode", clusterHost, clusterPort);
        try {
            String response = NetconfRestClient.get(url);
            JSONObject errorInfo = new JSONObject(response);
            localIp = errorInfo.getString("nodeIp");
        }
        catch (ProcessingException | JSONException ex) {
            throw new IllegalStateException("Query or parse local IP from Cluster failed!", ex);
        }
        if (!IpAddressMatcher.isIpValid(localIp)) {
            throw new IllegalArgumentException(String.format("Invalid local IP address: %s", localIp));
        }
        PropertiesReader.getInstance().setLocalIp(localIp);
        return localIp;
    }

    private void registerModule(String clusterHost, String clusterPort) {
        this.waitUntilRestConfReady();
        String url = String.format("http://%s:%s/cluster/module", clusterHost, clusterPort);
        JSONObject body = new JSONObject();
        body.put("name", (Object)"netconf");
        body.put("moduleName", (Object)"netconf");
        body.put(PORT, (Object)"8181");
        body.put("status", (Object)"run");
        body.put("role", (Object)"providers");
        JSONObject health = new JSONObject();
        health.put("type", (Object)"rest");
        health.put("uri", (Object)RESTCONF_URL);
        health.put("user", (Object)ADMIN);
        health.put("pwd", (Object)ADMIN);
        JSONArray checkResults = new JSONArray();
        checkResults.put(204);
        health.put("restSuccessResult", (Object)checkResults);
        body.put("health", (Object)health);
        try {
            NetconfRestClient.post(url, body.toString());
        }
        catch (ProcessingException processEx) {
            LOG.error("Register netconf module failed!", (Throwable)processEx);
            System.exit(-1);
        }
    }

    private void waitUntilRestConfReady() {
        long time = System.currentTimeMillis();
        block2: while (true) {
            try {
                while (true) {
                    int restConfStatus;
                    if ((restConfStatus = NetconfRestClient.getFromRestConf(RESTCONF_URL)) == 204) {
                        LOG.info("RestConf costs {} milliseconds to start.", (Object)(System.currentTimeMillis() - time));
                        break block2;
                    }
                    Thread.sleep(30000L);
                }
            }
            catch (InterruptedException | ProcessingException e) {
                LOG.warn(e.getMessage());
                continue;
            }
            break;
        }
    }

    private void initMsgMiddleWare() {
        switch (PropertiesReader.getInstance().getMsgMiddleware()) {
            case NONE: {
                LOG.warn("Running without message middleware.");
                break;
            }
            case KAFKA: {
                KafkaProducer.newInstance(this.queryKafkaServers());
                break;
            }
            case RABBIT_MQ: {
                RabbitMQProducer.newInstance(this.queryRabbitMqServer());
                break;
            }
            default: {
                LOG.warn("No message middleware selected.");
            }
        }
    }

    private String queryKafkaServers() {
        JSONArray allModules = this.queryAllModulesFromMsp();
        if (allModules.isEmpty()) {
            return PropertiesReader.getInstance().getDefaultKafkaServers();
        }
        StringBuilder kafkaServersBuilder = new StringBuilder();
        String kafka = MsgMiddleware.KAFKA.getName();
        for (Object obj : allModules) {
            JSONObject module;
            if (!(obj instanceof JSONObject) || !(module = (JSONObject)obj).has(PROCESS_NAME) || !kafka.equals(module.get(PROCESS_NAME))) continue;
            String moduleIp = module.getString("ip");
            String modulePort = module.getString(PORT);
            if (!IpAddressMatcher.isIpValid(moduleIp) || !IpAddressMatcher.isPortValid(modulePort)) continue;
            kafkaServersBuilder.append(moduleIp).append(":").append(modulePort).append(",");
        }
        if (kafkaServersBuilder.length() > 0) {
            kafkaServersBuilder.deleteCharAt(kafkaServersBuilder.length() - 1);
            return kafkaServersBuilder.toString();
        }
        return PropertiesReader.getInstance().getDefaultKafkaServers();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JSONArray queryAllModulesFromMsp() {
        String mspSysmng = PropertiesReader.getInstance().getMspSysmng();
        StringBuilder builder = new StringBuilder(65536);
        try (BufferedReader reader = new BufferedReader(new FileReader(mspSysmng));){
            String line;
            while (null != (line = reader.readLine())) {
                builder.append(line);
            }
            JSONObject systemJson = new JSONObject(builder.toString());
            JSONArray jSONArray = systemJson.getJSONArray("process");
            return jSONArray;
        }
        catch (IOException | JSONException ex) {
            LOG.warn("Read system.json failed! {}", (Object)ex.getMessage());
            return new JSONArray();
        }
    }

    private RabbitMqProp queryRabbitMqServer() {
        String rabbitMqServer = PropertiesReader.getInstance().getDefaultRabbitMqServer();
        JSONObject global = this.queryGlobalFromMsp();
        if (global != null) {
            try {
                JSONObject apiGateway = global.getJSONObject("apigateway");
                String innerIp = apiGateway.getString("inner");
                if (!IpAddressMatcher.isIpValid(innerIp)) {
                    throw new IllegalArgumentException(String.format("Invalid inner IP %s", innerIp));
                }
                if (IpAddressMatcher.isIpv6(innerIp)) {
                    innerIp = "[" + innerIp + "]";
                }
                JSONObject rabbitMqObject = global.getJSONObject("rabbitmq");
                int rabbitMqPort = rabbitMqObject.getInt(PORT);
                String rabbitMqUsr = rabbitMqObject.getString("user");
                String cipher = global.getString("cipher");
                String rabbitMqPwd = Decrypt.decrypt(rabbitMqObject.getString("password"), cipher);
                rabbitMqServer = String.format("%s_%d", innerIp, rabbitMqPort);
                LOG.info("RabbitMQ server: {}", (Object)rabbitMqServer);
                return new RabbitMqProp.RabbitMqPropBuilder(rabbitMqServer, rabbitMqUsr, rabbitMqPwd).build();
            }
            catch (JSONException jsonEx) {
                throw new IllegalStateException("Query RabbitMQ server failed!", jsonEx);
            }
        }
        String defaultUsr = PropertiesReader.getInstance().getDefaultRabbitMqUsr();
        String defaultPwd = PropertiesReader.getInstance().getDefaultRabbitMqPwd();
        if (rabbitMqServer == null || defaultUsr == null || defaultPwd == null) {
            throw new IllegalArgumentException("Illegal default RabbitMQ server.");
        }
        LOG.warn("Using default RabbitMQ server: {}", (Object)rabbitMqServer);
        return new RabbitMqProp.RabbitMqPropBuilder(rabbitMqServer, defaultUsr, defaultPwd).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JSONObject queryGlobalFromMsp() {
        String mspGlobal = PropertiesReader.getInstance().getMspGlobal();
        StringBuilder builder = new StringBuilder(4096);
        try (BufferedReader reader = new BufferedReader(new FileReader(mspGlobal));){
            String line;
            while (null != (line = reader.readLine())) {
                builder.append(line);
            }
            JSONObject jSONObject = new JSONObject(builder.toString());
            return jSONObject;
        }
        catch (IOException | JSONException ex) {
            LOG.warn("Query global from msp failed! {}", (Object)ex.getMessage());
            return null;
        }
    }

    private void initCallHome() {
        if (PropertiesReader.getInstance().isCallHomeGlobalEnable()) {
            this.addGlobalConfig();
        }
    }

    private void addGlobalConfig() {
        WriteTransaction txTransaction = this.dataBroker.newWriteOnlyTransaction();
        Credentials credentials = new CredentialsBuilder().setUsername(PropertiesReader.getInstance().getCallHomeUsr()).setPasswords(PropertiesReader.getInstance().getCallHomePwds()).build();
        Global global = new GlobalBuilder().setAcceptAllSshKeys(Boolean.TRUE).setCredentials(credentials).build();
        txTransaction.merge(LogicalDatastoreType.CONFIGURATION, InstanceIdentifier.create(NetconfCallhomeServer.class).child(Global.class), (DataObject)global);
        txTransaction.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                LOG.info("Create CallHome global configuration successfully.");
            }

            public void onFailure(Throwable cause) {
                throw new IllegalStateException("Create CallHome global configuration failed!", cause);
            }
        }, MoreExecutors.directExecutor());
    }

    private void initMountPointListener() {
        this.mountPointChangeListener = new MountPointChangeListener(this.dataBroker, this.domMountPointService);
    }

    @Override
    public void close() {
        LOG.info("Close MyServiceImpl...");
        if (this.mountPointChangeListener != null) {
            this.mountPointChangeListener.destroy();
        }
        switch (PropertiesReader.getInstance().getMsgMiddleware()) {
            case NONE: {
                break;
            }
            case KAFKA: {
                KafkaProducer.getInstance().destroyKafkaProducer();
                break;
            }
            case RABBIT_MQ: {
                RabbitMQProducer.getInstance().close();
                break;
            }
        }
        NeTaskManager.getInstance().shutdown();
    }
}

