/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.derby.impl;

import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.apache.derby.jdbc.EmbeddedConnectionPoolDataSource;
import org.apache.derby.jdbc.EmbeddedDataSource;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.apache.derby.jdbc.EmbeddedXADataSource;
import org.apache.derby.jdbc.ReferenceableDataSource;
import org.ops4j.pax.jdbc.common.BeanConfig;
import org.osgi.service.jdbc.DataSourceFactory;

public class DerbyDataSourceFactory
implements DataSourceFactory {
    private static final String DERBY_PREFIX = "jdbc:derby:";

    public DataSource createDataSource(Properties props) throws SQLException {
        EmbeddedDataSource ds = new EmbeddedDataSource();
        this.setProperties((ReferenceableDataSource)ds, props);
        return ds;
    }

    private void setProperties(ReferenceableDataSource ds, Properties properties) throws SQLException {
        Properties props = (Properties)properties.clone();
        String databaseName = (String)props.remove("databaseName");
        if (databaseName != null) {
            ds.setDatabaseName(databaseName);
        }
        String createDatabase = (String)props.remove("createDatabase");
        ds.setCreateDatabase(createDatabase);
        String password = (String)props.remove("password");
        ds.setPassword(password);
        String user = (String)props.remove("user");
        ds.setUser(user);
        String url = (String)props.remove("url");
        this.applyUrl(ds, url);
        if (!props.isEmpty()) {
            BeanConfig.configure((Object)ds, props);
        }
    }

    private void applyUrl(ReferenceableDataSource ds, String url) {
        String options;
        if (url == null) {
            return;
        }
        if (!url.startsWith(DERBY_PREFIX)) {
            throw new IllegalArgumentException("The supplied URL is no derby url: " + url);
        }
        String suburl = url.substring(DERBY_PREFIX.length());
        String[] parts = suburl.split(";");
        String database = parts[0];
        if (database != null) {
            ds.setDatabaseName(database);
        }
        if (parts.length > 1 && (options = parts[1]).length() > 0) {
            ds.setConnectionAttributes(options);
        }
    }

    public ConnectionPoolDataSource createConnectionPoolDataSource(Properties props) throws SQLException {
        EmbeddedConnectionPoolDataSource ds = new EmbeddedConnectionPoolDataSource();
        this.setProperties((ReferenceableDataSource)ds, props);
        return ds;
    }

    public XADataSource createXADataSource(Properties props) throws SQLException {
        EmbeddedXADataSource ds = new EmbeddedXADataSource();
        this.setProperties((ReferenceableDataSource)ds, props);
        return ds;
    }

    public Driver createDriver(Properties props) throws SQLException {
        EmbeddedDriver driver = new EmbeddedDriver();
        return driver;
    }
}

