/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.datastores.datastore.locks.lock.type.partial.lock;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.datastores.datastore.locks.LockInfo;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.datastores.datastore.locks.lock.type.partial.lock.PartialLock;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.datastores.datastore.locks.lock.type.partial.lock.PartialLockKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Xpath10;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public class PartialLockBuilder
implements Builder<PartialLock> {
    private Long _lockId;
    private Long _lockedBySession;
    private List<InstanceIdentifier<?>> _lockedNode;
    private DateAndTime _lockedTime;
    private List<Xpath10> _select;
    private PartialLockKey key;
    Map<Class<? extends Augmentation<PartialLock>>, Augmentation<PartialLock>> augmentation = Collections.emptyMap();

    public PartialLockBuilder() {
    }

    public PartialLockBuilder(LockInfo arg) {
        this._lockedBySession = arg.getLockedBySession();
        this._lockedTime = arg.getLockedTime();
    }

    public PartialLockBuilder(PartialLock base) {
        Map aug;
        this.key = base.key();
        this._lockId = base.getLockId();
        this._lockedBySession = base.getLockedBySession();
        this._lockedNode = base.getLockedNode();
        this._lockedTime = base.getLockedTime();
        this._select = base.getSelect();
        if (base instanceof PartialLockImpl) {
            PartialLockImpl impl = (PartialLockImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<PartialLock>>, Augmentation<PartialLock>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PartialLock>>, Augmentation<PartialLock>>(aug);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof LockInfo) {
            this._lockedBySession = ((LockInfo)arg).getLockedBySession();
            this._lockedTime = ((LockInfo)arg).getLockedTime();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.datastores.datastore.locks.LockInfo]");
    }

    public PartialLockKey key() {
        return this.key;
    }

    public Long getLockId() {
        return this._lockId;
    }

    public Long getLockedBySession() {
        return this._lockedBySession;
    }

    public List<InstanceIdentifier<?>> getLockedNode() {
        return this._lockedNode;
    }

    public DateAndTime getLockedTime() {
        return this._lockedTime;
    }

    public List<Xpath10> getSelect() {
        return this._select;
    }

    public <E$$ extends Augmentation<PartialLock>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public PartialLockBuilder withKey(PartialLockKey key) {
        this.key = key;
        return this;
    }

    private static void checkLockIdRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (long)value);
    }

    public PartialLockBuilder setLockId(Long value) {
        if (value != null) {
            PartialLockBuilder.checkLockIdRange(value);
        }
        this._lockId = value;
        return this;
    }

    private static void checkLockedBySessionRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (long)value);
    }

    public PartialLockBuilder setLockedBySession(Long value) {
        if (value != null) {
            PartialLockBuilder.checkLockedBySessionRange(value);
        }
        this._lockedBySession = value;
        return this;
    }

    public PartialLockBuilder setLockedNode(List<InstanceIdentifier<?>> values) {
        this._lockedNode = values;
        return this;
    }

    public PartialLockBuilder setLockedTime(DateAndTime value) {
        this._lockedTime = value;
        return this;
    }

    public PartialLockBuilder setSelect(List<Xpath10> values) {
        this._select = values;
        return this;
    }

    public PartialLockBuilder addAugmentation(Class<? extends Augmentation<PartialLock>> augmentationType, Augmentation<PartialLock> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PartialLock>>, Augmentation<PartialLock>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public PartialLockBuilder removeAugmentation(Class<? extends Augmentation<PartialLock>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public PartialLock build() {
        return new PartialLockImpl(this);
    }

    private static final class PartialLockImpl
    implements PartialLock {
        private final Long _lockId;
        private final Long _lockedBySession;
        private final List<InstanceIdentifier<?>> _lockedNode;
        private final DateAndTime _lockedTime;
        private final List<Xpath10> _select;
        private final PartialLockKey key;
        private Map<Class<? extends Augmentation<PartialLock>>, Augmentation<PartialLock>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        PartialLockImpl(PartialLockBuilder base) {
            this.key = base.key() != null ? base.key() : new PartialLockKey(base.getLockId());
            this._lockId = this.key.getLockId();
            this._lockedBySession = base.getLockedBySession();
            this._lockedNode = base.getLockedNode();
            this._lockedTime = base.getLockedTime();
            this._select = base.getSelect();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<PartialLock> getImplementedInterface() {
            return PartialLock.class;
        }

        @Override
        public PartialLockKey key() {
            return this.key;
        }

        @Override
        public Long getLockId() {
            return this._lockId;
        }

        @Override
        public Long getLockedBySession() {
            return this._lockedBySession;
        }

        @Override
        public List<InstanceIdentifier<?>> getLockedNode() {
            return this._lockedNode;
        }

        @Override
        public DateAndTime getLockedTime() {
            return this._lockedTime;
        }

        @Override
        public List<Xpath10> getSelect() {
            return this._select;
        }

        public <E$$ extends Augmentation<PartialLock>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._lockId);
            result = 31 * result + Objects.hashCode(this._lockedBySession);
            result = 31 * result + Objects.hashCode(this._lockedNode);
            result = 31 * result + Objects.hashCode(this._lockedTime);
            result = 31 * result + Objects.hashCode(this._select);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PartialLock.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PartialLock other = (PartialLock)obj;
            if (!Objects.equals(this._lockId, other.getLockId())) {
                return false;
            }
            if (!Objects.equals(this._lockedBySession, other.getLockedBySession())) {
                return false;
            }
            if (!Objects.equals(this._lockedNode, other.getLockedNode())) {
                return false;
            }
            if (!Objects.equals(this._lockedTime, other.getLockedTime())) {
                return false;
            }
            if (!Objects.equals(this._select, other.getSelect())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PartialLockImpl otherImpl = (PartialLockImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PartialLock>>, Augmentation<PartialLock>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"PartialLock");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_lockId", (Object)this._lockId);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_lockedBySession", (Object)this._lockedBySession);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_lockedNode", this._lockedNode);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_lockedTime", (Object)this._lockedTime);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_select", this._select);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

