/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.datastores;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.NetconfDatastoreType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.datastores.Datastore;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.datastores.DatastoreKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.datastores.datastore.Locks;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class DatastoreBuilder
implements Builder<Datastore> {
    private Locks _locks;
    private NetconfDatastoreType _name;
    private DatastoreKey key;
    Map<Class<? extends Augmentation<Datastore>>, Augmentation<Datastore>> augmentation = Collections.emptyMap();

    public DatastoreBuilder() {
    }

    public DatastoreBuilder(Datastore base) {
        Map aug;
        this.key = base.key();
        this._name = base.getName();
        this._locks = base.getLocks();
        if (base instanceof DatastoreImpl) {
            DatastoreImpl impl = (DatastoreImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Datastore>>, Augmentation<Datastore>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Datastore>>, Augmentation<Datastore>>(aug);
        }
    }

    public DatastoreKey key() {
        return this.key;
    }

    public Locks getLocks() {
        return this._locks;
    }

    public NetconfDatastoreType getName() {
        return this._name;
    }

    public <E$$ extends Augmentation<Datastore>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public DatastoreBuilder withKey(DatastoreKey key) {
        this.key = key;
        return this;
    }

    public DatastoreBuilder setLocks(Locks value) {
        this._locks = value;
        return this;
    }

    public DatastoreBuilder setName(NetconfDatastoreType value) {
        this._name = value;
        return this;
    }

    public DatastoreBuilder addAugmentation(Class<? extends Augmentation<Datastore>> augmentationType, Augmentation<Datastore> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Datastore>>, Augmentation<Datastore>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public DatastoreBuilder removeAugmentation(Class<? extends Augmentation<Datastore>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Datastore build() {
        return new DatastoreImpl(this);
    }

    private static final class DatastoreImpl
    implements Datastore {
        private final Locks _locks;
        private final NetconfDatastoreType _name;
        private final DatastoreKey key;
        private Map<Class<? extends Augmentation<Datastore>>, Augmentation<Datastore>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        DatastoreImpl(DatastoreBuilder base) {
            this.key = base.key() != null ? base.key() : new DatastoreKey(base.getName());
            this._name = this.key.getName();
            this._locks = base.getLocks();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Datastore> getImplementedInterface() {
            return Datastore.class;
        }

        @Override
        public DatastoreKey key() {
            return this.key;
        }

        @Override
        public Locks getLocks() {
            return this._locks;
        }

        @Override
        public NetconfDatastoreType getName() {
            return this._name;
        }

        public <E$$ extends Augmentation<Datastore>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._locks);
            result = 31 * result + Objects.hashCode((Object)this._name);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Datastore.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Datastore other = (Datastore)obj;
            if (!Objects.equals(this._locks, other.getLocks())) {
                return false;
            }
            if (!Objects.equals((Object)this._name, (Object)other.getName())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                DatastoreImpl otherImpl = (DatastoreImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Datastore>>, Augmentation<Datastore>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Datastore");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_locks", (Object)this._locks);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_name", (Object)((Object)this._name));
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

