/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.NetconfState;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.Capabilities;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.Datastores;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.Schemas;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.Sessions;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.Statistics;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NetconfStateBuilder
implements Builder<NetconfState> {
    private Capabilities _capabilities;
    private Datastores _datastores;
    private Schemas _schemas;
    private Sessions _sessions;
    private Statistics _statistics;
    Map<Class<? extends Augmentation<NetconfState>>, Augmentation<NetconfState>> augmentation = Collections.emptyMap();

    public NetconfStateBuilder() {
    }

    public NetconfStateBuilder(NetconfState base) {
        Map aug;
        this._capabilities = base.getCapabilities();
        this._datastores = base.getDatastores();
        this._schemas = base.getSchemas();
        this._sessions = base.getSessions();
        this._statistics = base.getStatistics();
        if (base instanceof NetconfStateImpl) {
            NetconfStateImpl impl = (NetconfStateImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NetconfState>>, Augmentation<NetconfState>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NetconfState>>, Augmentation<NetconfState>>(aug);
        }
    }

    public Capabilities getCapabilities() {
        return this._capabilities;
    }

    public Datastores getDatastores() {
        return this._datastores;
    }

    public Schemas getSchemas() {
        return this._schemas;
    }

    public Sessions getSessions() {
        return this._sessions;
    }

    public Statistics getStatistics() {
        return this._statistics;
    }

    public <E$$ extends Augmentation<NetconfState>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public NetconfStateBuilder setCapabilities(Capabilities value) {
        this._capabilities = value;
        return this;
    }

    public NetconfStateBuilder setDatastores(Datastores value) {
        this._datastores = value;
        return this;
    }

    public NetconfStateBuilder setSchemas(Schemas value) {
        this._schemas = value;
        return this;
    }

    public NetconfStateBuilder setSessions(Sessions value) {
        this._sessions = value;
        return this;
    }

    public NetconfStateBuilder setStatistics(Statistics value) {
        this._statistics = value;
        return this;
    }

    public NetconfStateBuilder addAugmentation(Class<? extends Augmentation<NetconfState>> augmentationType, Augmentation<NetconfState> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NetconfState>>, Augmentation<NetconfState>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NetconfStateBuilder removeAugmentation(Class<? extends Augmentation<NetconfState>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NetconfState build() {
        return new NetconfStateImpl(this);
    }

    private static final class NetconfStateImpl
    implements NetconfState {
        private final Capabilities _capabilities;
        private final Datastores _datastores;
        private final Schemas _schemas;
        private final Sessions _sessions;
        private final Statistics _statistics;
        private Map<Class<? extends Augmentation<NetconfState>>, Augmentation<NetconfState>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        NetconfStateImpl(NetconfStateBuilder base) {
            this._capabilities = base.getCapabilities();
            this._datastores = base.getDatastores();
            this._schemas = base.getSchemas();
            this._sessions = base.getSessions();
            this._statistics = base.getStatistics();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<NetconfState> getImplementedInterface() {
            return NetconfState.class;
        }

        @Override
        public Capabilities getCapabilities() {
            return this._capabilities;
        }

        @Override
        public Datastores getDatastores() {
            return this._datastores;
        }

        @Override
        public Schemas getSchemas() {
            return this._schemas;
        }

        @Override
        public Sessions getSessions() {
            return this._sessions;
        }

        @Override
        public Statistics getStatistics() {
            return this._statistics;
        }

        public <E$$ extends Augmentation<NetconfState>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._capabilities);
            result = 31 * result + Objects.hashCode(this._datastores);
            result = 31 * result + Objects.hashCode(this._schemas);
            result = 31 * result + Objects.hashCode(this._sessions);
            result = 31 * result + Objects.hashCode(this._statistics);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NetconfState.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NetconfState other = (NetconfState)obj;
            if (!Objects.equals(this._capabilities, other.getCapabilities())) {
                return false;
            }
            if (!Objects.equals(this._datastores, other.getDatastores())) {
                return false;
            }
            if (!Objects.equals(this._schemas, other.getSchemas())) {
                return false;
            }
            if (!Objects.equals(this._sessions, other.getSessions())) {
                return false;
            }
            if (!Objects.equals(this._statistics, other.getStatistics())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NetconfStateImpl otherImpl = (NetconfStateImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NetconfState>>, Augmentation<NetconfState>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"NetconfState");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_capabilities", (Object)this._capabilities);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_datastores", (Object)this._datastores);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_schemas", (Object)this._schemas);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_sessions", (Object)this._sessions);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_statistics", (Object)this._statistics);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

