/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.mdsal.notification.impl.ops;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.NetconfMessage;
import org.opendaylight.netconf.api.NetconfSession;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.mapping.api.SessionAwareNetconfOperation;
import org.opendaylight.netconf.mdsal.notification.impl.NetconfNotificationManager;
import org.opendaylight.netconf.notifications.NetconfNotification;
import org.opendaylight.netconf.notifications.NetconfNotificationListener;
import org.opendaylight.netconf.notifications.NetconfNotificationRegistry;
import org.opendaylight.netconf.notifications.NotificationListenerRegistration;
import org.opendaylight.netconf.util.mapping.AbstractSingletonNetconfOperation;
import org.opendaylight.netconf.util.messages.SubtreeFilter;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714.CreateSubscriptionInput;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714.StreamNameType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CreateSubscription
extends AbstractSingletonNetconfOperation
implements SessionAwareNetconfOperation,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(CreateSubscription.class);
    static final String CREATE_SUBSCRIPTION = "create-subscription";
    private final NetconfNotificationRegistry notifications;
    private final List<NotificationListenerRegistration> subscriptions = new ArrayList<NotificationListenerRegistration>();
    private NetconfSession netconfSession;

    public CreateSubscription(String netconfSessionIdForReporting, NetconfNotificationRegistry notifications) {
        super(netconfSessionIdForReporting);
        this.notifications = notifications;
    }

    protected Element handleWithNoSubsequentOperations(Document document, XmlElement operationElement) throws DocumentedException {
        operationElement.checkName(CREATE_SUBSCRIPTION);
        operationElement.checkNamespace(CreateSubscriptionInput.QNAME.getNamespace().toString());
        Optional filter = operationElement.getOnlyChildElementWithSameNamespaceOptionally("filter");
        Optional startTime = operationElement.getOnlyChildElementWithSameNamespaceOptionally("startTime");
        Preconditions.checkArgument((!startTime.isPresent() ? 1 : 0) != 0, (Object)"StartTime element not yet supported");
        Optional stopTime = operationElement.getOnlyChildElementWithSameNamespaceOptionally("stopTime");
        Preconditions.checkArgument((!stopTime.isPresent() ? 1 : 0) != 0, (Object)"StopTime element not yet supported");
        StreamNameType streamNameType = CreateSubscription.parseStreamIfPresent(operationElement);
        Preconditions.checkNotNull((Object)this.netconfSession);
        if (!this.notifications.isStreamAvailable(streamNameType)) {
            LOG.warn("Registering premature stream {}. No publisher available yet for session {}", (Object)streamNameType, (Object)this.getNetconfSessionIdForReporting());
        }
        NotificationListenerRegistration notificationListenerRegistration = this.notifications.registerNotificationListener(streamNameType, (NetconfNotificationListener)new NotificationSubscription(this.netconfSession, filter));
        this.subscriptions.add(notificationListenerRegistration);
        return document.createElement("ok");
    }

    private static StreamNameType parseStreamIfPresent(XmlElement operationElement) throws DocumentedException {
        Optional stream = operationElement.getOnlyChildElementWithSameNamespaceOptionally("stream");
        return stream.isPresent() ? new StreamNameType(((XmlElement)stream.get()).getTextContent()) : NetconfNotificationManager.BASE_STREAM_NAME;
    }

    protected String getOperationName() {
        return CREATE_SUBSCRIPTION;
    }

    protected String getOperationNamespace() {
        return CreateSubscriptionInput.QNAME.getNamespace().toString();
    }

    public void setSession(NetconfSession session) {
        this.netconfSession = session;
    }

    @Override
    public void close() {
        this.netconfSession = null;
        for (NotificationListenerRegistration subscription : this.subscriptions) {
            subscription.close();
        }
    }

    private static class NotificationSubscription
    implements NetconfNotificationListener {
        private final NetconfSession currentSession;
        private final Optional<XmlElement> filter;

        NotificationSubscription(NetconfSession currentSession, Optional<XmlElement> filter) {
            this.currentSession = currentSession;
            this.filter = filter;
        }

        public void onNotification(StreamNameType stream, NetconfNotification notification) {
            if (this.filter.isPresent()) {
                try {
                    Optional filtered = SubtreeFilter.applySubtreeNotificationFilter((XmlElement)this.filter.get(), (Document)notification.getDocument());
                    if (filtered.isPresent()) {
                        Date eventTime = notification.getEventTime();
                        this.currentSession.sendMessage((NetconfMessage)new NetconfNotification((Document)filtered.get(), eventTime));
                    }
                }
                catch (DocumentedException e) {
                    LOG.warn("Failed to process notification {}", (Object)notification, (Object)e);
                    this.currentSession.sendMessage((NetconfMessage)notification);
                }
            } else {
                this.currentSession.sendMessage((NetconfMessage)notification);
            }
        }
    }
}

