/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.conf;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.net.InetSocketAddress;
import java.util.List;
import org.opendaylight.netconf.api.messages.NetconfHelloMessageAdditionalHeader;
import org.opendaylight.netconf.client.NetconfClientSessionListener;
import org.opendaylight.netconf.client.SslHandlerFactory;
import org.opendaylight.netconf.client.conf.NetconfClientConfiguration;
import org.opendaylight.netconf.nettyutil.ReconnectStrategy;
import org.opendaylight.netconf.nettyutil.ReconnectStrategyFactory;
import org.opendaylight.netconf.nettyutil.handler.ssh.authentication.AuthenticationHandler;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;

public final class NetconfReconnectingClientConfiguration
extends NetconfClientConfiguration {
    private final ReconnectStrategyFactory connectStrategyFactory;

    NetconfReconnectingClientConfiguration(NetconfClientConfiguration.NetconfClientProtocol clientProtocol, InetSocketAddress address, Long connectionTimeoutMillis, NetconfHelloMessageAdditionalHeader additionalHeader, NetconfClientSessionListener sessionListener, ReconnectStrategy reconnectStrategy, ReconnectStrategyFactory connectStrategyFactory, AuthenticationHandler authHandler, SslHandlerFactory sslHandlerFactory, List<Uri> odlHelloCapabilities) {
        super(clientProtocol, address, connectionTimeoutMillis, additionalHeader, sessionListener, reconnectStrategy, authHandler, sslHandlerFactory, odlHelloCapabilities);
        this.connectStrategyFactory = connectStrategyFactory;
        this.validateReconnectConfiguration();
    }

    public ReconnectStrategyFactory getConnectStrategyFactory() {
        return this.connectStrategyFactory;
    }

    private void validateReconnectConfiguration() {
        Preconditions.checkNotNull((Object)this.connectStrategyFactory);
    }

    @Override
    protected MoreObjects.ToStringHelper buildToStringHelper() {
        return super.buildToStringHelper().add("connectStrategyFactory", (Object)this.connectStrategyFactory);
    }
}

