/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.conf;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Optional;
import org.opendaylight.netconf.api.messages.NetconfHelloMessageAdditionalHeader;
import org.opendaylight.netconf.client.NetconfClientSessionListener;
import org.opendaylight.netconf.client.SslHandlerFactory;
import org.opendaylight.netconf.nettyutil.ReconnectStrategy;
import org.opendaylight.netconf.nettyutil.handler.ssh.authentication.AuthenticationHandler;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfClientConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfClientConfiguration.class);
    private final NetconfClientProtocol clientProtocol;
    private final InetSocketAddress address;
    private final Long connectionTimeoutMillis;
    private final NetconfHelloMessageAdditionalHeader additionalHeader;
    private final NetconfClientSessionListener sessionListener;
    private final ReconnectStrategy reconnectStrategy;
    private final AuthenticationHandler authHandler;
    private final SslHandlerFactory sslHandlerFactory;
    private final List<Uri> odlHelloCapabilities;

    NetconfClientConfiguration(NetconfClientProtocol protocol, InetSocketAddress address, Long connectionTimeoutMillis, NetconfHelloMessageAdditionalHeader additionalHeader, NetconfClientSessionListener sessionListener, ReconnectStrategy reconnectStrategy, AuthenticationHandler authHandler, SslHandlerFactory sslHandlerFactory, List<Uri> odlHelloCapabilities) {
        this.address = address;
        this.connectionTimeoutMillis = connectionTimeoutMillis;
        this.additionalHeader = additionalHeader;
        this.sessionListener = sessionListener;
        this.clientProtocol = protocol;
        this.reconnectStrategy = reconnectStrategy;
        this.authHandler = authHandler;
        this.sslHandlerFactory = sslHandlerFactory;
        this.odlHelloCapabilities = odlHelloCapabilities;
        this.validateConfiguration();
    }

    public final InetSocketAddress getAddress() {
        return this.address;
    }

    public final Long getConnectionTimeoutMillis() {
        return this.connectionTimeoutMillis;
    }

    public final Optional<NetconfHelloMessageAdditionalHeader> getAdditionalHeader() {
        return Optional.ofNullable(this.additionalHeader);
    }

    public final NetconfClientSessionListener getSessionListener() {
        return this.sessionListener;
    }

    public final ReconnectStrategy getReconnectStrategy() {
        return this.reconnectStrategy;
    }

    public final AuthenticationHandler getAuthHandler() {
        return this.authHandler;
    }

    public NetconfClientProtocol getProtocol() {
        return this.clientProtocol;
    }

    public SslHandlerFactory getSslHandlerFactory() {
        return this.sslHandlerFactory;
    }

    public List<Uri> getOdlHelloCapabilities() {
        return this.odlHelloCapabilities;
    }

    private void validateConfiguration() {
        Preconditions.checkNotNull((Object)((Object)this.clientProtocol), (Object)" ");
        switch (this.clientProtocol) {
            case TLS: {
                this.validateTlsConfiguration();
                this.validateTcpConfiguration();
                break;
            }
            case SSH: {
                this.validateSshConfiguration();
                this.validateTcpConfiguration();
                break;
            }
            case TCP: {
                this.validateTcpConfiguration();
                break;
            }
            default: {
                LOG.warn("Unexpected protocol: {} in netconf client configuration.", (Object)this.clientProtocol);
            }
        }
    }

    protected void validateTlsConfiguration() {
        Preconditions.checkNotNull((Object)this.sslHandlerFactory, (Object)"sslHandlerFactory");
    }

    protected void validateSshConfiguration() {
        Preconditions.checkNotNull((Object)this.authHandler, (Object)"authHandler");
    }

    protected void validateTcpConfiguration() {
        Preconditions.checkNotNull((Object)this.address, (Object)"address");
        Preconditions.checkNotNull((Object)((Object)this.clientProtocol), (Object)"clientProtocol");
        Preconditions.checkNotNull((Object)this.connectionTimeoutMillis, (Object)"connectionTimeoutMillis");
        Preconditions.checkNotNull((Object)this.sessionListener, (Object)"sessionListener");
        Preconditions.checkNotNull((Object)this.reconnectStrategy, (Object)"reconnectStrategy");
    }

    public final String toString() {
        return this.buildToStringHelper().toString();
    }

    protected MoreObjects.ToStringHelper buildToStringHelper() {
        return MoreObjects.toStringHelper((Object)this).add("address", (Object)this.address).add("connectionTimeoutMillis", (Object)this.connectionTimeoutMillis).add("additionalHeader", (Object)this.additionalHeader).add("sessionListener", (Object)this.sessionListener).add("reconnectStrategy", (Object)this.reconnectStrategy).add("clientProtocol", (Object)this.clientProtocol).add("authHandler", (Object)this.authHandler).add("sslHandlerFactory", (Object)this.sslHandlerFactory);
    }

    public static enum NetconfClientProtocol {
        TCP,
        SSH,
        TLS;

    }
}

