/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.Promise;
import org.opendaylight.netconf.api.NetconfSessionListenerFactory;
import org.opendaylight.netconf.client.NetconfClientSession;
import org.opendaylight.netconf.client.NetconfClientSessionListener;
import org.opendaylight.netconf.client.NetconfClientSessionNegotiatorFactory;
import org.opendaylight.netconf.client.SslHandlerFactory;
import org.opendaylight.netconf.nettyutil.AbstractChannelInitializer;

final class TlsClientChannelInitializer
extends AbstractChannelInitializer<NetconfClientSession> {
    public static final String CHANNEL_ACTIVE_SENTRY = "channelActiveSentry";
    private final SslHandlerFactory sslHandlerFactory;
    private final NetconfClientSessionNegotiatorFactory negotiatorFactory;
    private final NetconfClientSessionListener sessionListener;

    TlsClientChannelInitializer(SslHandlerFactory sslHandlerFactory, NetconfClientSessionNegotiatorFactory negotiatorFactory, NetconfClientSessionListener sessionListener) {
        this.sslHandlerFactory = sslHandlerFactory;
        this.negotiatorFactory = negotiatorFactory;
        this.sessionListener = sessionListener;
    }

    public void initialize(Channel ch, Promise<NetconfClientSession> promise) {
        ch.pipeline().addFirst(CHANNEL_ACTIVE_SENTRY, (ChannelHandler)new ChannelActiveSentry(this.sslHandlerFactory));
        super.initialize(ch, promise);
    }

    protected void initializeSessionNegotiator(Channel ch, Promise<NetconfClientSession> promise) {
        ch.pipeline().addAfter("netconfMessageDecoder", "negotiator", (ChannelHandler)this.negotiatorFactory.getSessionNegotiator((NetconfSessionListenerFactory<NetconfClientSessionListener>)((NetconfSessionListenerFactory)() -> this.sessionListener), ch, promise));
    }

    private static final class ChannelActiveSentry
    extends ChannelInboundHandlerAdapter {
        private final SslHandlerFactory sslHandlerFactory;

        ChannelActiveSentry(SslHandlerFactory sslHandlerFactory) {
            this.sslHandlerFactory = sslHandlerFactory;
        }

        public void channelActive(ChannelHandlerContext ctx) {
            ctx.pipeline().replace((ChannelHandler)this, "sslHandler", (ChannelHandler)this.sslHandlerFactory.createSslHandler()).fireChannelActive();
        }
    }
}

