/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client;

import com.google.common.base.Preconditions;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import java.util.ArrayDeque;
import java.util.Queue;
import javax.annotation.concurrent.GuardedBy;
import org.opendaylight.netconf.api.NetconfMessage;
import org.opendaylight.netconf.api.NetconfTerminationReason;
import org.opendaylight.netconf.client.NetconfClientSession;
import org.opendaylight.netconf.client.NetconfClientSessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleNetconfClientSessionListener
implements NetconfClientSessionListener {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleNetconfClientSessionListener.class);
    @GuardedBy(value="this")
    private final Queue<RequestEntry> requests = new ArrayDeque<RequestEntry>();
    @GuardedBy(value="this")
    private NetconfClientSession clientSession;

    @GuardedBy(value="this")
    private void dispatchRequest() {
        while (!this.requests.isEmpty()) {
            RequestEntry e = this.requests.peek();
            if (e.promise.setUncancellable()) {
                LOG.debug("Sending message {}", (Object)e.request);
                this.clientSession.sendMessage(e.request);
                break;
            }
            LOG.debug("Message {} has been cancelled, skipping it", (Object)e.request);
            this.requests.remove();
        }
    }

    public final synchronized void onSessionUp(NetconfClientSession clientSession) {
        this.clientSession = (NetconfClientSession)((Object)Preconditions.checkNotNull((Object)((Object)clientSession)));
        LOG.debug("Client session {} went up", (Object)clientSession);
        this.dispatchRequest();
    }

    private synchronized void tearDown(Exception cause) {
        RequestEntry e = this.requests.poll();
        if (e != null) {
            e.promise.setFailure((Throwable)cause);
        }
        this.clientSession = null;
    }

    public final void onSessionDown(NetconfClientSession clientSession, Exception exception) {
        LOG.debug("Client Session {} went down unexpectedly", (Object)clientSession, (Object)exception);
        this.tearDown(exception);
    }

    public final void onSessionTerminated(NetconfClientSession clientSession, NetconfTerminationReason netconfTerminationReason) {
        LOG.debug("Client Session {} terminated, reason: {}", (Object)clientSession, (Object)netconfTerminationReason.getErrorMessage());
        this.tearDown(new RuntimeException(netconfTerminationReason.getErrorMessage()));
    }

    public synchronized void onMessage(NetconfClientSession session, NetconfMessage message) {
        LOG.debug("New message arrived: {}", (Object)message);
        RequestEntry e = this.requests.poll();
        if (e != null) {
            e.promise.setSuccess((Object)message);
            this.dispatchRequest();
        } else {
            LOG.info("Ignoring unsolicited message {}", (Object)message);
        }
    }

    public final synchronized Future<NetconfMessage> sendRequest(NetconfMessage message) {
        RequestEntry req = new RequestEntry((Promise<NetconfMessage>)GlobalEventExecutor.INSTANCE.newPromise(), message);
        this.requests.add(req);
        if (this.clientSession != null) {
            this.dispatchRequest();
        }
        return req.promise;
    }

    private static final class RequestEntry {
        private final Promise<NetconfMessage> promise;
        private final NetconfMessage request;

        RequestEntry(Promise<NetconfMessage> future, NetconfMessage request) {
            this.promise = (Promise)Preconditions.checkNotNull(future);
            this.request = (NetconfMessage)Preconditions.checkNotNull((Object)request);
        }
    }
}

