/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client;

import com.google.common.collect.ImmutableSet;
import io.netty.channel.Channel;
import io.netty.util.Timer;
import io.netty.util.concurrent.Promise;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.opendaylight.netconf.api.NetconfClientSessionPreferences;
import org.opendaylight.netconf.api.NetconfMessage;
import org.opendaylight.netconf.api.NetconfSessionListenerFactory;
import org.opendaylight.netconf.api.messages.NetconfHelloMessage;
import org.opendaylight.netconf.api.messages.NetconfHelloMessageAdditionalHeader;
import org.opendaylight.netconf.client.NetconfClientSession;
import org.opendaylight.netconf.client.NetconfClientSessionListener;
import org.opendaylight.netconf.client.NetconfClientSessionNegotiator;
import org.opendaylight.netconf.nettyutil.NetconfSessionNegotiatorFactory;
import org.opendaylight.netconf.nettyutil.handler.exi.EXIParameters;
import org.opendaylight.netconf.nettyutil.handler.exi.NetconfStartExiMessage;
import org.opendaylight.netconf.shaded.exificient.core.CodingMode;
import org.opendaylight.netconf.shaded.exificient.core.FidelityOptions;
import org.opendaylight.netconf.shaded.exificient.core.exceptions.UnsupportedOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfClientSessionNegotiatorFactory
implements NetconfSessionNegotiatorFactory<NetconfClientSession, NetconfClientSessionListener> {
    public static final Set<String> EXI_CLIENT_CAPABILITIES = ImmutableSet.of((Object)"urn:ietf:params:netconf:base:1.0", (Object)"urn:ietf:params:netconf:base:1.1", (Object)"urn:ietf:params:netconf:capability:exi:1.0");
    public static final Set<String> LEGACY_EXI_CLIENT_CAPABILITIES = ImmutableSet.of((Object)"urn:ietf:params:netconf:base:1.0", (Object)"urn:ietf:params:netconf:capability:exi:1.0");
    public static final Set<String> DEFAULT_CLIENT_CAPABILITIES = ImmutableSet.of((Object)"urn:ietf:params:netconf:base:1.0", (Object)"urn:ietf:params:netconf:base:1.1");
    public static final Set<String> LEGACY_FRAMING_CLIENT_CAPABILITIES = ImmutableSet.of((Object)"urn:ietf:params:netconf:base:1.0");
    private static final Logger LOG = LoggerFactory.getLogger(NetconfClientSessionNegotiatorFactory.class);
    private static final String START_EXI_MESSAGE_ID = "default-start-exi";
    private static final EXIParameters DEFAULT_OPTIONS;
    private final Optional<NetconfHelloMessageAdditionalHeader> additionalHeader;
    private final Set<String> clientCapabilities;
    private final long connectionTimeoutMillis;
    private final Timer timer;
    private final EXIParameters options;

    public NetconfClientSessionNegotiatorFactory(Timer timer, Optional<NetconfHelloMessageAdditionalHeader> additionalHeader, long connectionTimeoutMillis) {
        this(timer, additionalHeader, connectionTimeoutMillis, DEFAULT_OPTIONS);
    }

    public NetconfClientSessionNegotiatorFactory(Timer timer, Optional<NetconfHelloMessageAdditionalHeader> additionalHeader, long connectionTimeoutMillis, Set<String> capabilities) {
        this(timer, additionalHeader, connectionTimeoutMillis, DEFAULT_OPTIONS, capabilities);
    }

    public NetconfClientSessionNegotiatorFactory(Timer timer, Optional<NetconfHelloMessageAdditionalHeader> additionalHeader, long connectionTimeoutMillis, EXIParameters exiOptions) {
        this(timer, additionalHeader, connectionTimeoutMillis, exiOptions, EXI_CLIENT_CAPABILITIES);
    }

    public NetconfClientSessionNegotiatorFactory(Timer timer, Optional<NetconfHelloMessageAdditionalHeader> additionalHeader, long connectionTimeoutMillis, EXIParameters exiOptions, Set<String> capabilities) {
        this.timer = Objects.requireNonNull(timer);
        this.additionalHeader = additionalHeader;
        this.connectionTimeoutMillis = connectionTimeoutMillis;
        this.options = exiOptions;
        this.clientCapabilities = capabilities;
    }

    public NetconfClientSessionNegotiator getSessionNegotiator(NetconfSessionListenerFactory<NetconfClientSessionListener> sessionListenerFactory, Channel channel, Promise<NetconfClientSession> promise) {
        NetconfStartExiMessage startExiMessage = NetconfStartExiMessage.create((EXIParameters)this.options, (String)START_EXI_MESSAGE_ID);
        NetconfHelloMessage helloMessage = NetconfHelloMessage.createClientHello(this.clientCapabilities, this.additionalHeader);
        NetconfClientSessionPreferences proposal = new NetconfClientSessionPreferences(helloMessage, (NetconfMessage)startExiMessage);
        return new NetconfClientSessionNegotiator(proposal, promise, channel, this.timer, (NetconfClientSessionListener)sessionListenerFactory.getSessionListener(), this.connectionTimeoutMillis);
    }

    static {
        FidelityOptions fidelity = FidelityOptions.createDefault();
        try {
            fidelity.setFidelity("PRESERVE_DTDS", true);
            fidelity.setFidelity("PRESERVE_LEXICAL_VALUES", true);
            fidelity.setFidelity("PRESERVE_PREFIXES", true);
        }
        catch (UnsupportedOption e) {
            LOG.warn("Failed to set fidelity options, continuing", (Throwable)e);
        }
        DEFAULT_OPTIONS = new EXIParameters(CodingMode.BYTE_PACKED, fidelity);
    }
}

