/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.Timer;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.util.Collection;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import org.opendaylight.netconf.api.NetconfClientSessionPreferences;
import org.opendaylight.netconf.api.NetconfDocumentedException;
import org.opendaylight.netconf.api.NetconfMessage;
import org.opendaylight.netconf.api.NetconfSessionListener;
import org.opendaylight.netconf.api.NetconfSessionPreferences;
import org.opendaylight.netconf.api.messages.NetconfHelloMessage;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.netconf.client.NetconfClientSession;
import org.opendaylight.netconf.client.NetconfClientSessionListener;
import org.opendaylight.netconf.nettyutil.AbstractNetconfSessionNegotiator;
import org.opendaylight.netconf.nettyutil.handler.exi.NetconfStartExiMessage;
import org.opendaylight.netconf.util.messages.NetconfMessageUtil;
import org.opendaylight.netconf.util.xml.XMLNetconfUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NetconfClientSessionNegotiator
extends AbstractNetconfSessionNegotiator<NetconfClientSessionPreferences, NetconfClientSession, NetconfClientSessionListener> {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfClientSessionNegotiator.class);
    private static final XPathExpression SESSION_ID_X_PATH = XMLNetconfUtil.compileXPath((String)"/netconf:hello/netconf:session-id");
    private static final XPathExpression SESSION_ID_X_PATH_NO_NAMESPACE = XMLNetconfUtil.compileXPath((String)"/hello/session-id");
    private static final String EXI_1_0_CAPABILITY_MARKER = "exi:1.0";
    private static final Interner<Set<String>> INTERNER = Interners.newWeakInterner();

    protected NetconfClientSessionNegotiator(NetconfClientSessionPreferences sessionPreferences, Promise<NetconfClientSession> promise, Channel channel, Timer timer, NetconfClientSessionListener sessionListener, long connectionTimeoutMillis) {
        super((NetconfSessionPreferences)sessionPreferences, promise, channel, timer, (NetconfSessionListener)sessionListener, connectionTimeoutMillis);
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
    protected void handleMessage(NetconfHelloMessage netconfMessage) throws NetconfDocumentedException {
        LOG.info("Received hello message from server. Starting negotiation on channel {}. {}", (Object)this.channel, (Object)netconfMessage);
        if (!this.ifNegotiatedAlready()) {
            LOG.debug("Server hello message received, starting negotiation on channel {}", (Object)this.channel);
            try {
                this.startNegotiation();
            }
            catch (Exception e) {
                LOG.warn("Unexpected negotiation failure", (Throwable)e);
                this.negotiationFailed(e);
                return;
            }
        }
        NetconfClientSession session = (NetconfClientSession)this.getSessionForHelloMessage(netconfMessage);
        this.replaceHelloMessageInboundHandler(session);
        NetconfMessage startExiMessage = ((NetconfClientSessionPreferences)this.sessionPreferences).getStartExiMessage();
        if (this.shouldUseExi(netconfMessage) && startExiMessage instanceof NetconfStartExiMessage) {
            LOG.debug("Netconf session {} should use exi.", (Object)session);
            this.tryToInitiateExi(session, (NetconfStartExiMessage)startExiMessage);
        } else {
            LOG.debug("Netconf session {} isn't capable of using exi.", (Object)session);
            this.negotiationSuccessful(session);
        }
    }

    void tryToInitiateExi(NetconfClientSession session, final NetconfStartExiMessage startExiMessage) {
        this.channel.pipeline().addAfter("netconfMessageDecoder", "exiConfirmedHandler", (ChannelHandler)new ExiConfirmationInboundHandler(session, startExiMessage));
        session.sendMessage((NetconfMessage)startExiMessage).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture channelFuture) {
                if (!channelFuture.isSuccess()) {
                    LOG.warn("Failed to send start-exi message {} on session {}", new Object[]{startExiMessage, this, channelFuture.cause()});
                    NetconfClientSessionNegotiator.this.channel.pipeline().remove("exiConfirmedHandler");
                } else {
                    LOG.trace("Start-exi message {} sent to socket on session {}", (Object)startExiMessage, (Object)this);
                }
            }
        });
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
    private boolean shouldUseExi(NetconfHelloMessage helloMsg) {
        return NetconfClientSessionNegotiator.containsExi10Capability(helloMsg.getDocument()) && NetconfClientSessionNegotiator.containsExi10Capability(((NetconfClientSessionPreferences)this.sessionPreferences).getHelloMessage().getDocument());
    }

    private static boolean containsExi10Capability(Document doc) {
        NodeList nList = doc.getElementsByTagName("capability");
        for (int i = 0; i < nList.getLength(); ++i) {
            if (!nList.item(i).getTextContent().contains(EXI_1_0_CAPABILITY_MARKER)) continue;
            return true;
        }
        return false;
    }

    private static long extractSessionId(Document doc) {
        String textContent = NetconfClientSessionNegotiator.getSessionIdWithXPath(doc, SESSION_ID_X_PATH);
        if (Strings.isNullOrEmpty((String)textContent) && Strings.isNullOrEmpty((String)(textContent = NetconfClientSessionNegotiator.getSessionIdWithXPath(doc, SESSION_ID_X_PATH_NO_NAMESPACE)))) {
            throw new IllegalStateException("Session id not received from server, hello message: " + XmlUtil.toString((Document)doc));
        }
        return Long.parseLong(textContent);
    }

    private static String getSessionIdWithXPath(Document doc, XPathExpression sessionIdXPath) {
        Node sessionIdNode = (Node)XmlUtil.evaluateXPath((XPathExpression)sessionIdXPath, (Object)doc, (QName)XPathConstants.NODE);
        return sessionIdNode != null ? sessionIdNode.getTextContent() : null;
    }

    protected NetconfClientSession getSession(NetconfClientSessionListener sessionListener, Channel channel, NetconfHelloMessage message) {
        long sessionId = NetconfClientSessionNegotiator.extractSessionId(message.getDocument());
        Object capabilities = ImmutableSet.copyOf((Collection)NetconfMessageUtil.extractCapabilitiesFromHello((Document)message.getDocument()));
        capabilities = (Set)INTERNER.intern(capabilities);
        return new NetconfClientSession(sessionListener, channel, sessionId, (Collection<String>)capabilities);
    }

    private final class ExiConfirmationInboundHandler
    extends ChannelInboundHandlerAdapter {
        private static final String EXI_CONFIRMED_HANDLER = "exiConfirmedHandler";
        private final NetconfClientSession session;
        private final NetconfStartExiMessage startExiMessage;

        ExiConfirmationInboundHandler(NetconfClientSession session, NetconfStartExiMessage startExiMessage) {
            this.session = session;
            this.startExiMessage = startExiMessage;
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            ctx.pipeline().remove(EXI_CONFIRMED_HANDLER);
            NetconfMessage netconfMessage = (NetconfMessage)msg;
            if (NetconfMessageUtil.isOKMessage((NetconfMessage)netconfMessage)) {
                LOG.trace("Positive response on start-exi call received on session {}", (Object)this.session);
                try {
                    this.session.startExiCommunication((NetconfMessage)this.startExiMessage);
                }
                catch (RuntimeException e) {
                    LOG.warn("Unable to start exi communication, Communication will continue without exi on session {}", (Object)this.session, (Object)e);
                }
            } else if (NetconfMessageUtil.isErrorMessage((NetconfMessage)netconfMessage)) {
                LOG.warn("Error response to start-exi message {}, Communication will continue without exi on session {}", (Object)netconfMessage, (Object)this.session);
            } else {
                LOG.warn("Unexpected response to start-exi message, should be ok, was {}, Communication will continue without exi and response message will be thrown away on session {}", (Object)netconfMessage, (Object)this.session);
            }
            NetconfClientSessionNegotiator.this.negotiationSuccessful(this.session);
        }
    }
}

