/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.util.messages;

import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.NetconfDocumentedException;
import org.opendaylight.netconf.api.NetconfMessage;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public final class NetconfMessageUtil {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfMessageUtil.class);

    private NetconfMessageUtil() {
    }

    public static boolean isOKMessage(NetconfMessage message) throws NetconfDocumentedException {
        return NetconfMessageUtil.isOKMessage(message.getDocument());
    }

    public static boolean isOKMessage(Document document) throws NetconfDocumentedException {
        return NetconfMessageUtil.isOKMessage(XmlElement.fromDomDocument((Document)document));
    }

    public static boolean isOKMessage(XmlElement xmlElement) throws NetconfDocumentedException {
        if (xmlElement.getChildElements().size() != 1) {
            return false;
        }
        try {
            return xmlElement.getOnlyChildElement().getName().equals("ok");
        }
        catch (DocumentedException e) {
            throw new NetconfDocumentedException(e);
        }
    }

    public static boolean isErrorMessage(NetconfMessage message) {
        return NetconfMessageUtil.isErrorMessage(message.getDocument());
    }

    public static boolean isErrorMessage(Document document) {
        return NetconfMessageUtil.isErrorMessage(XmlElement.fromDomDocument((Document)document));
    }

    public static boolean isErrorMessage(XmlElement xmlElement) {
        return xmlElement.getChildElements("rpc-error").size() >= 1;
    }

    public static Collection<String> extractCapabilitiesFromHello(Document doc) {
        XmlElement responseElement = XmlElement.fromDomDocument((Document)doc);
        Optional capabilitiesElement = responseElement.getOnlyChildElementWithSameNamespaceOptionally("capabilities");
        if (!capabilitiesElement.isPresent()) {
            capabilitiesElement = responseElement.getOnlyChildElementOptionally("capabilities");
        }
        List caps = ((XmlElement)capabilitiesElement.get()).getChildElements("capability");
        return Collections2.transform((Collection)caps, input -> {
            try {
                return input.getTextContent().trim();
            }
            catch (DocumentedException e) {
                LOG.trace("Error fetching input text content", (Throwable)e);
                return null;
            }
        });
    }
}

