/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.util.mapping;

import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.mapping.api.HandlingPriority;
import org.opendaylight.netconf.mapping.api.NetconfOperationChainedExecution;
import org.opendaylight.netconf.util.mapping.AbstractNetconfOperation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractLastNetconfOperation
extends AbstractNetconfOperation {
    protected AbstractLastNetconfOperation(String netconfSessionIdForReporting) {
        super(netconfSessionIdForReporting);
    }

    @Override
    protected Element handle(Document document, XmlElement operationElement, NetconfOperationChainedExecution subsequentOperation) throws DocumentedException {
        if (!subsequentOperation.isExecutionTermination()) {
            throw new DocumentedException(String.format("No netconf operation expected to be subsequent to %s, but is %s", this, subsequentOperation), DocumentedException.ErrorType.APPLICATION, DocumentedException.ErrorTag.MALFORMED_MESSAGE, DocumentedException.ErrorSeverity.ERROR);
        }
        return this.handleWithNoSubsequentOperations(document, operationElement);
    }

    @Override
    protected HandlingPriority getHandlingPriority() {
        return HandlingPriority.HANDLE_WITH_DEFAULT_PRIORITY;
    }

    protected abstract Element handleWithNoSubsequentOperations(Document var1, XmlElement var2) throws DocumentedException;
}

