/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.util;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Iterator;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.dom.DOMResult;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.netconf.util.StreamingContext;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.XMLStreamNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public final class NetconfUtil {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfUtil.class);
    public static final XMLOutputFactory XML_FACTORY = XMLOutputFactory.newFactory();

    private NetconfUtil() {
    }

    public static Document checkIsMessageOk(Document response) throws DocumentedException {
        XmlElement element = XmlElement.fromDomDocument((Document)response);
        Preconditions.checkState((boolean)element.getName().equals("rpc-reply"));
        element = element.getOnlyChildElement();
        if (element.getName().equals("ok")) {
            return response;
        }
        LOG.warn("Can not load last configuration. Operation failed.");
        throw new IllegalStateException("Can not load last configuration. Operation failed: " + XmlUtil.toString((Document)response));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeNormalizedNode(NormalizedNode<?, ?> normalized, DOMResult result, SchemaPath schemaPath, SchemaContext context) throws IOException, XMLStreamException {
        XMLStreamWriter writer = XML_FACTORY.createXMLStreamWriter(result);
        try (NormalizedNodeStreamWriter normalizedNodeStreamWriter = XMLStreamNormalizedNodeStreamWriter.create((XMLStreamWriter)writer, (SchemaContext)context, (SchemaPath)schemaPath);
             NormalizedNodeWriter normalizedNodeWriter = NormalizedNodeWriter.forStreamWriter((NormalizedNodeStreamWriter)normalizedNodeStreamWriter);){
            normalizedNodeWriter.write(normalized);
            normalizedNodeWriter.flush();
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception e) {
                LOG.warn("Unable to close resource properly", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFilter(YangInstanceIdentifier query, DOMResult result, SchemaPath schemaPath, SchemaContext context) throws IOException, XMLStreamException {
        if (query.isEmpty()) {
            return;
        }
        try (XMLStreamWriter xmlWriter = XML_FACTORY.createXMLStreamWriter(result);
             NormalizedNodeStreamWriter writer = XMLStreamNormalizedNodeStreamWriter.create((XMLStreamWriter)xmlWriter, (SchemaContext)context, (SchemaPath)schemaPath);){
            Iterator<YangInstanceIdentifier.PathArgument> it = query.getPathArguments().iterator();
            YangInstanceIdentifier.PathArgument first = (YangInstanceIdentifier.PathArgument)it.next();
            StreamingContext.fromSchemaAndQNameChecked((DataNodeContainer)context, first.getNodeType()).streamToWriter(writer, first, it);
        }
    }

    static {
        XML_FACTORY.setProperty("javax.xml.stream.isRepairingNamespaces", false);
    }
}

