/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netconf.callhome.server.rev161109.credentials;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netconf.callhome.server.rev161109.credentials.Credentials;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class CredentialsBuilder
implements Builder<Credentials> {
    private List<String> _passwords;
    private String _username;
    Map<Class<? extends Augmentation<Credentials>>, Augmentation<Credentials>> augmentation = Collections.emptyMap();

    public CredentialsBuilder() {
    }

    public CredentialsBuilder(Credentials base) {
        Map aug;
        this._passwords = base.getPasswords();
        this._username = base.getUsername();
        if (base instanceof CredentialsImpl) {
            CredentialsImpl impl = (CredentialsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Credentials>>, Augmentation<Credentials>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Credentials>>, Augmentation<Credentials>>(aug);
        }
    }

    public List<String> getPasswords() {
        return this._passwords;
    }

    public String getUsername() {
        return this._username;
    }

    public <E$$ extends Augmentation<Credentials>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public CredentialsBuilder setPasswords(List<String> values) {
        this._passwords = values;
        return this;
    }

    private static void check_usernameLength(String value) {
        int length = value.length();
        if (length >= 1) {
            return;
        }
        CodeHelpers.throwInvalidLength((String)"[[1..2147483647]]", (Object)value);
    }

    public CredentialsBuilder setUsername(String value) {
        if (value != null) {
            CredentialsBuilder.check_usernameLength(value);
        }
        this._username = value;
        return this;
    }

    public CredentialsBuilder addAugmentation(Class<? extends Augmentation<Credentials>> augmentationType, Augmentation<Credentials> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Credentials>>, Augmentation<Credentials>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public CredentialsBuilder removeAugmentation(Class<? extends Augmentation<Credentials>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Credentials build() {
        return new CredentialsImpl(this);
    }

    private static final class CredentialsImpl
    implements Credentials {
        private final List<String> _passwords;
        private final String _username;
        private Map<Class<? extends Augmentation<Credentials>>, Augmentation<Credentials>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        CredentialsImpl(CredentialsBuilder base) {
            this._passwords = base.getPasswords();
            this._username = base.getUsername();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Credentials> getImplementedInterface() {
            return Credentials.class;
        }

        @Override
        public List<String> getPasswords() {
            return this._passwords;
        }

        @Override
        public String getUsername() {
            return this._username;
        }

        public <E$$ extends Augmentation<Credentials>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._passwords);
            result = 31 * result + Objects.hashCode(this._username);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Credentials.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Credentials other = (Credentials)obj;
            if (!Objects.equals(this._passwords, other.getPasswords())) {
                return false;
            }
            if (!Objects.equals(this._username, other.getUsername())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                CredentialsImpl otherImpl = (CredentialsImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Credentials>>, Augmentation<Credentials>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Credentials");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_passwords", this._passwords);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_username", (Object)this._username);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

