/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker.schema;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.Optional;
import javax.annotation.concurrent.GuardedBy;
import org.opendaylight.mdsal.dom.spi.AbstractDOMSchemaService;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.util.ListenerRegistry;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContextListener;
import org.opendaylight.yangtools.yang.model.parser.api.YangSyntaxErrorException;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceException;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang.parser.repo.YangTextSchemaContextResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanningSchemaServiceProvider
extends AbstractDOMSchemaService.WithYangTextSources
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(ScanningSchemaServiceProvider.class);
    private final YangTextSchemaContextResolver contextResolver = YangTextSchemaContextResolver.create((String)"global-bundle");
    @GuardedBy(value="lock")
    private final ListenerRegistry<SchemaContextListener> listeners = ListenerRegistry.create();
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryToUpdateSchemaContext() {
        Object object = this.lock;
        synchronized (object) {
            Optional schema = this.contextResolver.getSchemaContext();
            if (schema.isPresent()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Got new SchemaContext: # of modules {}", (Object)((SchemaContext)schema.get()).getModules().size());
                }
                this.notifyListeners((SchemaContext)schema.get());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void notifyListeners(SchemaContext schemaContext) {
        Object object = this.lock;
        synchronized (object) {
            for (ListenerRegistration registration : this.listeners) {
                try {
                    ((SchemaContextListener)registration.getInstance()).onGlobalContextUpdated(schemaContext);
                }
                catch (Exception e) {
                    LOG.error("Exception occured during invoking listener", (Throwable)e);
                }
            }
        }
    }

    public List<Registration> registerAvailableYangs(List<URL> yangs) {
        ArrayList<Registration> sourceRegistrator = new ArrayList<Registration>();
        for (URL url : yangs) {
            try {
                sourceRegistrator.add((Registration)this.contextResolver.registerSource(url));
            }
            catch (IOException | YangSyntaxErrorException | SchemaSourceException e) {
                LOG.warn("Failed to register {}, ignoring it", (Object)url, (Object)e);
            }
        }
        return sourceRegistrator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(SchemaContextListener schemaContextListener) {
        Object object = this.lock;
        synchronized (object) {
            for (ListenerRegistration listenerRegistration : this.listeners.getListeners()) {
                if (!((SchemaContextListener)listenerRegistration.getInstance()).equals(schemaContextListener)) continue;
                listenerRegistration.close();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasListeners() {
        Object object = this.lock;
        synchronized (object) {
            return !Iterables.isEmpty((Iterable)this.listeners.getListeners());
        }
    }

    public SchemaContext getGlobalContext() {
        return this.contextResolver.getSchemaContext().orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenerRegistration<SchemaContextListener> registerSchemaContextListener(SchemaContextListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.contextResolver.getSchemaContext().ifPresent(arg_0 -> ((SchemaContextListener)listener).onGlobalContextUpdated(arg_0));
            return this.listeners.register((EventListener)listener);
        }
    }

    public ListenableFuture<? extends YangTextSchemaSource> getSource(SourceIdentifier sourceIdentifier) {
        return this.contextResolver.getSource(sourceIdentifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.listeners.forEach(ListenerRegistration::close);
        }
    }
}

