/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker.pingpong;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.concurrent.GuardedBy;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMTransactionChain;
import org.opendaylight.mdsal.dom.api.DOMTransactionChainListener;
import org.opendaylight.mdsal.dom.broker.pingpong.PingPongTransaction;
import org.opendaylight.mdsal.dom.spi.ForwardingDOMDataReadWriteTransaction;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PingPongTransactionChain
implements DOMTransactionChain {
    private static final Logger LOG = LoggerFactory.getLogger(PingPongTransactionChain.class);
    private final DOMTransactionChainListener listener;
    private final DOMTransactionChain delegate;
    @GuardedBy(value="this")
    private boolean failed;
    @GuardedBy(value="this")
    private PingPongTransaction shutdownTx;
    @GuardedBy(value="this")
    private Map.Entry<PingPongTransaction, Throwable> deadTx;
    private static final AtomicReferenceFieldUpdater<PingPongTransactionChain, PingPongTransaction> READY_UPDATER = AtomicReferenceFieldUpdater.newUpdater(PingPongTransactionChain.class, PingPongTransaction.class, "readyTx");
    private volatile PingPongTransaction readyTx;
    private static final AtomicReferenceFieldUpdater<PingPongTransactionChain, PingPongTransaction> LOCKED_UPDATER = AtomicReferenceFieldUpdater.newUpdater(PingPongTransactionChain.class, PingPongTransaction.class, "lockedTx");
    private volatile PingPongTransaction lockedTx;
    private static final AtomicReferenceFieldUpdater<PingPongTransactionChain, PingPongTransaction> INFLIGHT_UPDATER = AtomicReferenceFieldUpdater.newUpdater(PingPongTransactionChain.class, PingPongTransaction.class, "inflightTx");
    private volatile PingPongTransaction inflightTx;

    PingPongTransactionChain(DOMDataBroker broker, DOMTransactionChainListener listener) {
        this.listener = Objects.requireNonNull(listener);
        this.delegate = broker.createTransactionChain(new DOMTransactionChainListener(){

            public void onTransactionChainFailed(DOMTransactionChain chain, DOMDataTreeTransaction transaction, Throwable cause) {
                LOG.debug("Transaction chain {} reported failure in {}", new Object[]{chain, transaction, cause});
                PingPongTransactionChain.this.delegateFailed(chain, cause);
            }

            public void onTransactionChainSuccessful(DOMTransactionChain chain) {
                PingPongTransactionChain.this.delegateSuccessful(chain);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delegateSuccessful(DOMTransactionChain chain) {
        Map.Entry<PingPongTransaction, Throwable> canceled;
        PingPongTransactionChain pingPongTransactionChain = this;
        synchronized (pingPongTransactionChain) {
            canceled = this.deadTx;
        }
        if (canceled == null) {
            this.listener.onTransactionChainSuccessful((DOMTransactionChain)this);
            return;
        }
        PingPongTransaction tx = canceled.getKey();
        Throwable cause = canceled.getValue();
        LOG.debug("Transaction chain {} successful, failing cancelled transaction {}", new Object[]{chain, tx, cause});
        this.listener.onTransactionChainFailed((DOMTransactionChain)this, (DOMDataTreeTransaction)tx.getFrontendTransaction(), cause);
        tx.onFailure(cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delegateFailed(DOMTransactionChain chain, Throwable cause) {
        DOMDataTreeReadWriteTransaction frontend;
        PingPongTransaction tx = this.inflightTx;
        if (tx == null) {
            LOG.warn("Transaction chain {} failed with no pending transactions", (Object)chain);
            frontend = null;
        } else {
            frontend = tx.getFrontendTransaction();
        }
        this.listener.onTransactionChainFailed((DOMTransactionChain)this, (DOMDataTreeTransaction)frontend, cause);
        PingPongTransactionChain pingPongTransactionChain = this;
        synchronized (pingPongTransactionChain) {
            this.failed = true;
            if (this.lockedTx == null) {
                this.processIfReady();
            }
        }
    }

    private synchronized @NonNull PingPongTransaction slowAllocateTransaction() {
        Preconditions.checkState((this.shutdownTx == null ? 1 : 0) != 0, (String)"Transaction chain %s has been shut down", (Object)this);
        if (this.deadTx != null) {
            throw new IllegalStateException(String.format("Transaction chain %s has failed due to transaction %s being canceled", this, this.deadTx.getKey()), this.deadTx.getValue());
        }
        DOMDataTreeReadWriteTransaction delegateTx = this.delegate.newReadWriteTransaction();
        PingPongTransaction newTx = new PingPongTransaction(delegateTx);
        if (!LOCKED_UPDATER.compareAndSet(this, null, newTx)) {
            delegateTx.cancel();
            throw new IllegalStateException(String.format("New transaction %s raced with transaction %s", newTx, this.lockedTx));
        }
        return newTx;
    }

    private @NonNull PingPongTransaction allocateTransaction() {
        PingPongTransaction oldTx = READY_UPDATER.getAndSet(this, null);
        if (oldTx == null) {
            return this.slowAllocateTransaction();
        }
        if (!LOCKED_UPDATER.compareAndSet(this, null, oldTx)) {
            oldTx.getTransaction().cancel();
            throw new IllegalStateException(String.format("Reusable transaction %s raced with transaction %s", oldTx, this.lockedTx));
        }
        return oldTx;
    }

    @GuardedBy(value="this")
    private void processIfReady() {
        PingPongTransaction tx;
        if (this.inflightTx == null && (tx = (PingPongTransaction)READY_UPDATER.getAndSet(this, null)) != null) {
            this.processTransaction(tx);
        }
    }

    @GuardedBy(value="this")
    private void processTransaction(final @NonNull PingPongTransaction tx) {
        if (this.failed) {
            LOG.debug("Cancelling transaction {}", (Object)tx);
            tx.getTransaction().cancel();
            return;
        }
        LOG.debug("Submitting transaction {}", (Object)tx);
        if (!INFLIGHT_UPDATER.compareAndSet(this, null, tx)) {
            LOG.warn("Submitting transaction {} while {} is still running", (Object)tx, (Object)this.inflightTx);
        }
        tx.getTransaction().commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                PingPongTransactionChain.this.transactionSuccessful(tx, result);
            }

            public void onFailure(Throwable throwable) {
                PingPongTransactionChain.this.transactionFailed(tx, throwable);
            }
        }, MoreExecutors.directExecutor());
    }

    private synchronized void processNextTransaction(PingPongTransaction tx) {
        boolean success = INFLIGHT_UPDATER.compareAndSet(this, tx, null);
        Preconditions.checkState((boolean)success, (String)"Completed transaction %s while %s was submitted", (Object)tx, (Object)this.inflightTx);
        PingPongTransaction nextTx = READY_UPDATER.getAndSet(this, null);
        if (nextTx != null) {
            this.processTransaction(nextTx);
        } else if (this.shutdownTx != null) {
            this.processTransaction(this.shutdownTx);
            this.delegate.close();
            this.shutdownTx = null;
        }
    }

    void transactionSuccessful(PingPongTransaction tx, CommitInfo result) {
        LOG.debug("Transaction {} completed successfully", (Object)tx);
        tx.onSuccess(result);
        this.processNextTransaction(tx);
    }

    void transactionFailed(PingPongTransaction tx, Throwable throwable) {
        LOG.debug("Transaction {} failed", (Object)tx, (Object)throwable);
        tx.onFailure(throwable);
        this.processNextTransaction(tx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readyTransaction(@NonNull PingPongTransaction tx) {
        boolean lockedMatch = LOCKED_UPDATER.compareAndSet(this, tx, null);
        Preconditions.checkState((boolean)lockedMatch, (String)"Attempted to submit transaction %s while we have %s", (Object)tx, (Object)this.lockedTx);
        LOG.debug("Transaction {} unlocked", (Object)tx);
        boolean success = READY_UPDATER.compareAndSet(this, null, tx);
        Preconditions.checkState((boolean)success, (String)"Transaction %s collided on ready state", (Object)tx, (Object)this.readyTx);
        LOG.debug("Transaction {} readied", (Object)tx);
        if (this.inflightTx == null) {
            PingPongTransactionChain pingPongTransactionChain = this;
            synchronized (pingPongTransactionChain) {
                this.processIfReady();
            }
        }
    }

    synchronized void cancelTransaction(PingPongTransaction tx, DOMDataTreeReadWriteTransaction frontendTx) {
        boolean lockedMatch = LOCKED_UPDATER.compareAndSet(this, tx, null);
        Verify.verify((boolean)lockedMatch, (String)"Cancelling transaction %s collided with locked transaction %s", (Object)tx, (Object)this.lockedTx);
        boolean backendCancelled = tx.getTransaction().cancel();
        if (this.failed) {
            return;
        }
        if (!backendCancelled) {
            LOG.warn("Backend transaction cannot be cancelled during cancellation of {}, attempting to continue", (Object)tx);
        }
        if (frontendTx.equals(tx.getFrontendTransaction())) {
            LOG.debug("Cancelled transaction {} was head of the batch, resuming processing", (Object)tx);
            return;
        }
        this.deadTx = new AbstractMap.SimpleImmutableEntry<PingPongTransaction, Throwable>(tx, new CancellationException("Transaction " + frontendTx + " canceled").fillInStackTrace());
        this.delegate.close();
    }

    public synchronized void close() {
        PingPongTransaction notLocked = this.lockedTx;
        Preconditions.checkState((notLocked == null ? 1 : 0) != 0, (String)"Attempted to close chain with outstanding transaction %s", (Object)notLocked);
        Preconditions.checkState((this.shutdownTx == null ? 1 : 0) != 0, (Object)"Attempted to close an already-closed chain");
        if (this.deadTx != null) {
            LOG.debug("Delegate {} is already closed due to failure {}", (Object)this.delegate, this.deadTx);
            return;
        }
        PingPongTransaction tx = READY_UPDATER.getAndSet(this, null);
        if (tx != null) {
            if (this.inflightTx == null) {
                this.processTransaction(tx);
                this.delegate.close();
            } else {
                this.shutdownTx = tx;
            }
        } else {
            this.delegate.close();
        }
    }

    public DOMDataTreeReadTransaction newReadOnlyTransaction() {
        final PingPongTransaction tx = this.allocateTransaction();
        return new DOMDataTreeReadTransaction(){

            public FluentFuture<Optional<NormalizedNode<?, ?>>> read(LogicalDatastoreType store, YangInstanceIdentifier path) {
                return tx.getTransaction().read(store, path);
            }

            public FluentFuture<Boolean> exists(LogicalDatastoreType store, YangInstanceIdentifier path) {
                return tx.getTransaction().exists(store, path);
            }

            public Object getIdentifier() {
                return tx.getTransaction().getIdentifier();
            }

            public void close() {
                PingPongTransactionChain.this.readyTransaction(tx);
            }
        };
    }

    public DOMDataTreeReadWriteTransaction newReadWriteTransaction() {
        final PingPongTransaction tx = this.allocateTransaction();
        ForwardingDOMDataReadWriteTransaction ret = new ForwardingDOMDataReadWriteTransaction(){
            private boolean isOpen = true;

            protected DOMDataTreeReadWriteTransaction delegate() {
                return tx.getTransaction();
            }

            public FluentFuture<? extends CommitInfo> commit() {
                PingPongTransactionChain.this.readyTransaction(tx);
                this.isOpen = false;
                return tx.getCommitFuture().transform(ignored -> CommitInfo.empty(), MoreExecutors.directExecutor());
            }

            public boolean cancel() {
                if (this.isOpen) {
                    PingPongTransactionChain.this.cancelTransaction(tx, (DOMDataTreeReadWriteTransaction)this);
                    this.isOpen = false;
                    return true;
                }
                return false;
            }
        };
        tx.recordFrontendTransaction((DOMDataTreeReadWriteTransaction)ret);
        return ret;
    }

    public DOMDataTreeWriteTransaction newWriteOnlyTransaction() {
        return this.newReadWriteTransaction();
    }
}

