/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker;

import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.broker.ShardedDOMTransactionChainAdapter;
import org.opendaylight.yangtools.util.concurrent.FluentFutures;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

public class TransactionChainWriteTransaction
implements DOMDataTreeWriteTransaction {
    private final DOMDataTreeWriteTransaction delegateTx;
    private final Object identifier;
    private final ShardedDOMTransactionChainAdapter txChain;

    public TransactionChainWriteTransaction(Object identifier, DOMDataTreeWriteTransaction delegateTx, ShardedDOMTransactionChainAdapter txChain) {
        this.delegateTx = Objects.requireNonNull(delegateTx);
        this.identifier = Objects.requireNonNull(identifier);
        this.txChain = Objects.requireNonNull(txChain);
    }

    public void put(LogicalDatastoreType store, YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        this.delegateTx.put(store, path, data);
    }

    public void merge(LogicalDatastoreType store, YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        this.delegateTx.merge(store, path, data);
    }

    public boolean cancel() {
        this.txChain.closeWriteTransaction((FluentFuture<? extends CommitInfo>)FluentFutures.immediateNullFluentFuture());
        return this.delegateTx.cancel();
    }

    public void delete(LogicalDatastoreType store, YangInstanceIdentifier path) {
        this.delegateTx.delete(store, path);
    }

    public @NonNull FluentFuture<? extends @NonNull CommitInfo> commit() {
        FluentFuture writeResultFuture = this.delegateTx.commit();
        writeResultFuture.addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
            }

            public void onFailure(Throwable throwable) {
                TransactionChainWriteTransaction.this.txChain.transactionFailed((DOMDataTreeTransaction)TransactionChainWriteTransaction.this, throwable);
            }
        }, MoreExecutors.directExecutor());
        this.txChain.closeWriteTransaction((FluentFuture<? extends CommitInfo>)writeResultFuture);
        return writeResultFuture;
    }

    public Object getIdentifier() {
        return this.identifier;
    }
}

