/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker;

import com.google.common.base.Preconditions;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCursorAwareTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMDataTreeListener;
import org.opendaylight.mdsal.dom.api.DOMDataTreeLoopException;
import org.opendaylight.mdsal.dom.api.DOMDataTreeProducer;
import org.opendaylight.mdsal.dom.api.DOMDataTreeProducerException;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeService;
import org.opendaylight.mdsal.dom.api.DOMDataTreeServiceExtension;
import org.opendaylight.mdsal.dom.api.DOMDataTreeTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMTransactionChain;
import org.opendaylight.mdsal.dom.api.DOMTransactionChainListener;
import org.opendaylight.mdsal.dom.broker.ShardedDOMReadTransactionAdapter;
import org.opendaylight.mdsal.dom.broker.ShardedDOMReadWriteTransactionAdapter;
import org.opendaylight.mdsal.dom.broker.ShardedDOMWriteTransactionAdapter;
import org.opendaylight.mdsal.dom.broker.TransactionChainReadTransaction;
import org.opendaylight.mdsal.dom.broker.TransactionChainReadWriteTransaction;
import org.opendaylight.mdsal.dom.broker.TransactionChainWriteTransaction;
import org.opendaylight.yangtools.concepts.ListenerRegistration;

public class ShardedDOMTransactionChainAdapter
implements DOMTransactionChain {
    private final DOMDataTreeService dataTreeService;
    private final Object txChainIdentifier;
    private final AtomicLong txNum = new AtomicLong();
    private final DOMTransactionChainListener txChainListener;
    private final CachedDataTreeService cachedDataTreeService;
    private TransactionChainWriteTransaction writeTx;
    private TransactionChainReadTransaction readTx;
    private FluentFuture<? extends CommitInfo> writeTxCommitFuture;
    private boolean finished = false;

    public ShardedDOMTransactionChainAdapter(Object txChainIdentifier, DOMDataTreeService dataTreeService, DOMTransactionChainListener txChainListener) {
        this.dataTreeService = Objects.requireNonNull(dataTreeService);
        this.txChainIdentifier = Objects.requireNonNull(txChainIdentifier);
        this.txChainListener = txChainListener;
        this.cachedDataTreeService = new CachedDataTreeService(dataTreeService);
    }

    public DOMDataTreeReadTransaction newReadOnlyTransaction() {
        this.checkRunning();
        this.checkReadTxClosed();
        this.checkWriteTxClosed();
        this.readTx = new TransactionChainReadTransaction(this.newTransactionIdentifier(), new ShardedDOMReadTransactionAdapter(this.newTransactionIdentifier(), this.dataTreeService), this.writeTxCommitFuture, this);
        return this.readTx;
    }

    public DOMDataTreeWriteTransaction newWriteOnlyTransaction() {
        this.checkRunning();
        this.checkWriteTxClosed();
        this.checkReadTxClosed();
        this.writeTx = new TransactionChainWriteTransaction(this.newTransactionIdentifier(), new ShardedDOMWriteTransactionAdapter(this.newTransactionIdentifier(), this.cachedDataTreeService), this);
        return this.writeTx;
    }

    public DOMDataTreeReadWriteTransaction newReadWriteTransaction() {
        this.checkRunning();
        this.checkWriteTxClosed();
        this.checkReadTxClosed();
        ShardedDOMReadWriteTransactionAdapter adapter = new ShardedDOMReadWriteTransactionAdapter(this.newTransactionIdentifier(), this.cachedDataTreeService);
        TransactionChainReadWriteTransaction readWriteTx = new TransactionChainReadWriteTransaction(this.newTransactionIdentifier(), adapter, adapter.getReadAdapter(), this.writeTxCommitFuture, this);
        this.writeTx = readWriteTx;
        return readWriteTx;
    }

    public void close() {
        if (this.finished) {
            return;
        }
        this.checkReadTxClosed();
        this.checkWriteTxClosed();
        this.writeTxCommitFuture.addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                ShardedDOMTransactionChainAdapter.this.txChainListener.onTransactionChainSuccessful((DOMTransactionChain)ShardedDOMTransactionChainAdapter.this);
            }

            public void onFailure(Throwable throwable) {
            }
        }, MoreExecutors.directExecutor());
        this.cachedDataTreeService.closeProducers();
        this.finished = true;
    }

    public void closeReadTransaction() {
        this.readTx = null;
    }

    public void closeWriteTransaction(FluentFuture<? extends CommitInfo> commitFuture) {
        this.writeTxCommitFuture = commitFuture;
        this.writeTx = null;
    }

    private Object newTransactionIdentifier() {
        return "DOM-CHAIN-" + this.txChainIdentifier + "-" + this.txNum.getAndIncrement();
    }

    private void checkWriteTxClosed() {
        Preconditions.checkState((this.writeTx == null ? 1 : 0) != 0);
    }

    private void checkReadTxClosed() {
        Preconditions.checkState((this.readTx == null ? 1 : 0) != 0);
    }

    private void checkRunning() {
        Preconditions.checkState((!this.finished ? 1 : 0) != 0);
    }

    public void transactionFailed(DOMDataTreeTransaction tx, Throwable cause) {
        this.txChainListener.onTransactionChainFailed((DOMTransactionChain)this, tx, cause);
        if (this.writeTx != null) {
            this.writeTx.cancel();
        }
        if (this.readTx != null) {
            this.readTx.close();
        }
        this.cachedDataTreeService.closeProducers();
        this.finished = true;
    }

    private static final class NoopCloseDataProducer
    implements DOMDataTreeProducer {
        private final DOMDataTreeProducer delegateTreeProducer;

        NoopCloseDataProducer(DOMDataTreeProducer delegateTreeProducer) {
            this.delegateTreeProducer = delegateTreeProducer;
        }

        public DOMDataTreeCursorAwareTransaction createTransaction(boolean isolated) {
            return this.delegateTreeProducer.createTransaction(isolated);
        }

        public DOMDataTreeProducer createProducer(Collection<DOMDataTreeIdentifier> subtrees) {
            return this.delegateTreeProducer.createProducer(subtrees);
        }

        public void close() {
        }

        public void closeDelegate() {
            try {
                this.delegateTreeProducer.close();
            }
            catch (DOMDataTreeProducerException e) {
                throw new IllegalStateException("Trying to close DOMDataTreeProducer with open transaction", e);
            }
        }
    }

    private static class CachedDataTreeService
    implements DOMDataTreeService {
        private final DOMDataTreeService delegateTreeService;
        private final Map<LogicalDatastoreType, NoopCloseDataProducer> producersMap = new EnumMap<LogicalDatastoreType, NoopCloseDataProducer>(LogicalDatastoreType.class);

        CachedDataTreeService(DOMDataTreeService delegateTreeService) {
            this.delegateTreeService = delegateTreeService;
        }

        void closeProducers() {
            this.producersMap.values().forEach(NoopCloseDataProducer::closeDelegate);
        }

        public <T extends DOMDataTreeListener> ListenerRegistration<T> registerListener(T listener, Collection<DOMDataTreeIdentifier> subtrees, boolean allowRxMerges, Collection<DOMDataTreeProducer> producers) throws DOMDataTreeLoopException {
            return this.delegateTreeService.registerListener(listener, subtrees, allowRxMerges, producers);
        }

        public ClassToInstanceMap<DOMDataTreeServiceExtension> getExtensions() {
            return this.delegateTreeService.getExtensions();
        }

        public DOMDataTreeProducer createProducer(Collection<DOMDataTreeIdentifier> subtrees) {
            Preconditions.checkState((subtrees.size() == 1 ? 1 : 0) != 0);
            DOMDataTreeIdentifier treeId = subtrees.iterator().next();
            NoopCloseDataProducer producer = new NoopCloseDataProducer(this.delegateTreeService.createProducer(Collections.singleton(treeId)));
            this.producersMap.putIfAbsent(treeId.getDatastoreType(), producer);
            return producer;
        }
    }
}

