/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.concurrent.GuardedBy;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCursorAwareTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMDataTreeListener;
import org.opendaylight.mdsal.dom.api.DOMDataTreeProducer;
import org.opendaylight.mdsal.dom.api.DOMDataTreeProducerBusyException;
import org.opendaylight.mdsal.dom.api.DOMDataTreeProducerException;
import org.opendaylight.mdsal.dom.api.DOMDataTreeShard;
import org.opendaylight.mdsal.dom.broker.ProducerLayout;
import org.opendaylight.mdsal.dom.broker.ShardedDOMDataTree;
import org.opendaylight.mdsal.dom.broker.ShardedDOMDataTreeWriteTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ShardedDOMDataTreeProducer
implements DOMDataTreeProducer {
    private static final Logger LOG = LoggerFactory.getLogger(ShardedDOMDataTreeProducer.class);
    private final Set<DOMDataTreeIdentifier> subtrees;
    private final ShardedDOMDataTree dataTree;
    private static final AtomicReferenceFieldUpdater<ShardedDOMDataTreeProducer, ShardedDOMDataTreeWriteTransaction> CURRENT_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ShardedDOMDataTreeProducer.class, ShardedDOMDataTreeWriteTransaction.class, "currentTx");
    private volatile ShardedDOMDataTreeWriteTransaction currentTx;
    private static final AtomicReferenceFieldUpdater<ShardedDOMDataTreeProducer, ShardedDOMDataTreeWriteTransaction> OPEN_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ShardedDOMDataTreeProducer.class, ShardedDOMDataTreeWriteTransaction.class, "openTx");
    private volatile ShardedDOMDataTreeWriteTransaction openTx;
    private static final AtomicReferenceFieldUpdater<ShardedDOMDataTreeProducer, ShardedDOMDataTreeWriteTransaction> LAST_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ShardedDOMDataTreeProducer.class, ShardedDOMDataTreeWriteTransaction.class, "lastTx");
    private volatile ShardedDOMDataTreeWriteTransaction lastTx;
    private static final AtomicIntegerFieldUpdater<ShardedDOMDataTreeProducer> CLOSED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ShardedDOMDataTreeProducer.class, "closed");
    private volatile int closed;
    private volatile DOMDataTreeListener attachedListener;
    private volatile ProducerLayout layout;

    ShardedDOMDataTreeProducer(ShardedDOMDataTree dataTree, Collection<DOMDataTreeIdentifier> subtrees, Map<DOMDataTreeIdentifier, DOMDataTreeShard> shardMap) {
        this.dataTree = Objects.requireNonNull(dataTree);
        this.subtrees = ImmutableSet.copyOf(subtrees);
        this.layout = ProducerLayout.create(shardMap);
    }

    static DOMDataTreeProducer create(ShardedDOMDataTree dataTree, Collection<DOMDataTreeIdentifier> subtrees, Map<DOMDataTreeIdentifier, DOMDataTreeShard> shardMap) {
        return new ShardedDOMDataTreeProducer(dataTree, subtrees, shardMap);
    }

    private void checkNotClosed() {
        Preconditions.checkState((this.closed == 0 ? 1 : 0) != 0, (Object)"Producer is already closed");
    }

    private void checkIdle() {
        Preconditions.checkState((this.openTx == null ? 1 : 0) != 0, (String)"Transaction %s is still open", (Object)this.openTx);
    }

    void subshardAdded(Map<DOMDataTreeIdentifier, DOMDataTreeShard> shardMap) {
        this.checkIdle();
        this.layout = this.layout.reshard(shardMap);
    }

    public DOMDataTreeCursorAwareTransaction createTransaction(boolean isolated) {
        this.checkNotClosed();
        this.checkIdle();
        LOG.debug("Creating transaction from producer {}", (Object)this);
        ShardedDOMDataTreeWriteTransaction current = CURRENT_UPDATER.getAndSet(this, null);
        ShardedDOMDataTreeWriteTransaction ret = isolated ? this.createIsolatedTransaction(this.layout, current) : this.createReusedTransaction(this.layout, current);
        boolean success = OPEN_UPDATER.compareAndSet(this, null, ret);
        Preconditions.checkState((boolean)success, (String)"Illegal concurrent access to producer %s detected", (Object)this);
        return ret;
    }

    @GuardedBy(value="this")
    private ShardedDOMDataTreeWriteTransaction createTransaction(ProducerLayout local) {
        return new ShardedDOMDataTreeWriteTransaction(this, local.createTransactions(), local);
    }

    private synchronized ShardedDOMDataTreeWriteTransaction createIsolatedTransaction(ProducerLayout local, ShardedDOMDataTreeWriteTransaction current) {
        if (current != null) {
            this.submitTransaction(current);
        }
        return this.createTransaction(local);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShardedDOMDataTreeWriteTransaction createReusedTransaction(ProducerLayout local, ShardedDOMDataTreeWriteTransaction current) {
        if (current != null) {
            if (local.equals(current.getLayout())) {
                LOG.debug("Reusing previous transaction {} since there is still a transaction inflight", (Object)current.getIdentifier());
                return current;
            }
            ShardedDOMDataTreeProducer shardedDOMDataTreeProducer = this;
            synchronized (shardedDOMDataTreeProducer) {
                this.submitTransaction(current);
                return this.createTransaction(local);
            }
        }
        ShardedDOMDataTreeProducer shardedDOMDataTreeProducer = this;
        synchronized (shardedDOMDataTreeProducer) {
            return this.createTransaction(local);
        }
    }

    @GuardedBy(value="this")
    private void submitTransaction(ShardedDOMDataTreeWriteTransaction tx) {
        this.lastTx = tx;
        tx.doSubmit(this::transactionSuccessful, this::transactionFailed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DOMDataTreeProducer createProducer(Collection<DOMDataTreeIdentifier> subtrees) {
        DOMDataTreeProducer ret;
        this.checkNotClosed();
        this.checkIdle();
        ProducerLayout local = this.layout;
        for (DOMDataTreeIdentifier s : subtrees) {
            Preconditions.checkArgument((boolean)local.haveSubtree(s), (String)"Subtree %s was never available in producer %s", (Object)s, (Object)this);
            DOMDataTreeProducer child = local.lookupChild(s);
            Preconditions.checkArgument((child == null ? 1 : 0) != 0, (String)"Subtree %s is delegated to child producer %s", (Object)s, (Object)child);
            for (DOMDataTreeIdentifier c : local.getChildTrees()) {
                Preconditions.checkArgument((!s.contains(c) ? 1 : 0) != 0, (String)"Subtree %s cannot be delegated as it is a superset of already-delegated %s", (Object)s, (Object)c);
            }
        }
        ShardedDOMDataTreeProducer shardedDOMDataTreeProducer = this;
        synchronized (shardedDOMDataTreeProducer) {
            ret = this.dataTree.createProducer(this, subtrees);
        }
        this.layout = local.addChild(ret, subtrees);
        return ret;
    }

    boolean isDelegatedToChild(DOMDataTreeIdentifier path) {
        return this.layout.lookupChild(path) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws DOMDataTreeProducerException {
        if (this.openTx != null) {
            throw new DOMDataTreeProducerBusyException(String.format("Transaction %s is still open", this.openTx));
        }
        if (CLOSED_UPDATER.compareAndSet(this, 0, 1)) {
            ShardedDOMDataTreeProducer shardedDOMDataTreeProducer = this;
            synchronized (shardedDOMDataTreeProducer) {
                this.dataTree.destroyProducer(this);
                this.layout.close();
            }
        }
    }

    protected Set<DOMDataTreeIdentifier> getSubtrees() {
        return this.subtrees;
    }

    void cancelTransaction(ShardedDOMDataTreeWriteTransaction transaction) {
        boolean success = OPEN_UPDATER.compareAndSet(this, transaction, null);
        if (success) {
            LOG.debug("Transaction {} cancelled", (Object)transaction);
        } else {
            LOG.warn("Transaction {} is not open in producer {}", (Object)transaction, (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void transactionSubmitted(ShardedDOMDataTreeWriteTransaction transaction) {
        boolean wasOpen = OPEN_UPDATER.compareAndSet(this, transaction, null);
        Preconditions.checkState((boolean)wasOpen, (String)"Attempted to submit non-open transaction %s", (Object)transaction);
        if (this.lastTx == null) {
            ShardedDOMDataTreeProducer shardedDOMDataTreeProducer = this;
            synchronized (shardedDOMDataTreeProducer) {
                this.submitTransaction(transaction);
            }
            return;
        }
        boolean success = CURRENT_UPDATER.compareAndSet(this, null, transaction);
        Verify.verify((boolean)success);
        if (this.lastTx == null) {
            this.submitCurrentTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitCurrentTransaction() {
        ShardedDOMDataTreeWriteTransaction current = this.currentTx;
        if (current != null) {
            ShardedDOMDataTreeProducer shardedDOMDataTreeProducer = this;
            synchronized (shardedDOMDataTreeProducer) {
                if (CURRENT_UPDATER.compareAndSet(this, current, null)) {
                    this.submitTransaction(current);
                }
            }
        }
    }

    private void transactionSuccessful(ShardedDOMDataTreeWriteTransaction tx) {
        LOG.debug("Transaction {} completed successfully", (Object)tx.getIdentifier());
        tx.onTransactionSuccess(CommitInfo.empty());
        this.transactionCompleted(tx);
    }

    private void transactionFailed(ShardedDOMDataTreeWriteTransaction tx, Throwable throwable) {
        LOG.debug("Transaction {} failed", (Object)tx.getIdentifier(), (Object)throwable);
        tx.onTransactionFailure(throwable);
        this.transactionCompleted(tx);
    }

    private void transactionCompleted(ShardedDOMDataTreeWriteTransaction tx) {
        boolean wasLast = LAST_UPDATER.compareAndSet(this, tx, null);
        if (wasLast) {
            this.submitCurrentTransaction();
        }
    }

    void bindToListener(DOMDataTreeListener listener) {
        DOMDataTreeListener local = this.attachedListener;
        Preconditions.checkState((local == null ? 1 : 0) != 0, (String)"Producer %s is already attached to listener %s", (Object)this, (Object)local);
        this.attachedListener = Objects.requireNonNull(listener);
    }
}

