/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMDataTreeProducer;
import org.opendaylight.mdsal.dom.api.DOMDataTreeShard;
import org.opendaylight.mdsal.dom.spi.shard.DOMDataTreeShardProducer;
import org.opendaylight.mdsal.dom.spi.shard.DOMDataTreeShardWriteTransaction;
import org.opendaylight.mdsal.dom.spi.shard.WriteableDOMDataTreeShard;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ProducerLayout {
    private static final Logger LOG = LoggerFactory.getLogger(ProducerLayout.class);
    private final BiMap<DOMDataTreeIdentifier, DOMDataTreeShardProducer> idToProducer;
    private final Map<DOMDataTreeIdentifier, DOMDataTreeProducer> children;
    private final Map<DOMDataTreeIdentifier, DOMDataTreeShard> shardMap;

    private ProducerLayout(Map<DOMDataTreeIdentifier, DOMDataTreeShard> shardMap, BiMap<DOMDataTreeIdentifier, DOMDataTreeShardProducer> idToProducer, Map<DOMDataTreeIdentifier, DOMDataTreeProducer> children) {
        this.shardMap = ImmutableMap.copyOf(shardMap);
        this.idToProducer = Objects.requireNonNull(idToProducer);
        this.children = Objects.requireNonNull(children);
    }

    static ProducerLayout create(Map<DOMDataTreeIdentifier, DOMDataTreeShard> shardMap) {
        return new ProducerLayout(shardMap, ProducerLayout.mapIdsToProducer(shardMap), (Map<DOMDataTreeIdentifier, DOMDataTreeProducer>)ImmutableMap.of());
    }

    private static BiMap<DOMDataTreeIdentifier, DOMDataTreeShardProducer> mapIdsToProducer(Map<DOMDataTreeIdentifier, DOMDataTreeShard> shardMap) {
        ArrayListMultimap shardToId = ArrayListMultimap.create();
        for (Map.Entry<DOMDataTreeIdentifier, DOMDataTreeShard> entry : shardMap.entrySet()) {
            shardToId.put((Object)entry.getValue(), (Object)entry.getKey());
        }
        ImmutableBiMap.Builder idToProducerBuilder = ImmutableBiMap.builder();
        for (Map.Entry entry : shardToId.asMap().entrySet()) {
            if (entry.getKey() instanceof WriteableDOMDataTreeShard) {
                DOMDataTreeShardProducer producer = ((WriteableDOMDataTreeShard)entry.getKey()).createProducer((Collection)entry.getValue());
                for (DOMDataTreeIdentifier id : (Collection)entry.getValue()) {
                    idToProducerBuilder.put((Object)id, (Object)producer);
                }
                continue;
            }
            LOG.error("Unable to create a producer for shard that's not a WriteableDOMDataTreeShard");
        }
        return idToProducerBuilder.build();
    }

    ProducerLayout addChild(DOMDataTreeProducer producer, Collection<DOMDataTreeIdentifier> subtrees) {
        ImmutableMap.Builder cb = ImmutableMap.builder();
        cb.putAll(this.children);
        for (DOMDataTreeIdentifier s : subtrees) {
            cb.put((Object)s, (Object)producer);
        }
        return new ProducerLayout(this.shardMap, this.idToProducer, (Map<DOMDataTreeIdentifier, DOMDataTreeProducer>)cb.build());
    }

    ProducerLayout reshard(Map<DOMDataTreeIdentifier, DOMDataTreeShard> newShardMap) {
        this.close();
        return new ProducerLayout(newShardMap, ProducerLayout.mapIdsToProducer(newShardMap), this.children);
    }

    boolean haveSubtree(DOMDataTreeIdentifier subtree) {
        for (DOMDataTreeIdentifier i : this.shardMap.keySet()) {
            if (!i.contains(subtree)) continue;
            return true;
        }
        return false;
    }

    DOMDataTreeProducer lookupChild(DOMDataTreeIdentifier path) {
        for (Map.Entry<DOMDataTreeIdentifier, DOMDataTreeProducer> e : this.children.entrySet()) {
            if (!e.getKey().contains(path)) continue;
            return e.getValue();
        }
        return null;
    }

    Set<DOMDataTreeIdentifier> getChildTrees() {
        return this.children.keySet();
    }

    void checkAvailable(Collection<YangInstanceIdentifier.PathArgument> base, YangInstanceIdentifier.PathArgument child) {
        if (!this.children.isEmpty()) {
            ArrayList<YangInstanceIdentifier.PathArgument> args = new ArrayList<YangInstanceIdentifier.PathArgument>(base.size() + 1);
            args.addAll(base);
            args.add(child);
            YangInstanceIdentifier path = YangInstanceIdentifier.create(args);
            for (DOMDataTreeIdentifier c : this.children.keySet()) {
                Preconditions.checkArgument((!c.getRootIdentifier().contains(path) ? 1 : 0) != 0, (String)"Path {%s} is not available to this cursor since it's already claimed by a child producer", (Object)path);
            }
        }
    }

    Map<DOMDataTreeIdentifier, DOMDataTreeShardWriteTransaction> createTransactions() {
        Preconditions.checkState((!this.idToProducer.isEmpty() ? 1 : 0) != 0, (Object)"Cannot create transaction since the producer is not mapped to any shard");
        return Maps.transformValues(this.idToProducer, DOMDataTreeShardProducer::createTransaction);
    }

    void close() {
        this.idToProducer.values().forEach(DOMDataTreeShardProducer::close);
    }
}

