/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.lmax.disruptor.EventFactory;
import java.util.Collection;
import java.util.Objects;
import org.opendaylight.mdsal.dom.api.DOMNotification;
import org.opendaylight.mdsal.dom.api.DOMNotificationListener;
import org.opendaylight.yangtools.concepts.ListenerRegistration;

final class DOMNotificationRouterEvent {
    static final EventFactory<DOMNotificationRouterEvent> FACTORY = DOMNotificationRouterEvent::new;
    private Collection<ListenerRegistration<? extends DOMNotificationListener>> subscribers;
    private DOMNotification notification;
    private SettableFuture<Void> future;

    private DOMNotificationRouterEvent() {
    }

    ListenableFuture<Void> initialize(DOMNotification notification, Collection<ListenerRegistration<? extends DOMNotificationListener>> subscribers) {
        this.notification = Objects.requireNonNull(notification);
        this.subscribers = Objects.requireNonNull(subscribers);
        this.future = SettableFuture.create();
        return this.future;
    }

    void deliverNotification() {
        for (ListenerRegistration<? extends DOMNotificationListener> r : this.subscribers) {
            DOMNotificationListener l = (DOMNotificationListener)r.getInstance();
            if (l == null) continue;
            l.onNotification(this.notification);
        }
    }

    void setFuture() {
        this.future.set(null);
    }
}

