/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.InsufficientCapacityException;
import com.lmax.disruptor.PhasedBackoffWaitStrategy;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.opendaylight.mdsal.dom.api.DOMNotification;
import org.opendaylight.mdsal.dom.api.DOMNotificationListener;
import org.opendaylight.mdsal.dom.api.DOMNotificationPublishService;
import org.opendaylight.mdsal.dom.api.DOMNotificationService;
import org.opendaylight.mdsal.dom.broker.DOMNotificationRouterEvent;
import org.opendaylight.mdsal.dom.spi.DOMNotificationSubscriptionListener;
import org.opendaylight.mdsal.dom.spi.DOMNotificationSubscriptionListenerRegistry;
import org.opendaylight.yangtools.concepts.AbstractListenerRegistration;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.util.ListenerRegistry;
import org.opendaylight.yangtools.util.concurrent.FluentFutures;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DOMNotificationRouter
implements AutoCloseable,
DOMNotificationPublishService,
DOMNotificationService,
DOMNotificationSubscriptionListenerRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DOMNotificationRouter.class);
    private static final ListenableFuture<Void> NO_LISTENERS = FluentFutures.immediateNullFluentFuture();
    private static final WaitStrategy DEFAULT_STRATEGY = PhasedBackoffWaitStrategy.withLock((long)1L, (long)30L, (TimeUnit)TimeUnit.MILLISECONDS);
    private static final EventHandler<DOMNotificationRouterEvent> DISPATCH_NOTIFICATIONS = (event, sequence, endOfBatch) -> event.deliverNotification();
    private static final EventHandler<DOMNotificationRouterEvent> NOTIFY_FUTURE = (event, sequence, endOfBatch) -> event.setFuture();
    private final ListenerRegistry<DOMNotificationSubscriptionListener> subscriptionListeners = ListenerRegistry.create();
    private final Disruptor<DOMNotificationRouterEvent> disruptor;
    private final ScheduledThreadPoolExecutor observer;
    private final ExecutorService executor;
    private volatile Multimap<SchemaPath, ListenerRegistration<? extends DOMNotificationListener>> listeners = ImmutableMultimap.of();

    @VisibleForTesting
    DOMNotificationRouter(int queueDepth, WaitStrategy strategy) {
        this.observer = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("DOMNotificationRouter-observer-%d").build());
        this.executor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("DOMNotificationRouter-listeners-%d").build());
        this.disruptor = new Disruptor(DOMNotificationRouterEvent.FACTORY, queueDepth, new ThreadFactoryBuilder().setNameFormat("DOMNotificationRouter-disruptor-%d").build(), ProducerType.MULTI, strategy);
        this.disruptor.handleEventsWith(new EventHandler[]{DISPATCH_NOTIFICATIONS});
        this.disruptor.after(new EventHandler[]{DISPATCH_NOTIFICATIONS}).handleEventsWith(new EventHandler[]{NOTIFY_FUTURE});
        this.disruptor.start();
    }

    public static DOMNotificationRouter create(int queueDepth) {
        return new DOMNotificationRouter(queueDepth, DEFAULT_STRATEGY);
    }

    public static DOMNotificationRouter create(int queueDepth, long spinTime, long parkTime, TimeUnit unit) {
        Preconditions.checkArgument((Long.lowestOneBit(queueDepth) == Long.highestOneBit(queueDepth) ? 1 : 0) != 0, (String)"Queue depth %s is not power-of-two", (int)queueDepth);
        return new DOMNotificationRouter(queueDepth, (WaitStrategy)PhasedBackoffWaitStrategy.withLock((long)spinTime, (long)parkTime, (TimeUnit)unit));
    }

    public synchronized <T extends DOMNotificationListener> ListenerRegistration<T> registerNotificationListener(T listener, Collection<SchemaPath> types) {
        AbstractListenerRegistration reg = new AbstractListenerRegistration<T>(listener){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void removeRegistration() {
                DOMNotificationRouter dOMNotificationRouter = DOMNotificationRouter.this;
                synchronized (dOMNotificationRouter) {
                    DOMNotificationRouter.this.replaceListeners((Multimap<SchemaPath, ListenerRegistration<? extends DOMNotificationListener>>)((Multimap)ImmutableMultimap.copyOf((Multimap)Multimaps.filterValues((Multimap)DOMNotificationRouter.this.listeners, input -> input != this))));
                }
            }
        };
        if (!types.isEmpty()) {
            ImmutableMultimap.Builder b = ImmutableMultimap.builder();
            b.putAll(this.listeners);
            for (SchemaPath t : types) {
                b.put((Object)t, (Object)reg);
            }
            this.replaceListeners((Multimap<SchemaPath, ListenerRegistration<? extends DOMNotificationListener>>)b.build());
        }
        return reg;
    }

    public <T extends DOMNotificationListener> ListenerRegistration<T> registerNotificationListener(T listener, SchemaPath ... types) {
        return this.registerNotificationListener(listener, Arrays.asList(types));
    }

    private void replaceListeners(Multimap<SchemaPath, ListenerRegistration<? extends DOMNotificationListener>> newListeners) {
        this.listeners = newListeners;
        this.notifyListenerTypesChanged(newListeners.keySet());
    }

    private void notifyListenerTypesChanged(Set<SchemaPath> typesAfter) {
        ImmutableList listenersAfter = ImmutableList.copyOf((Iterable)this.subscriptionListeners.getListeners());
        this.executor.execute(() -> DOMNotificationRouter.lambda$notifyListenerTypesChanged$2((List)listenersAfter, typesAfter));
    }

    public <L extends DOMNotificationSubscriptionListener> ListenerRegistration<L> registerSubscriptionListener(L listener) {
        Set initialTypes = this.listeners.keySet();
        this.executor.execute(() -> listener.onSubscriptionChanged(initialTypes));
        return this.subscriptionListeners.registerWithType(listener);
    }

    private ListenableFuture<Void> publish(long seq, DOMNotification notification, Collection<ListenerRegistration<? extends DOMNotificationListener>> subscribers) {
        DOMNotificationRouterEvent event = (DOMNotificationRouterEvent)this.disruptor.get(seq);
        ListenableFuture<Void> future = event.initialize(notification, subscribers);
        this.disruptor.getRingBuffer().publish(seq);
        return future;
    }

    public ListenableFuture<? extends Object> putNotification(DOMNotification notification) throws InterruptedException {
        Collection subscribers = this.listeners.get((Object)notification.getType());
        if (subscribers.isEmpty()) {
            return NO_LISTENERS;
        }
        long seq = this.disruptor.getRingBuffer().next();
        return this.publish(seq, notification, subscribers);
    }

    @VisibleForTesting
    ListenableFuture<? extends Object> tryPublish(DOMNotification notification, Collection<ListenerRegistration<? extends DOMNotificationListener>> subscribers) {
        long seq;
        try {
            seq = this.disruptor.getRingBuffer().tryNext();
        }
        catch (InsufficientCapacityException e) {
            return DOMNotificationPublishService.REJECTED;
        }
        return this.publish(seq, notification, subscribers);
    }

    public ListenableFuture<? extends Object> offerNotification(DOMNotification notification) {
        Collection subscribers = this.listeners.get((Object)notification.getType());
        if (subscribers.isEmpty()) {
            return NO_LISTENERS;
        }
        return this.tryPublish(notification, subscribers);
    }

    public ListenableFuture<? extends Object> offerNotification(DOMNotification notification, long timeout, TimeUnit unit) throws InterruptedException {
        Collection subscribers = this.listeners.get((Object)notification.getType());
        if (subscribers.isEmpty()) {
            return NO_LISTENERS;
        }
        ListenableFuture<? extends Object> noBlock = this.tryPublish(notification, subscribers);
        if (!DOMNotificationPublishService.REJECTED.equals(noBlock)) {
            return noBlock;
        }
        try {
            Thread publishThread = Thread.currentThread();
            ScheduledFuture<?> timerTask = this.observer.schedule(publishThread::interrupt, timeout, unit);
            ListenableFuture<? extends Object> withBlock = this.putNotification(notification);
            timerTask.cancel(true);
            if (this.observer.getQueue().size() > 50) {
                this.observer.purge();
            }
            return withBlock;
        }
        catch (InterruptedException e) {
            return DOMNotificationPublishService.REJECTED;
        }
    }

    @Override
    public void close() {
        this.disruptor.shutdown();
        this.observer.shutdown();
        this.executor.shutdown();
    }

    @VisibleForTesting
    ExecutorService executor() {
        return this.executor;
    }

    @VisibleForTesting
    ExecutorService observer() {
        return this.observer;
    }

    @VisibleForTesting
    Multimap<SchemaPath, ?> listeners() {
        return this.listeners;
    }

    @VisibleForTesting
    ListenerRegistry<DOMNotificationSubscriptionListener> subscriptionListeners() {
        return this.subscriptionListeners;
    }

    private static /* synthetic */ void lambda$notifyListenerTypesChanged$2(List listenersAfter, Set typesAfter) {
        for (ListenerRegistration subListener : listenersAfter) {
            try {
                ((DOMNotificationSubscriptionListener)subListener.getInstance()).onSubscriptionChanged(typesAfter);
            }
            catch (Exception e) {
                LOG.warn("Uncaught exception during invoking listener {}", subListener.getInstance(), (Object)e);
            }
        }
    }
}

