/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker;

import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.TransactionCommitFailedException;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.broker.TransactionCommitFailedExceptionMapper;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.yangtools.util.DurationStatisticsTracker;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CommitCoordinationTask
implements Callable<CommitInfo> {
    private static final Logger LOG = LoggerFactory.getLogger(CommitCoordinationTask.class);
    private final Collection<DOMStoreThreePhaseCommitCohort> cohorts;
    private final DurationStatisticsTracker commitStatTracker;
    private final DOMDataTreeWriteTransaction tx;

    CommitCoordinationTask(DOMDataTreeWriteTransaction transaction, Collection<DOMStoreThreePhaseCommitCohort> cohorts, DurationStatisticsTracker commitStatTracker) {
        this.tx = Objects.requireNonNull(transaction, "transaction must not be null");
        this.cohorts = Objects.requireNonNull(cohorts, "cohorts must not be null");
        this.commitStatTracker = commitStatTracker;
    }

    @Override
    public CommitInfo call() throws TransactionCommitFailedException {
        long startTime = this.commitStatTracker != null ? System.nanoTime() : 0L;
        Phase phase = Phase.CAN_COMMIT;
        try {
            LOG.debug("Transaction {}: canCommit Started", this.tx.getIdentifier());
            this.canCommitBlocking();
            phase = Phase.PRE_COMMIT;
            LOG.debug("Transaction {}: preCommit Started", this.tx.getIdentifier());
            this.preCommitBlocking();
            phase = Phase.DO_COMMIT;
            LOG.debug("Transaction {}: doCommit Started", this.tx.getIdentifier());
            this.commitBlocking();
            LOG.debug("Transaction {}: doCommit completed", this.tx.getIdentifier());
            CommitInfo commitInfo = CommitInfo.empty();
            return commitInfo;
        }
        catch (TransactionCommitFailedException e) {
            LOG.warn("Tx: {} Error during phase {}, starting Abort", new Object[]{this.tx.getIdentifier(), phase, e});
            this.abortBlocking(e);
            throw e;
        }
        finally {
            if (this.commitStatTracker != null) {
                this.commitStatTracker.addDuration(System.nanoTime() - startTime);
            }
        }
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"})
    private void canCommitBlocking() throws TransactionCommitFailedException {
        for (ListenableFuture<?> canCommit : this.canCommitAll()) {
            try {
                Boolean result = (Boolean)canCommit.get();
                if (result != null && result.booleanValue()) continue;
                throw new TransactionCommitFailedException("Can Commit failed, no detailed cause available.", new RpcError[0]);
            }
            catch (InterruptedException | ExecutionException e) {
                throw (TransactionCommitFailedException)((Object)TransactionCommitFailedExceptionMapper.CAN_COMMIT_ERROR_MAPPER.apply(e));
            }
        }
    }

    private ListenableFuture<?>[] canCommitAll() {
        ListenableFuture[] ops = new ListenableFuture[this.cohorts.size()];
        int index = 0;
        for (DOMStoreThreePhaseCommitCohort cohort : this.cohorts) {
            ops[index++] = cohort.canCommit();
        }
        return ops;
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"})
    private void preCommitBlocking() throws TransactionCommitFailedException {
        ListenableFuture<?>[] preCommitFutures = this.preCommitAll();
        try {
            for (ListenableFuture<?> future : preCommitFutures) {
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw (TransactionCommitFailedException)((Object)TransactionCommitFailedExceptionMapper.PRE_COMMIT_MAPPER.apply(e));
        }
    }

    private ListenableFuture<?>[] preCommitAll() {
        ListenableFuture[] ops = new ListenableFuture[this.cohorts.size()];
        int index = 0;
        for (DOMStoreThreePhaseCommitCohort cohort : this.cohorts) {
            ops[index++] = cohort.preCommit();
        }
        return ops;
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"})
    private void commitBlocking() throws TransactionCommitFailedException {
        ListenableFuture<?>[] commitFutures = this.commitAll();
        try {
            for (ListenableFuture<?> future : commitFutures) {
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw (TransactionCommitFailedException)((Object)TransactionCommitFailedExceptionMapper.COMMIT_ERROR_MAPPER.apply(e));
        }
    }

    private ListenableFuture<?>[] commitAll() {
        ListenableFuture[] ops = new ListenableFuture[this.cohorts.size()];
        int index = 0;
        for (DOMStoreThreePhaseCommitCohort cohort : this.cohorts) {
            ops[index++] = cohort.commit();
        }
        return ops;
    }

    private void abortBlocking(TransactionCommitFailedException originalCause) throws TransactionCommitFailedException {
        Throwable cause = originalCause;
        try {
            this.abortAsyncAll().get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Tx: {} Error during Abort.", this.tx.getIdentifier(), (Object)e);
            cause = new IllegalStateException("Abort failed.", e);
            cause.addSuppressed(e);
        }
        Throwables.propagateIfPossible((Throwable)cause, TransactionCommitFailedException.class);
    }

    private ListenableFuture<Void> abortAsyncAll() {
        ListenableFuture[] ops = new ListenableFuture[this.cohorts.size()];
        int index = 0;
        for (DOMStoreThreePhaseCommitCohort cohort : this.cohorts) {
            ops[index++] = cohort.abort();
        }
        return Futures.allAsList((ListenableFuture[])ops);
    }

    private static enum Phase {
        CAN_COMMIT,
        PRE_COMMIT,
        DO_COMMIT;

    }
}

