/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

@Beta
abstract class AbstractDOMRoutingTableEntry<D, M, L extends EventListener> {
    private final Map<D, List<M>> implementations;
    private final SchemaPath type;

    AbstractDOMRoutingTableEntry(SchemaPath type, Map<D, List<M>> implementations) {
        this.type = Objects.requireNonNull(type);
        this.implementations = Objects.requireNonNull(implementations);
    }

    SchemaPath getType() {
        return this.type;
    }

    List<M> getImplementations(D identifier) {
        return this.implementations.get(identifier);
    }

    Map<D, List<M>> getImplementations() {
        return this.implementations;
    }

    @VisibleForTesting
    Set<D> registeredIdentifiers() {
        return this.implementations.keySet();
    }

    protected abstract Set<D> registeredIdentifiers(L var1);

    AbstractDOMRoutingTableEntry<D, M, L> add(M implementation, List<D> newOprs) {
        ImmutableMap.Builder vb = ImmutableMap.builder();
        for (Map.Entry<D, List<M>> ve : this.implementations.entrySet()) {
            if (newOprs.remove(ve.getKey())) {
                ArrayList<M> i = new ArrayList<M>(ve.getValue().size() + 1);
                i.addAll((Collection)ve.getValue());
                i.add(implementation);
                i.sort(this.implComparator());
                vb.put(ve.getKey(), i);
                continue;
            }
            vb.put(ve);
        }
        for (Map.Entry<Object, List<Object>> ii : newOprs) {
            ArrayList<M> impl = new ArrayList<M>(1);
            impl.add(implementation);
            vb.put(ii, impl);
        }
        return this.newInstance((Map<D, List<M>>)vb.build());
    }

    AbstractDOMRoutingTableEntry<D, M, L> remove(M implementation, List<D> removed) {
        ImmutableMap.Builder vb = ImmutableMap.builder();
        for (Map.Entry<D, List<M>> ve : this.implementations.entrySet()) {
            if (removed.remove(ve.getKey())) {
                ArrayList i = new ArrayList(ve.getValue());
                i.remove(implementation);
                if (i.isEmpty()) continue;
                vb.put(ve.getKey(), i);
                continue;
            }
            vb.put(ve);
        }
        ImmutableMap v = vb.build();
        return v.isEmpty() ? null : this.newInstance((Map<D, List<M>>)vb.build());
    }

    protected abstract Comparator<M> implComparator();

    protected abstract AbstractDOMRoutingTableEntry<D, M, L> newInstance(Map<D, List<M>> var1);
}

